/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.wizards.templates;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.google.common.base.Splitter;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.editors.layout.gle2.DomUtilities;
import org.eclipse.andmore.internal.editors.manifest.ManifestInfo;
import org.eclipse.andmore.internal.project.BaseProjectHelper;
import org.eclipse.andmore.internal.resources.ResourceNameValidator;
import org.eclipse.andmore.internal.wizards.newproject.ApplicationInfoPage;
import org.eclipse.andmore.internal.wizards.templates.TemplateMetadata;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.widgets.Control;
import org.w3c.dom.Element;

class Parameter {
    public final TemplateMetadata template;
    public final Type type;
    public final String id;
    public final String name;
    public final String initial;
    public final String suggest;
    public final String help;
    public Object value;
    public Control control;
    public ControlDecoration decoration;
    public boolean edited;
    public final Element element;
    public final EnumSet<Constraint> constraints;
    private IInputValidator mValidator;
    private boolean mNoValidator;
    private IProject mValidatorProject;

    Parameter(TemplateMetadata template, Element parameter) {
        this.template = template;
        this.element = parameter;
        String typeName = parameter.getAttribute("type");
        assert (typeName != null && !typeName.isEmpty()) : "type";
        this.type = Type.get(typeName);
        this.id = parameter.getAttribute("id");
        this.initial = parameter.getAttribute("default");
        this.suggest = parameter.getAttribute("suggest");
        this.name = parameter.getAttribute("name");
        this.help = parameter.getAttribute("help");
        String constraintString = parameter.getAttribute("constraints");
        if (constraintString != null && !constraintString.isEmpty()) {
            EnumSet<Constraint> constraintSet = null;
            for (String s : Splitter.on((char)'|').omitEmptyStrings().split((CharSequence)constraintString)) {
                Constraint constraint = Constraint.get(s);
                if (constraintSet == null) {
                    constraintSet = EnumSet.of(constraint);
                    continue;
                }
                constraintSet = EnumSet.copyOf(constraintSet);
                constraintSet.add(constraint);
            }
            this.constraints = constraintSet;
        } else {
            this.constraints = EnumSet.noneOf(Constraint.class);
        }
        this.value = this.initial != null && !this.initial.isEmpty() && this.type == Type.BOOLEAN ? Boolean.valueOf(this.initial) : this.initial;
    }

    Parameter(TemplateMetadata template, Type type, String id, String initialValue) {
        this.template = template;
        this.type = type;
        this.id = id;
        this.value = initialValue;
        this.element = null;
        this.initial = null;
        this.suggest = null;
        this.name = id;
        this.help = null;
        this.constraints = EnumSet.noneOf(Constraint.class);
    }

    List<Element> getOptions() {
        if (this.element != null) {
            return DomUtilities.getChildren(this.element);
        }
        return Collections.emptyList();
    }

    public IInputValidator getValidator(final IProject project) {
        if (this.mNoValidator) {
            return null;
        }
        if (project != this.mValidatorProject) {
            this.mValidator = null;
            this.mValidatorProject = project;
        }
        if (this.mValidator == null) {
            if (this.constraints.contains((Object)Constraint.LAYOUT)) {
                this.mValidator = project != null && this.constraints.contains((Object)Constraint.UNIQUE) ? ResourceNameValidator.create(false, project, ResourceType.LAYOUT) : ResourceNameValidator.create(false, ResourceFolderType.LAYOUT);
                return this.mValidator;
            }
            if (this.constraints.contains((Object)Constraint.STRING)) {
                this.mValidator = project != null && this.constraints.contains((Object)Constraint.UNIQUE) ? ResourceNameValidator.create(false, project, ResourceType.STRING) : ResourceNameValidator.create(false, ResourceFolderType.VALUES);
                return this.mValidator;
            }
            if (this.constraints.contains((Object)Constraint.ID)) {
                this.mValidator = project != null && this.constraints.contains((Object)Constraint.UNIQUE) ? ResourceNameValidator.create(false, project, ResourceType.ID) : ResourceNameValidator.create(false, ResourceFolderType.VALUES);
                return this.mValidator;
            }
            if (this.constraints.contains((Object)Constraint.DRAWABLE)) {
                this.mValidator = project != null && this.constraints.contains((Object)Constraint.UNIQUE) ? ResourceNameValidator.create(false, project, ResourceType.DRAWABLE) : ResourceNameValidator.create(false, ResourceFolderType.DRAWABLE);
                return this.mValidator;
            }
            if (this.constraints.contains((Object)Constraint.PACKAGE) || this.constraints.contains((Object)Constraint.CLASS) || this.constraints.contains((Object)Constraint.ACTIVITY)) {
                this.mValidator = new IInputValidator(){

                    public String isValid(String newText) {
                        IStatus status;
                        if ((newText = newText.trim()).isEmpty()) {
                            if (Parameter.this.constraints.contains((Object)Constraint.EMPTY)) {
                                return null;
                            }
                            if (Parameter.this.constraints.contains((Object)Constraint.NONEMPTY)) {
                                return String.format("Enter a value for %1$s", Parameter.this.name);
                            }
                            if (!"activityClass".equals(Parameter.this.id)) {
                                return null;
                            }
                        }
                        if (Parameter.this.constraints.contains((Object)Constraint.ACTIVITY)) {
                            status = ApplicationInfoPage.validateActivity(newText);
                        } else if (Parameter.this.constraints.contains((Object)Constraint.PACKAGE)) {
                            status = ApplicationInfoPage.validatePackage(newText);
                        } else {
                            if (!$assertionsDisabled && !Parameter.this.constraints.contains((Object)Constraint.CLASS)) {
                                throw new AssertionError();
                            }
                            status = ApplicationInfoPage.validateClass(newText);
                        }
                        if (status != null && !status.isOK()) {
                            return status.getMessage();
                        }
                        if (project != null && Parameter.this.constraints.contains((Object)Constraint.UNIQUE)) {
                            try {
                                IJavaProject p = BaseProjectHelper.getJavaProject(project);
                                if (p != null) {
                                    IType t;
                                    String fqcn = newText;
                                    if (fqcn.indexOf(46) == -1) {
                                        String pkg = null;
                                        Parameter parameter = Parameter.this.template.getParameter("packageName");
                                        pkg = parameter != null && parameter.value != null ? parameter.value.toString() : ManifestInfo.get(project).getPackage();
                                        String string = fqcn = pkg.isEmpty() ? newText : String.valueOf(pkg) + '.' + newText;
                                    }
                                    if ((t = p.findType(fqcn)) != null && t.exists()) {
                                        return String.format("%1$s already exists", newText);
                                    }
                                }
                            }
                            catch (CoreException e) {
                                AndmoreAndroidPlugin.log(e, null, new Object[0]);
                            }
                        }
                        return null;
                    }
                };
                return this.mValidator;
            }
            if (this.constraints.contains((Object)Constraint.NONEMPTY)) {
                this.mValidator = new IInputValidator(){

                    public String isValid(String newText) {
                        if (newText.trim().isEmpty()) {
                            return String.format("Enter a value for %1$s", Parameter.this.name);
                        }
                        return null;
                    }
                };
                return this.mValidator;
            }
            this.mNoValidator = true;
        }
        return this.mValidator;
    }

    static enum Constraint {
        UNIQUE,
        EXISTS,
        NONEMPTY,
        EMPTY,
        ACTIVITY,
        APILEVEL,
        CLASS,
        PACKAGE,
        LAYOUT,
        DRAWABLE,
        ID,
        STRING;


        /*
         * Unable to fully structure code
         */
        public static Constraint get(String name) {
            block4: {
                try {
                    return Constraint.valueOf(name.toUpperCase(Locale.US));
                }
                catch (IllegalArgumentException v0) {
                    AndmoreAndroidPlugin.printErrorToConsole("Unexpected template constraint '" + name + "'", new Object[0]);
                    if (name.indexOf(44) != -1) {
                        AndmoreAndroidPlugin.printErrorToConsole("Use | to separate constraints", new Object[0]);
                        break block4;
                    }
                    AndmoreAndroidPlugin.printErrorToConsole("Expected one of :", new Object[0]);
                    var4_1 = Constraint.values();
                    var3_2 = var4_1.length;
                    var2_3 = 0;
                    ** while (var2_3 < var3_2)
                }
lbl-1000:
                // 1 sources

                {
                    s = var4_1[var2_3];
                    AndmoreAndroidPlugin.printErrorToConsole("  " + s.name().toLowerCase(Locale.US), new Object[0]);
                    ++var2_3;
                    continue;
                }
            }
            return Constraint.NONEMPTY;
        }
    }

    static enum Type {
        STRING,
        BOOLEAN,
        ENUM,
        SEPARATOR;


        /*
         * Unable to fully structure code
         */
        public static Type get(String name) {
            try {
                return Type.valueOf(name.toUpperCase(Locale.US));
            }
            catch (IllegalArgumentException v0) {
                AndmoreAndroidPlugin.printErrorToConsole("Unexpected template type '" + name + "'", new Object[0]);
                AndmoreAndroidPlugin.printErrorToConsole("Expected one of :", new Object[0]);
                var4_1 = Type.values();
                var3_2 = var4_1.length;
                var2_3 = 0;
                ** while (var2_3 < var3_2)
            }
lbl-1000:
            // 1 sources

            {
                s = var4_1[var2_3];
                AndmoreAndroidPlugin.printErrorToConsole("  " + s.name().toLowerCase(Locale.US), new Object[0]);
                ++var2_3;
                continue;
            }
lbl14:
            // 1 sources

            return Type.STRING;
        }
    }
}

