/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.wizards.templates;

import org.eclipse.andmore.internal.wizards.templates.TemplateManager;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

class UpdateToolsPage
extends WizardPage
implements SelectionListener {
    private Button mInstallButton;

    UpdateToolsPage() {
        super("update");
        this.setTitle("Update Tools");
        this.validatePage();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label(container, 64);
        GridData layoutData = new GridData(16384, 128, true, true, 1, 1);
        layoutData.widthHint = 550;
        label.setLayoutData((Object)layoutData);
        label.setText("Your tools installation appears to be out of date (or not yet installed).\n\nThis wizard depends on templates distributed with the Android SDK Tools.\n\nPlease update the tools first (via Window > Android SDK Manager, or by using the \"android\" command in a terminal window). Note that on Windows you may need to restart the IDE, since there are some known problems where Windows locks the files held open by the running IDE, so the updater is unable to delete them in order to upgrade them.");
        this.mInstallButton = new Button(container, 0);
        this.mInstallButton.setText("Check Again");
        this.mInstallButton.addSelectionListener((SelectionListener)this);
    }

    public boolean isPageComplete() {
        return UpdateToolsPage.isUpToDate();
    }

    static boolean isUpToDate() {
        return TemplateManager.getTemplateRootFolder() != null;
    }

    private void validatePage() {
        boolean ok = UpdateToolsPage.isUpToDate();
        this.setPageComplete(ok);
        if (ok) {
            this.setErrorMessage(null);
            this.setMessage(null);
        } else {
            this.setErrorMessage("The tools need to be updated via the SDK Manager");
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() == this.mInstallButton) {
            this.validatePage();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

