/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.device.common.utilities;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sequoyah.device.common.utilities.FileUtil;
import org.eclipse.sequoyah.device.common.utilities.exception.SequoyahException;
import org.eclipse.sequoyah.device.common.utilities.exception.SequoyahExceptionHandler;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginUtils {
    public static IProject getSelectedProjectInWorkbench() {
        IProject iProject = null;
        try {
            IWorkbench iWorkbench = PlatformUI.getWorkbench();
            IWorkbenchWindow iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow();
            IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
            ISelection iSelection = iWorkbenchPage.getSelection();
            IResource iResource = PluginUtils.extractSelection(iSelection);
            if (iResource == null) {
                IEditorPart iEditorPart = iWorkbenchPage.getActiveEditor();
                IEditorInput iEditorInput = iEditorPart.getEditorInput();
                iResource = (IResource)iEditorInput.getAdapter(IResource.class);
            }
            iProject = iResource.getProject();
        }
        catch (Exception exception) {}
        return iProject;
    }

    public static IProject getSelectedProjectInWorkbench(ISelection iSelection) {
        IProject iProject = null;
        try {
            IWorkbench iWorkbench = PlatformUI.getWorkbench();
            IWorkbenchWindow iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow();
            IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
            IResource iResource = PluginUtils.extractSelection(iSelection);
            if (iResource == null) {
                IEditorPart iEditorPart = iWorkbenchPage.getActiveEditor();
                IEditorInput iEditorInput = iEditorPart.getEditorInput();
                iResource = (IResource)iEditorInput.getAdapter(IResource.class);
            }
            iProject = iResource.getProject();
        }
        catch (Exception exception) {}
        return iProject;
    }

    private static IResource extractSelection(ISelection iSelection) {
        if (!(iSelection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
        IResource iResource = (IResource)iStructuredSelection.getFirstElement();
        if (iResource instanceof IResource) {
            return iResource;
        }
        if (!(iResource instanceof IAdaptable)) {
            return null;
        }
        IResource iResource2 = iResource;
        Object object = iResource2.getAdapter(IResource.class);
        return (IResource)object;
    }

    public static Object getExecutable(String string, String string2) throws CoreException {
        Object object = null;
        IExtension iExtension = PluginUtils.getExtension(string);
        if (iExtension != null && string2 != null) {
            IConfigurationElement[] iConfigurationElementArray;
            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = iExtension.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
                if (string2.equals(iConfigurationElement.getName())) {
                    object = iConfigurationElement.createExecutableExtension("class");
                }
                ++n2;
            }
        }
        return object;
    }

    public static IExtension getExtension(String string, String string2) {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IExtension iExtension = iExtensionRegistry.getExtension(string, string2);
        return iExtension;
    }

    public static IExtension getExtension(String string) {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IExtension iExtension = iExtensionRegistry.getExtension(string);
        return iExtension;
    }

    public static String getExtensionLabel(String string, String string2) {
        IExtension iExtension = PluginUtils.getExtension(string, string2);
        String string3 = iExtension != null ? iExtension.getLabel() : string2;
        return string3;
    }

    public static String getExtensionLabel(String string) {
        IExtension iExtension = PluginUtils.getExtension(string);
        String string2 = iExtension != null ? iExtension.getLabel() : string;
        return string2;
    }

    public static Collection<String> getInstalledPlugins(String string) {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(string);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension iExtension = iExtensionArray[n2];
            linkedHashSet.add(iExtension.getUniqueIdentifier());
            ++n2;
        }
        return linkedHashSet;
    }

    public static Collection<IExtension> getInstalledExtensions(String string) {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(string);
        LinkedHashSet<IExtension> linkedHashSet = new LinkedHashSet<IExtension>();
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension iExtension = iExtensionArray[n2];
            linkedHashSet.add(iExtension);
            ++n2;
        }
        return linkedHashSet;
    }

    public static String[] getInstalledPluginsAsArray(String string) {
        Collection<String> collection = PluginUtils.getInstalledPlugins(string);
        String[] stringArray = new String[collection.size()];
        return collection.toArray(stringArray);
    }

    public static String getPluginAttribute(String string, String string2, String string3, String string4) {
        IExtension iExtension = PluginUtils.getExtension(string, string2);
        return PluginUtils.getPluginAttribute(iExtension, string3, string4);
    }

    public static String getPluginAttribute(String string, String string2, String string3) {
        IExtension iExtension = PluginUtils.getExtension(string);
        return PluginUtils.getPluginAttribute(iExtension, string2, string3);
    }

    public static String getPluginAttribute(IExtension iExtension, String string, String string2) {
        String string3 = null;
        if (iExtension != null) {
            IConfigurationElement[] iConfigurationElementArray;
            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = iExtension.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
                if (iConfigurationElement != null && iConfigurationElement.getName().equals(string)) {
                    string3 = iConfigurationElement.getAttribute(string2);
                }
                ++n2;
            }
        }
        return string3;
    }

    public static List<IConfigurationElement> getPluginElementList(IExtension iExtension, String string, String string2) {
        ArrayList<IConfigurationElement> arrayList = new ArrayList<IConfigurationElement>();
        if (iExtension != null) {
            IConfigurationElement[] iConfigurationElementArray;
            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = iExtension.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
                if (iConfigurationElement != null && iConfigurationElement.getName().equals(string)) {
                    IConfigurationElement[] iConfigurationElementArray3;
                    IConfigurationElement[] iConfigurationElementArray4 = iConfigurationElementArray3 = iConfigurationElement.getChildren(string2);
                    int n3 = iConfigurationElementArray3.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement iConfigurationElement2 = iConfigurationElementArray4[n4];
                        arrayList.add(iConfigurationElement2);
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return arrayList;
    }

    public static Object getExecutableAttribute(IExtension iExtension, String string, String string2) throws CoreException {
        Object object = null;
        if (iExtension != null) {
            IConfigurationElement[] iConfigurationElementArray;
            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = iExtension.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
                if (string.equals(iConfigurationElement.getName()) && iConfigurationElement.getAttribute(string2) != null && iConfigurationElement.getAttribute(string2).trim().length() > 0) {
                    object = iConfigurationElement.createExecutableExtension(string2);
                }
                ++n2;
            }
        }
        return object;
    }

    public static File getPluginInstallationPath(Plugin plugin) {
        Bundle bundle = plugin.getBundle();
        return PluginUtils.getPluginInstallationPath(bundle);
    }

    public static File getPluginInstallationPath(String string, String string2) {
        IExtension iExtension = PluginUtils.getExtension(string, string2);
        return PluginUtils.getPluginInstallationPath(iExtension);
    }

    public static File getPluginInstallationPath(IExtension iExtension) {
        String string = iExtension.getNamespaceIdentifier();
        Bundle bundle = Platform.getBundle((String)string);
        return PluginUtils.getPluginInstallationPath(bundle);
    }

    public static File getPluginInstallationPath(Bundle bundle) {
        String string = bundle.getLocation();
        int n = string.indexOf("file:");
        string = Platform.getOS().equals("win32") ? string.substring(n + 6) : string.substring(n + 5);
        File file = new File(string);
        return FileUtil.getCanonicalFile(file);
    }

    public static File getPluginResource(Plugin plugin, String string) throws SequoyahException {
        File file = null;
        try {
            File file2 = PluginUtils.getPluginInstallationPath(plugin);
            File file3 = new File(file2, string);
            file = FileUtil.getCanonicalFile(file3);
        }
        catch (Throwable throwable) {
            throw SequoyahExceptionHandler.exception(1001, throwable);
        }
        return file;
    }

    public static boolean isInstalled(String string, String string2) {
        return PluginUtils.getExtension(string, string2) != null;
    }

    public static boolean isInstalled(String string) {
        return PluginUtils.getExtension(string) != null;
    }
}

