/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.device.framework.ui.view.model;

import java.util.Comparator;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.sequoyah.device.framework.ui.view.model.ViewerInstanceNode;
import org.eclipse.sequoyah.device.framework.ui.view.provider.InstanceMgtViewLabelProvider;

public class InstanceMgtViewComparator
extends ViewerComparator {
    private int columnToSort = -1;
    private boolean isAscending = false;
    private InstanceMgtViewLabelProvider labelProvider;

    public InstanceMgtViewComparator(InstanceMgtViewLabelProvider instanceMgtViewLabelProvider) {
        this.labelProvider = instanceMgtViewLabelProvider;
    }

    public void setColumnToSort(int n) {
        this.columnToSort = n;
    }

    public void toggleAscending() {
        this.isAscending = !this.isAscending;
    }

    public boolean isAscending() {
        return this.isAscending;
    }

    public int compare(Viewer viewer, Object object, Object object2) {
        int n;
        if (object instanceof ViewerInstanceNode && object2 instanceof ViewerInstanceNode) {
            int n2 = ((TreeViewer)viewer).getTree().getColumnCount();
            if (this.columnToSort < 0 || this.columnToSort > n2) {
                n = super.compare(viewer, object, object2);
            } else {
                ViewerInstanceNode viewerInstanceNode = (ViewerInstanceNode)object;
                ViewerInstanceNode viewerInstanceNode2 = (ViewerInstanceNode)object2;
                String string = this.labelProvider.getText(viewerInstanceNode, this.columnToSort);
                String string2 = this.labelProvider.getText(viewerInstanceNode2, this.columnToSort);
                Comparator comparator = this.getComparator();
                n = this.isAscending ? comparator.compare(string, string2) : comparator.compare(string2, string);
            }
        } else {
            n = super.compare(viewer, object, object2);
        }
        return n;
    }
}

