/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.device.framework.ui.view.provider;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.sequoyah.device.framework.status.IStatus;
import org.eclipse.sequoyah.device.framework.status.StatusRegistry;
import org.eclipse.sequoyah.device.framework.ui.DeviceUIPlugin;
import org.eclipse.sequoyah.device.framework.ui.view.model.ViewerDeviceNode;
import org.eclipse.sequoyah.device.framework.ui.view.model.ViewerInstanceNode;
import org.eclipse.swt.graphics.Image;

public class InstanceMgtViewLabelProvider
extends ColumnLabelProvider {
    public static final int INSTANCE_COLUMN_NUMBER = 0;
    public static final int STATUS_COLUMN_NUMBER = 1;
    private static final String NO_INSTANCE_NAME = "<none>";
    protected int columnIndex;
    protected int firstColumnIndex;
    private Map<ImageDescriptor, Image> imageCache = new HashMap<ImageDescriptor, Image>(20);

    public void setFirstColumnIndex(int n) {
        this.firstColumnIndex = n;
    }

    public int getFirstColumnIndex() {
        return this.firstColumnIndex;
    }

    protected boolean isProvidingForFirstColumn() {
        return this.firstColumnIndex == this.columnIndex;
    }

    public String getText(Object object) {
        String string = "";
        if (object instanceof ViewerInstanceNode) {
            ViewerInstanceNode viewerInstanceNode = (ViewerInstanceNode)object;
            string = this.getText(viewerInstanceNode, this.columnIndex);
        } else if (object instanceof ViewerDeviceNode && this.isProvidingForFirstColumn()) {
            ViewerDeviceNode viewerDeviceNode = (ViewerDeviceNode)object;
            string = viewerDeviceNode.getDevice().getLabel();
        }
        return string;
    }

    public String getText(ViewerInstanceNode viewerInstanceNode, int n) {
        String string = "";
        if (viewerInstanceNode.containsInstance()) {
            if (n == 0) {
                string = viewerInstanceNode.getInstanceName();
            } else if (n == 1) {
                String string2 = viewerInstanceNode.getInstanceStatus();
                string = StatusRegistry.getInstance().getStatus(string2).getName();
            }
        } else if (this.isProvidingForFirstColumn()) {
            string = NO_INSTANCE_NAME;
        }
        return string;
    }

    public Image getImage(Object object) {
        ImageDescriptor imageDescriptor = null;
        Image image = null;
        if (object instanceof ViewerInstanceNode) {
            ViewerInstanceNode viewerInstanceNode = (ViewerInstanceNode)object;
            if (viewerInstanceNode.containsInstance()) {
                if (this.columnIndex == 0) {
                    imageDescriptor = DeviceUIPlugin.getDefault().getImageDescriptor("ICON_DEVICE");
                } else if (this.columnIndex == 1) {
                    IStatus iStatus = StatusRegistry.getInstance().getStatus(viewerInstanceNode.getInstanceStatus());
                    imageDescriptor = iStatus.getImage();
                }
            }
        } else if (object instanceof ViewerDeviceNode && this.isProvidingForFirstColumn()) {
            ViewerDeviceNode viewerDeviceNode = (ViewerDeviceNode)object;
            image = viewerDeviceNode.getDevice().getImage();
            return image;
        }
        if (imageDescriptor != null && (image = this.imageCache.get(imageDescriptor)) == null) {
            image = imageDescriptor.createImage();
            this.imageCache.put(imageDescriptor, image);
        }
        return image;
    }

    public void update(ViewerCell viewerCell) {
        this.columnIndex = viewerCell.getColumnIndex();
        super.update(viewerCell);
        this.columnIndex = this.firstColumnIndex;
    }

    public String getToolTipText(Object object) {
        String string;
        ViewerInstanceNode viewerInstanceNode;
        IInstance iInstance;
        String string2 = null;
        if (object != null && object instanceof ViewerInstanceNode && (iInstance = (viewerInstanceNode = (ViewerInstanceNode)object).getInstance()) != null && (string = iInstance.getStatus()) != null) {
            string2 = StatusRegistry.getInstance().getTooltipTextForStatus(string);
        }
        return string2;
    }

    public int getToolTipDisplayDelayTime(Object object) {
        return 0;
    }

    public int getToolTipTimeDisplayed(Object object) {
        return 5000;
    }
}

