/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.editor.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CellNavigationStrategy;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationListener;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.TreeViewerFocusCellManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sequoyah.device.common.utilities.BasePlugin;
import org.eclipse.sequoyah.device.common.utilities.exception.SequoyahException;
import org.eclipse.sequoyah.localization.editor.EditorExtensionLoader;
import org.eclipse.sequoyah.localization.editor.StringEditorPlugin;
import org.eclipse.sequoyah.localization.editor.datatype.CellInfo;
import org.eclipse.sequoyah.localization.editor.datatype.ColumnInfo;
import org.eclipse.sequoyah.localization.editor.datatype.IModelChangedListener;
import org.eclipse.sequoyah.localization.editor.datatype.RowInfo;
import org.eclipse.sequoyah.localization.editor.datatype.RowInfoLeaf;
import org.eclipse.sequoyah.localization.editor.i18n.Messages;
import org.eclipse.sequoyah.localization.editor.model.CellEditingSupport;
import org.eclipse.sequoyah.localization.editor.model.EditorSession;
import org.eclipse.sequoyah.localization.editor.model.StringEditorCellHighlighter;
import org.eclipse.sequoyah.localization.editor.model.StringEditorColumnLabelProvider;
import org.eclipse.sequoyah.localization.editor.model.StringEditorColumnViewerEditorActivationListener;
import org.eclipse.sequoyah.localization.editor.model.StringEditorViewerContentProvider;
import org.eclipse.sequoyah.localization.editor.model.StringEditorViewerEditableTooltipSupport;
import org.eclipse.sequoyah.localization.editor.model.StringEditorViewerEditorActivationStrategy;
import org.eclipse.sequoyah.localization.editor.model.StringEditorViewerModel;
import org.eclipse.sequoyah.localization.editor.model.TreeComparator;
import org.eclipse.sequoyah.localization.editor.model.actions.AddArrayAction;
import org.eclipse.sequoyah.localization.editor.model.actions.AddArrayItemAction;
import org.eclipse.sequoyah.localization.editor.model.actions.AddColumnAction;
import org.eclipse.sequoyah.localization.editor.model.actions.AddSingleStringAction;
import org.eclipse.sequoyah.localization.editor.model.actions.CloneColumnAction;
import org.eclipse.sequoyah.localization.editor.model.actions.CollapseExpandAllAction;
import org.eclipse.sequoyah.localization.editor.model.actions.HideShowAllColumnsAction;
import org.eclipse.sequoyah.localization.editor.model.actions.HideShowColumnAction;
import org.eclipse.sequoyah.localization.editor.model.actions.MenuDropDownAction;
import org.eclipse.sequoyah.localization.editor.model.actions.RemoveColumnAction;
import org.eclipse.sequoyah.localization.editor.model.actions.RemoveKeyAction;
import org.eclipse.sequoyah.localization.editor.model.actions.RevertToSavedAction;
import org.eclipse.sequoyah.localization.editor.model.actions.TranslateCellAction;
import org.eclipse.sequoyah.localization.editor.model.actions.TranslateColumnAction;
import org.eclipse.sequoyah.localization.editor.model.input.AbstractStringEditorInput;
import org.eclipse.sequoyah.localization.editor.model.input.IInputChangeListener;
import org.eclipse.sequoyah.localization.editor.model.operations.EditorOperation;
import org.eclipse.sequoyah.localization.editor.model.operations.RevertColumnToSavedStateOperation;
import org.eclipse.sequoyah.localization.editor.providers.ContentProvider;
import org.eclipse.sequoyah.localization.editor.providers.ICellValidator;
import org.eclipse.sequoyah.localization.editor.providers.IOperationProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringEditorPart
extends MultiPageEditorPart {
    private AddSingleStringAction newSingleStringAction = null;
    private AddArrayAction newArrayAction = null;
    private AddArrayItemAction newArrayItemAction = null;
    private RemoveKeyAction removeKeyAction = null;
    private MenuDropDownAction menuArrayItem = null;
    private CollapseExpandAllAction collapseAllAction;
    private CollapseExpandAllAction expandAllAction;
    private final IUndoContext undoContext;
    private final IOperationHistory operationHistory;
    private final Set<String> changedColumns = new HashSet<String>();
    private boolean needToPromptFileSystemChange = false;
    private final IInputChangeListener inputChangeListener = new IInputChangeListener(){

        public void columnChanged(String string) {
            StringEditorPart.this.markColumnAsChanged(string);
        }
    };
    private TreeViewer viewer = null;
    private static final int SIZE_HINT = 14;
    private ColumnSelectionListener listener;
    private int activeColumn;
    private ViewerCell activeRow = null;
    private ContentProvider contentProvider;
    private EditorSession session;
    private static String SORTER_PROPERTY_NAME = "sorter";
    private static String PREVIOUS_WIDTH_PROPERTY_NAME = "previous.width";
    private IProject associatedProject = null;
    private Button highlightChangesButton = null;
    private Button expandRowButton = null;
    private boolean highlightChanges = false;
    private boolean expandRow = true;
    private Text searchText = null;
    private String searchString = "";
    private Button showCellCommentsButton = null;
    private boolean showCellComments = false;
    private Text filterByKeyText = null;
    private String filterByKeyString = "";
    private Button applyFilterButton = null;
    private Form editorComposite;
    private Image errorImage;
    private Image warningImage;
    private Image okImage;
    private boolean pageChangedWithDirtySourceEditors = false;

    public StringEditorPart() {
        this.undoContext = new ObjectUndoContext((Object)this);
        this.operationHistory = OperationHistoryFactory.getOperationHistory();
    }

    public IUndoContext getUndoContext() {
        return this.undoContext;
    }

    public IProject getAssociatedProject() {
        return this.associatedProject;
    }

    public IOperationHistory getOperationHistory() {
        return this.operationHistory;
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        try {
            IFile iFile = ((IFileEditorInput)iEditorInput).getFile();
            this.contentProvider = EditorExtensionLoader.getInstance().getContentProviderForFileInput(iFile);
            if (this.contentProvider == null) {
                throw new Exception("An input provider for the given file was not found: " + ((IFileEditorInput)iEditorInput).getFile().getLocation().toOSString());
            }
            AbstractStringEditorInput abstractStringEditorInput = this.contentProvider.getEditorInput();
            IOperationProvider iOperationProvider = this.contentProvider.getOperationProvider();
            ICellValidator iCellValidator = this.contentProvider.getValidator();
            abstractStringEditorInput.init(iFile.getProject());
            iOperationProvider.init(iFile.getProject());
            iCellValidator.init(iFile.getProject());
            this.session = EditorSession.loadFromProject(iFile.getProject());
            this.associatedProject = iFile.getProject();
            this.setSite((IWorkbenchPartSite)iEditorSite);
            this.setInput(abstractStringEditorInput);
            this.setPartName(abstractStringEditorInput.getTitle());
            abstractStringEditorInput.addInputChangeListener(this.inputChangeListener);
            this.errorImage = new Image((Device)Display.getDefault(), PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK").getImageData().scaledTo(16, 16));
            this.warningImage = new Image((Device)Display.getDefault(), PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK").getImageData().scaledTo(16, 16));
            if (StringEditorPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sequoyah.localization.editor", (String)"icons/obj16_ok.png") != null) {
                this.okImage = new Image((Device)Display.getDefault(), StringEditorPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sequoyah.localization.editor", (String)"icons/obj16_ok.png").getImageData());
            } else {
                BasePlugin.logWarning((String)"Could not find icons/obj16_ok.png file on plugin org.eclipse.sequoyah.localization.editor");
            }
        }
        catch (Exception exception) {
            this.handleInitFailure(exception, iEditorInput, iEditorSite);
            throw new PartInitException(Messages.StringEditorPart_ErrorOpeningEditor, (Throwable)exception);
        }
    }

    private void handleInitFailure(Exception exception, IEditorInput iEditorInput, IEditorSite iEditorSite) {
        String string = null;
        string = exception.getMessage() != null ? exception.getLocalizedMessage() : Messages.StringEditorPart_ErrorOpeningEditorUnknown;
        MessageDialog.openError((Shell)iEditorSite.getShell(), (String)Messages.StringEditorPart_ErrorOpeningEditor, (String)string);
        IEditorDescriptor[] iEditorDescriptorArray = PlatformUI.getWorkbench().getEditorRegistry().getEditors("*." + ((IFileEditorInput)iEditorInput).getFile().getLocation().getFileExtension());
        if (iEditorDescriptorArray.length > 0) {
            int n = 0;
            IEditorDescriptor iEditorDescriptor = null;
            while (n < iEditorDescriptorArray.length && iEditorDescriptor == null) {
                if (!iEditorDescriptorArray[n].getId().equals(iEditorSite.getId())) {
                    iEditorDescriptor = iEditorDescriptorArray[n];
                }
                ++n;
            }
            if (iEditorDescriptor != null) {
                try {
                    iEditorSite.getPage().openEditor(iEditorInput, iEditorDescriptor.getId());
                }
                catch (PartInitException partInitException) {}
            }
        }
    }

    public IProgressMonitor getProgressMonitor() {
        return this.getEditorSite().getActionBars().getStatusLineManager().getProgressMonitor();
    }

    private void createOptionsSection(FormToolkit formToolkit, final Form form) {
        GridData gridData = new GridData(4, 4, true, false, 4, 1);
        GridLayout gridLayout = new GridLayout(5, false);
        ExpandableComposite expandableComposite = formToolkit.createExpandableComposite(form.getBody(), 2);
        expandableComposite.setLayoutData((Object)gridData);
        expandableComposite.setText(Messages.StringEditorPart_OptionsText);
        expandableComposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent expansionEvent) {
                form.layout(true);
            }
        });
        gridData = new GridData(4, 4, true, false, 6, 1);
        Composite composite = formToolkit.createComposite((Composite)expandableComposite);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)gridLayout);
        expandableComposite.setClient((Control)composite);
        this.expandRowButton = formToolkit.createButton(composite, Messages.StringEditorPart_ExpandRows, 32);
        gridData = new GridData(4, 4, true, false, 2, 1);
        this.expandRowButton.setLayoutData((Object)gridData);
        this.expandRowButton.setSelection(new Boolean(this.expandRow).booleanValue());
        this.expandRowButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                StringEditorPart.this.expandRow = ((Button)selectionEvent.widget).getSelection();
                StringEditorPart.this.viewer.getTree().redraw();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        Label label = formToolkit.createLabel(composite, String.valueOf(Messages.StringEditorPart_SearchLabel) + ": ");
        gridData = new GridData(131072, 0x1000000, true, false, 1, 1);
        label.setLayoutData((Object)gridData);
        this.searchText = formToolkit.createText(composite, "", 2048);
        gridData = new GridData(4, 0x1000000, true, false, 2, 1);
        this.searchText.setLayoutData((Object)gridData);
        this.searchText.addModifyListener((ModifyListener)new SearchTextModifyListener());
        this.showCellCommentsButton = formToolkit.createButton(composite, Messages.StringEditorPart_ShowCellCommentsButtonText, 32);
        gridData = new GridData(4, 4, true, false, 2, 1);
        this.showCellCommentsButton.setLayoutData((Object)gridData);
        this.showCellCommentsButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                StringEditorPart.this.showCellComments = ((Button)selectionEvent.widget).getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        Label label2 = formToolkit.createLabel(composite, String.valueOf(Messages.StringEditorPart_FilterByKeyLabel) + ": ");
        gridData = new GridData(131072, 0x1000000, true, false, 1, 1);
        label2.setLayoutData((Object)gridData);
        this.filterByKeyText = formToolkit.createText(composite, "", 2048);
        gridData = new GridData(4, 0x1000000, true, false, 1, 1);
        this.filterByKeyText.setLayoutData((Object)gridData);
        this.filterByKeyText.addModifyListener((ModifyListener)new FilterByKeyTextModifyListener());
        this.filterByKeyText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 13) {
                    StringEditorPart.this.getEditorViewer().refresh();
                }
            }
        });
        this.applyFilterButton = formToolkit.createButton(composite, Messages.StringEditorPart_Apply, 8);
        gridData = new GridData(131072, 0x1000000, false, false, 1, 1);
        this.applyFilterButton.setLayoutData((Object)gridData);
        this.applyFilterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                StringEditorPart.this.getEditorViewer().refresh();
            }
        });
        this.highlightChangesButton = formToolkit.createButton(composite, Messages.StringEditorPart_HighlightChangesLabel, 32);
        gridData = new GridData(4, 4, true, false, 2, 1);
        this.highlightChangesButton.setLayoutData((Object)gridData);
        this.highlightChangesButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                StringEditorPart.this.highlightChanges = ((Button)selectionEvent.widget).getSelection();
                for (RowInfo rowInfo : StringEditorPart.this.getModel().getRows().values()) {
                    if (rowInfo instanceof RowInfoLeaf) {
                        StringEditorPart.this.viewer.update((Object)rowInfo, null);
                        continue;
                    }
                    for (RowInfoLeaf rowInfoLeaf : rowInfo.getChildren()) {
                        StringEditorPart.this.viewer.update((Object)rowInfoLeaf, null);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
    }

    private IEditorPart addPage(IFile iFile) throws PartInitException {
        TextEditor textEditor = new TextEditor();
        int n = this.addPage((IEditorPart)textEditor, (IEditorInput)new FileEditorInput(iFile));
        this.setPageText(n, this.getEditorInput().getSourcePageNameForFile(iFile));
        return textEditor;
    }

    protected void createPages() {
        this.addPage((Control)this.createMainControl(this.getContainer()));
        this.setPageText(0, this.getEditorInput().getName());
        for (IFile iFile : this.getEditorInput().getFiles()) {
            try {
                this.addPage(iFile);
            }
            catch (PartInitException partInitException) {
                BasePlugin.logError((String)"Impossible to add a new page to the String Editor", (Throwable)partInitException);
            }
        }
    }

    private void registerActionHandlers() {
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)new UndoActionHandler((IWorkbenchPartSite)this.getEditorSite(), this.getUndoContext()));
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)new RedoActionHandler((IWorkbenchPartSite)this.getEditorSite(), this.getUndoContext()));
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.SAVE.getId(), (IAction)ActionFactory.SAVE.create(this.getEditorSite().getWorkbenchWindow()));
    }

    public Composite createMainControl(Composite composite) {
        FormToolkit formToolkit = new FormToolkit(composite.getDisplay());
        AbstractStringEditorInput abstractStringEditorInput = this.getEditorInput();
        List<ColumnInfo> list = abstractStringEditorInput.getColumns();
        this.editorComposite = formToolkit.createForm(composite);
        this.editorComposite.setText(abstractStringEditorInput.getName() != null && abstractStringEditorInput.getName().trim().length() > 0 ? abstractStringEditorInput.getName() : Messages.StringEditorPart_EditorTitle);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.horizontalSpacing = 0;
        this.editorComposite.getBody().setLayout((Layout)gridLayout);
        this.createOptionsSection(formToolkit, this.editorComposite);
        GridData gridData = new GridData(16384, 0x1000000, false, false, 1, 1);
        Label label = formToolkit.createLabel(this.editorComposite.getBody(), Messages.StringEditorPart_7, 1);
        label.setLayoutData((Object)gridData);
        FontData[] fontDataArray = label.getFont().getFontData();
        fontDataArray[0].setStyle(1);
        label.setFont(new Font((Device)label.getDisplay(), fontDataArray));
        ToolBar toolBar = new ToolBar(this.editorComposite.getBody(), 0x820000);
        gridData = new GridData(4, 0x1000000, true, false, 5, 1);
        toolBar.setLayoutData((Object)gridData);
        formToolkit.adapt((Composite)toolBar);
        ToolBarManager toolBarManager = new ToolBarManager(toolBar);
        this.newSingleStringAction = new AddSingleStringAction(this);
        toolBarManager.add((IAction)new MenuDropDownAction(this.newSingleStringAction, this.newSingleStringAction.getImageDescriptor()));
        toolBarManager.add((IContributionItem)new Separator());
        this.newArrayAction = new AddArrayAction(this);
        toolBarManager.add((IAction)new MenuDropDownAction(this.newArrayAction, this.newArrayAction.getImageDescriptor()));
        this.newArrayItemAction = new AddArrayItemAction(this);
        this.menuArrayItem = new MenuDropDownAction(this.newArrayItemAction, this.newArrayItemAction.getImageDescriptor());
        toolBarManager.add((IAction)this.menuArrayItem);
        toolBarManager.add((IContributionItem)new Separator());
        this.removeKeyAction = new RemoveKeyAction(this);
        toolBarManager.add((IAction)this.removeKeyAction);
        toolBarManager.add((IContributionItem)new Separator());
        this.collapseAllAction = new CollapseExpandAllAction(this, false, Messages.StringEditorPart_8, Messages.StringEditorPart_9);
        toolBarManager.add((IAction)this.collapseAllAction);
        this.expandAllAction = new CollapseExpandAllAction(this, true, Messages.StringEditorPart_10, Messages.StringEditorPart_11);
        toolBarManager.add((IAction)this.expandAllAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)new UndoActionHandler((IWorkbenchPartSite)this.getEditorSite(), this.getUndoContext()));
        toolBarManager.add((IAction)new RedoActionHandler((IWorkbenchPartSite)this.getEditorSite(), this.getUndoContext()));
        toolBarManager.update(true);
        Tree tree = formToolkit.createTree(this.editorComposite.getBody(), 101122);
        this.viewer = new TreeViewer(tree);
        gridData = new GridData(4, 4, true, true, 4, 1);
        this.viewer.getTree().setLayoutData((Object)gridData);
        this.listener = new ColumnSelectionListener(this.viewer);
        this.createColumn(Messages.StringEditorPart_KeyLabel, Messages.StringEditorPart_KeyTooltip, 0).getColumn().setMoveable(false);
        this.restoreSession(list);
        TreeComparator treeComparator = new TreeComparator();
        this.viewer.setComparator((ViewerComparator)treeComparator);
        this.viewer.getTree().setSortDirection(1024);
        this.viewer.setContentProvider((IContentProvider)new StringEditorViewerContentProvider());
        this.viewer.setInput((Object)new StringEditorViewerModel(list, this.getContentProvider().getValidator()));
        this.viewer.getTree().setLinesVisible(true);
        this.viewer.getTree().setHeaderVisible(true);
        StringEditorViewerEditableTooltipSupport.enableFor((ColumnViewer)this.viewer, 2, this);
        final MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                StringEditorPart.this.fillContextMenu(iMenuManager);
            }
        });
        this.viewer.getControl().addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent menuDetectEvent) {
                int n = ((StringEditorPart)StringEditorPart.this).viewer.getTree().toControl((int)menuDetectEvent.x, (int)menuDetectEvent.y).x;
                int n2 = 0;
                int n3 = 0;
                while (n3 < StringEditorPart.this.viewer.getTree().getColumnCount()) {
                    if (n <= (n2 += StringEditorPart.this.viewer.getTree().getColumn(n3).getWidth())) {
                        StringEditorPart.this.activeColumn = n3;
                        int n4 = ((StringEditorPart)StringEditorPart.this).viewer.getTree().toControl((int)menuDetectEvent.x, (int)menuDetectEvent.y).x;
                        int n5 = ((StringEditorPart)StringEditorPart.this).viewer.getTree().toControl((int)menuDetectEvent.x, (int)menuDetectEvent.y).y;
                        StringEditorPart.this.activeRow = StringEditorPart.this.viewer.getCell(new Point(n4, n5));
                        break;
                    }
                    ++n3;
                }
                if (n >= n2) {
                    StringEditorPart.this.activeColumn = 0;
                }
                StringEditorPart.this.viewer.getControl().setMenu(menuManager.createContextMenu(StringEditorPart.this.viewer.getControl()));
            }
        });
        this.viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object object, Object object2) {
                return ((RowInfo)object2).getKey().toLowerCase().contains(StringEditorPart.this.getKeyFilter().toLowerCase());
            }
        });
        StringEditorViewerEditorActivationStrategy stringEditorViewerEditorActivationStrategy = new StringEditorViewerEditorActivationStrategy((ColumnViewer)this.viewer);
        stringEditorViewerEditorActivationStrategy.setEnableEditorActivationWithKeyboard(true);
        StringEditorCellHighlighter stringEditorCellHighlighter = new StringEditorCellHighlighter(this.viewer);
        CellNavigationStrategy cellNavigationStrategy = new CellNavigationStrategy();
        TreeViewerFocusCellManager treeViewerFocusCellManager = new TreeViewerFocusCellManager(this.viewer, (FocusCellHighlighter)stringEditorCellHighlighter, cellNavigationStrategy);
        TreeViewerEditor.create((TreeViewer)this.viewer, (SWTFocusCellManager)treeViewerFocusCellManager, (ColumnViewerEditorActivationStrategy)stringEditorViewerEditorActivationStrategy, (int)58);
        this.viewer.getColumnViewerEditor().addEditorActivationListener((ColumnViewerEditorActivationListener)new StringEditorColumnViewerEditorActivationListener(this.viewer));
        this.viewer.getTree().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                StringEditorPart.this.session.clean();
                StringEditorPart.this.saveSession();
                StringEditorPart.this.saveOptions();
                StringEditorPart.this.session.save();
            }
        });
        this.viewer.getTree().layout(true, true);
        this.restoreOptions();
        this.session.clean();
        this.saveOptions();
        this.saveSession();
        this.session.save();
        this.setEditorStatus(this.getEditorInput().validate());
        this.getModel().addListener(new IModelChangedListener(){

            public void modelChanged(StringEditorViewerModel stringEditorViewerModel) {
                StringEditorPart.this.setEditorStatus(StringEditorPart.this.getEditorInput().validate());
            }
        });
        if (this.contentProvider.getContextHelpID() != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.viewer.getTree(), this.contentProvider.getContextHelpID());
        }
        this.viewer.getTree().addListener(41, new Listener(){
            final int TEXT_MARGIN = 3;

            public void handleEvent(Event event) {
                TreeItem treeItem = (TreeItem)event.item;
                String string = treeItem.getText(event.index);
                Point point = event.gc.textExtent(string);
                event.width = StringEditorPart.this.viewer.getTree().getColumn(event.index).getWidth() - 1;
                if (event.index == 0) {
                    event.width -= 3;
                }
                if (StringEditorPart.this.expandRow) {
                    event.height = Math.max(event.height, point.y + 3);
                } else {
                    Point point2 = event.gc.textExtent("A");
                    event.height = point2.y + 3;
                }
            }
        });
        this.viewer.getTree().addListener(40, new Listener(){

            public void handleEvent(Event event) {
                event.detail &= 0xFFFFFFEF;
            }
        });
        this.viewer.getTree().addListener(42, new Listener(){
            final int TEXT_MARGIN = 3;

            public void handleEvent(Event event) {
                int n = 0;
                TreeItem treeItem = (TreeItem)event.item;
                String string = treeItem.getText(event.index);
                if (event.index > 0) {
                    event.gc.drawText(string, event.x + 3, event.y + n, true);
                } else if (event.index == 0) {
                    if (treeItem.getImage() != null) {
                        event.gc.drawImage(treeItem.getImage(), event.x, event.y);
                    }
                    event.gc.drawText(string, event.x + treeItem.getImageBounds((int)0).x, event.y + n, true);
                }
            }
        });
        this.viewer.getTree().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                StringEditorPart.this.refreshButtonsEnabled();
            }
        });
        this.registerActionHandlers();
        return this.editorComposite;
    }

    public void refreshButtonsEnabled() {
        this.newArrayItemAction.setEnabled(this.newArrayItemAction.isEnabled());
        this.removeKeyAction.setEnabled(this.removeKeyAction.isEnabled());
        this.menuArrayItem.setEnabled(this.menuArrayItem.isEnabled());
    }

    private void saveSession() {
        Tree tree = this.viewer.getTree();
        int n = 0;
        while (n < tree.getColumnCount()) {
            TreeColumn treeColumn = tree.getColumn(tree.getColumnOrder()[n]);
            this.session.setProperty(treeColumn.getText(), EditorSession.PROPERTY.ORDER, new Integer(n).toString());
            this.session.setProperty(treeColumn.getText(), EditorSession.PROPERTY.VISIBLE, new Boolean(treeColumn.getResizable()).toString());
            this.session.setProperty(treeColumn.getText(), EditorSession.PROPERTY.WIDTH, new Integer(treeColumn.getWidth()).toString());
            ++n;
        }
        this.session.setProperty(SORTER_PROPERTY_NAME, EditorSession.PROPERTY.SORT_BY_COLUMN, tree.getSortColumn() != null ? tree.getSortColumn().getText() : null);
        this.session.setProperty(SORTER_PROPERTY_NAME, EditorSession.PROPERTY.ORDER, tree.getSortDirection() == 128 ? new Integer(128).toString() : new Integer(1024).toString());
    }

    private void saveOptions() {
        String string = this.associatedProject.getName();
        this.session.setProperty(string, EditorSession.PROPERTY.HIGHLIGHT_CHANGES, Boolean.toString(this.highlightChanges));
        this.session.setProperty(string, EditorSession.PROPERTY.SEARCH_TEXT, this.searchString.length() > 0 ? this.searchString : null);
        this.session.setProperty(string, EditorSession.PROPERTY.SHOW_COMMENTS, Boolean.toString(this.showCellComments));
        this.session.setProperty(string, EditorSession.PROPERTY.FILTER_BY_KEY, this.filterByKeyString.length() > 0 ? this.filterByKeyString : null);
        this.session.setProperty(string, EditorSession.PROPERTY.EXPAND_ROW, Boolean.toString(this.expandRow));
    }

    private void restoreOptions() {
        String string = this.associatedProject.getName();
        String string2 = this.session.getProperty(string, EditorSession.PROPERTY.SEARCH_TEXT);
        String string3 = this.session.getProperty(string, EditorSession.PROPERTY.HIGHLIGHT_CHANGES);
        String string4 = this.session.getProperty(string, EditorSession.PROPERTY.SHOW_COMMENTS);
        String string5 = this.session.getProperty(string, EditorSession.PROPERTY.FILTER_BY_KEY);
        String string6 = this.session.getProperty(string, EditorSession.PROPERTY.EXPAND_ROW);
        if (string2 != null) {
            this.searchText.setText(string2);
            this.searchString = this.searchText.getText();
        }
        if (string3 != null) {
            this.highlightChangesButton.setSelection(new Boolean(string3).booleanValue());
            this.highlightChanges = this.highlightChangesButton.getSelection();
        }
        if (string4 != null) {
            this.showCellCommentsButton.setSelection(new Boolean(string4).booleanValue());
            this.showCellComments = this.showCellCommentsButton.getSelection();
        }
        if (string5 != null) {
            this.filterByKeyText.setText(string5);
            this.filterByKeyString = this.filterByKeyText.getText();
        }
        if (string6 != null) {
            this.expandRowButton.setSelection(new Boolean(string6).booleanValue());
            this.expandRow = this.expandRowButton.getSelection();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void restoreSession(List<ColumnInfo> list) {
        TreeViewerColumn n4;
        String string;
        Object object;
        void columnInfo;
        String string2;
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        HashMap<Integer, ColumnInfo> hashMap = new HashMap<Integer, ColumnInfo>();
        ArrayList<ColumnInfo> arrayList2 = new ArrayList<ColumnInfo>();
        for (ColumnInfo columnInfo2 : list) {
            string2 = this.session.getProperty(columnInfo2.getId(), EditorSession.PROPERTY.ORDER);
            if (string2 != null) {
                hashMap.put(Integer.parseInt(string2), columnInfo2);
                continue;
            }
            arrayList2.add(columnInfo2);
        }
        boolean n = true;
        while (columnInfo < list.size() + 1) {
            object = (ColumnInfo)hashMap.get((int)columnInfo);
            if (object != null) {
                arrayList.add(object);
            } else if (arrayList2.size() > 0) {
                arrayList.add((ColumnInfo)arrayList2.remove(0));
            }
            ++columnInfo;
        }
        for (ColumnInfo string3 : arrayList) {
            string2 = this.session.getProperty(string3.getId(), EditorSession.PROPERTY.WIDTH);
            string = this.session.getProperty(string3.getId(), EditorSession.PROPERTY.VISIBLE);
            n4 = this.createColumn(string3.getId(), string3.getTooltip(), -1);
            if (string2 != null) {
                n4.getColumn().setWidth(Integer.parseInt(string2));
            }
            if (string == null) continue;
            n4.getColumn().setResizable(Boolean.parseBoolean(string));
        }
        String string3 = this.session.getProperty(Messages.StringEditorPart_KeyLabel, EditorSession.PROPERTY.WIDTH);
        object = this.session.getProperty(Messages.StringEditorPart_KeyLabel, EditorSession.PROPERTY.VISIBLE);
        if (string3 != null) {
            this.viewer.getTree().getColumn(0).setWidth(Integer.parseInt(string3));
        }
        if (object != null) {
            this.viewer.getTree().getColumn(0).setResizable(Boolean.parseBoolean((String)object));
        }
        string2 = this.session.getProperty(SORTER_PROPERTY_NAME, EditorSession.PROPERTY.SORT_BY_COLUMN);
        string = this.session.getProperty(SORTER_PROPERTY_NAME, EditorSession.PROPERTY.ORDER);
        if (string2 != null && string2.length() > 0) {
            TreeColumn[] treeColumnArray = this.viewer.getTree().getColumns();
            int n2 = treeColumnArray.length;
            int n3 = 0;
            while (n3 < n2) {
                n4 = treeColumnArray[n3];
                if (n4.getText().equals(string2)) {
                    this.viewer.getTree().setSortColumn((TreeColumn)n4);
                }
                ++n3;
            }
        } else {
            this.viewer.getTree().setSortColumn(this.viewer.getTree().getColumn(0));
        }
        if (string != null) {
            try {
                int n5 = Integer.parseInt(string);
                this.viewer.getTree().setSortDirection(n5);
            }
            catch (NumberFormatException numberFormatException) {
                this.viewer.getTree().setSortDirection(1024);
            }
        }
        this.viewer.refresh();
        this.saveSession();
    }

    private TreeViewerColumn createColumn(String string, String string2, int n) {
        TreeViewerColumn treeViewerColumn = null;
        treeViewerColumn = new TreeViewerColumn(this.viewer, 0, n);
        treeViewerColumn.setLabelProvider((CellLabelProvider)new StringEditorColumnLabelProvider(string, this));
        treeViewerColumn.setEditingSupport((EditingSupport)new CellEditingSupport(this, this.viewer, string));
        treeViewerColumn.getColumn().setText(string);
        treeViewerColumn.getColumn().setToolTipText(string2);
        treeViewerColumn.getColumn().setWidth(14 * (treeViewerColumn.getColumn().getText().length() + 1));
        treeViewerColumn.getColumn().setResizable(true);
        treeViewerColumn.getColumn().setMoveable(false);
        treeViewerColumn.getColumn().addSelectionListener((SelectionListener)this.listener);
        return treeViewerColumn;
    }

    public void hideColumn(TreeColumn treeColumn) {
        treeColumn.setResizable(false);
        treeColumn.setData(PREVIOUS_WIDTH_PROPERTY_NAME, (Object)new Integer(treeColumn.getWidth()).toString());
        treeColumn.setWidth(0);
    }

    public void showColumn(TreeColumn treeColumn) {
        treeColumn.setResizable(true);
        int n = -1;
        try {
            n = Integer.parseInt((String)treeColumn.getData(PREVIOUS_WIDTH_PROPERTY_NAME));
        }
        catch (NumberFormatException numberFormatException) {}
        treeColumn.setWidth(n > 0 ? n : 0);
        if (n == -1) {
            treeColumn.pack();
        }
    }

    private void fillContextMenu(IMenuManager iMenuManager) {
        this.addColumnsVisibilityActions(iMenuManager);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add(this.getEditorSite().getActionBars().getGlobalActionHandler(ActionFactory.UNDO.getId()));
        iMenuManager.add(this.getEditorSite().getActionBars().getGlobalActionHandler(ActionFactory.REDO.getId()));
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)new AddSingleStringAction(this));
        iMenuManager.add((IAction)new AddArrayAction(this));
        iMenuManager.add((IAction)this.newArrayItemAction);
        iMenuManager.add((IAction)this.removeKeyAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)new AddColumnAction(this));
        iMenuManager.add((IAction)new RemoveColumnAction(this));
        iMenuManager.add((IAction)new RevertToSavedAction(this));
        iMenuManager.add((IAction)new CloneColumnAction(this));
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)new TranslateColumnAction(this));
        iMenuManager.add((IAction)new TranslateCellAction(this));
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.collapseAllAction);
        iMenuManager.add((IAction)this.expandAllAction);
    }

    private void addColumnsVisibilityActions(IMenuManager iMenuManager) {
        MenuManager menuManager = new MenuManager(Messages.StringEditorPart_ShowColumnsSubmenuLabel);
        TreeColumn[] treeColumnArray = this.viewer.getTree().getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn treeColumn = treeColumnArray[n2];
            if (!treeColumn.getText().equals(Messages.StringEditorPart_KeyLabel)) {
                menuManager.add((IAction)new HideShowColumnAction(this, treeColumn.getText(), 2, treeColumn));
            }
            ++n2;
        }
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)new HideShowAllColumnsAction(this, Messages.StringEditorPart_ShowAllColumnsActionName, 1, this.viewer.getTree(), true));
        menuManager.add((IAction)new HideShowAllColumnsAction(this, Messages.StringEditorPart_HideAllColumnsActionName, 1, this.viewer.getTree(), false));
        iMenuManager.add((IContributionItem)menuManager);
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        if (this.promptUpdateConflicts()) {
            List<RowInfo> list = this.getModel().save();
            this.updateViewer(list);
            this.setEditorStatus(this.getEditorInput().validate());
            if (this.getActivePage() > 0) {
                this.notifyEditorChanged();
            }
            int n = 1;
            while (n < this.getPageCount()) {
                if (this.getEditor(n).isDirty()) {
                    if (this.getActivePage() == 0) {
                        this.updatePageContent(n);
                    }
                    this.getEditor(n).doSave(iProgressMonitor);
                }
                ++n;
            }
            this.getEditorInput().save();
            this.fireDirtyPropertyChanged();
        }
        this.syncPages();
    }

    public void updateViewer(List<RowInfo> list) {
        if (list != null) {
            for (RowInfo rowInfo : list) {
                if (rowInfo instanceof RowInfoLeaf) {
                    this.viewer.update((Object)rowInfo, null);
                    if (((RowInfoLeaf)rowInfo).getParent() == null) continue;
                    this.viewer.update((Object)((RowInfoLeaf)rowInfo).getParent(), null);
                    continue;
                }
                this.viewer.update((Object)rowInfo, null);
                for (RowInfoLeaf rowInfoLeaf : rowInfo.getChildren()) {
                    this.viewer.update((Object)rowInfoLeaf, null);
                }
            }
        } else {
            for (RowInfo rowInfo : this.getModel().getRows().values()) {
                this.viewer.update((Object)rowInfo, null);
                for (RowInfoLeaf rowInfoLeaf : rowInfo.getChildren()) {
                    this.viewer.update((Object)rowInfoLeaf, null);
                }
            }
        }
    }

    public boolean isDirty() {
        return super.isDirty() || this.getEditorInput().isDirty();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSaveAs() {
    }

    public TreeViewer getEditorViewer() {
        return this.viewer;
    }

    public void setFocus() {
        this.viewer.getTree().setFocus();
        this.promptFileSystemChanges();
    }

    public void markColumnAsChanged(String string) {
        this.changedColumns.add(string);
        this.needToPromptFileSystemChange = true;
    }

    public boolean unmarkColumnAsChanged(String string) {
        boolean bl = this.changedColumns.remove(string);
        this.needToPromptFileSystemChange = !this.changedColumns.isEmpty();
        return bl;
    }

    private void clearColumnsMarkedAsChanged() {
        this.changedColumns.clear();
        this.needToPromptFileSystemChange = !this.changedColumns.isEmpty();
    }

    private void untrackedRevertColumn(String string) {
        ColumnInfo columnInfo = new ColumnInfo(string, this.getModel().getColumn(string).getTooltip(), this.getEditorInput().getValues(string), this.getModel().getColumn(string).canRemove());
        this.syncDirty(string, columnInfo);
        this.getModel().removeColumn(string);
        this.getModel().addColumn(columnInfo);
        this.unmarkColumnAsChanged(string);
        this.refresh();
    }

    private void syncDirty(String string, ColumnInfo columnInfo) {
        ColumnInfo columnInfo2 = this.getModel().getColumn(string);
        if (columnInfo2 != null) {
            for (String string2 : columnInfo.getCells().keySet()) {
                CellInfo cellInfo = columnInfo2.getCells().get(string2);
                CellInfo cellInfo2 = columnInfo.getCells().get(string2);
                if (cellInfo != null) {
                    if (cellInfo.isDirty() && cellInfo2 != null) {
                        cellInfo2.setDirty(true);
                    }
                    if (cellInfo.hasChildren() && cellInfo2.hasChildren()) {
                        CellInfo cellInfo3;
                        List<CellInfo> list = cellInfo.getChildren();
                        List<CellInfo> list2 = cellInfo2.getChildren();
                        int n = 0;
                        while (n < list.size() && n < list2.size()) {
                            cellInfo3 = list.get(n);
                            CellInfo cellInfo4 = list2.get(n);
                            if (cellInfo3.isDirty() && cellInfo4 != null) {
                                cellInfo4.setDirty(true);
                            }
                            if (cellInfo3.getValue() != null && !cellInfo3.getValue().equals(cellInfo4.getValue())) {
                                cellInfo4.setDirty(true);
                            }
                            ++n;
                        }
                        if (list2.size() > list.size()) {
                            n = list.size();
                            while (n < list2.size()) {
                                cellInfo3 = list2.get(n);
                                cellInfo3.setDirty(true);
                                ++n;
                            }
                        }
                    }
                    if (cellInfo.getValue() == null || cellInfo.getValue().equals(cellInfo2.getValue())) continue;
                    cellInfo2.setDirty(true);
                    continue;
                }
                if (cellInfo2 == null) continue;
                cellInfo2.setDirty(true);
            }
        }
    }

    private void promptFileSystemChanges() {
        if (this.pageChangedWithDirtySourceEditors) {
            HashSet<String> hashSet = new HashSet<String>(this.changedColumns);
            for (String string : hashSet) {
                this.untrackedRevertColumn(string);
            }
            this.pageChangedWithDirtySourceEditors = false;
        } else if (this.changedColumns.size() > 0 && this.needToPromptFileSystemChange) {
            String string = this.getChangedColumnNamesString();
            boolean bl = MessageDialog.openQuestion((Shell)this.getEditorSite().getShell(), (String)Messages.StringEditorPart_FileChangedTitle, (String)NLS.bind((String)Messages.StringEditorPart_FileChangedDescription, (Object)string));
            this.needToPromptFileSystemChange = false;
            if (bl) {
                HashSet<String> hashSet = new HashSet<String>(this.changedColumns);
                for (String string2 : hashSet) {
                    RevertColumnToSavedStateOperation revertColumnToSavedStateOperation = new RevertColumnToSavedStateOperation(Messages.StringEditorPart_RevertColumnActionOperationName, this, this.getModel().getColumn(string2));
                    this.executeOperation(revertColumnToSavedStateOperation);
                }
            }
        }
    }

    private boolean promptUpdateConflicts() {
        boolean bl = true;
        if (this.changedColumns.size() > 0) {
            String string = this.getChangedColumnNamesString();
            boolean bl2 = MessageDialog.openQuestion((Shell)this.getEditorSite().getShell(), (String)Messages.StringEditorPart_UpdateConflictTitle, (String)NLS.bind((String)Messages.StringEditorPart_UpdateConflictDescription, (Object)string));
            if (!bl2) {
                bl = false;
            } else {
                this.clearColumnsMarkedAsChanged();
            }
        }
        return bl;
    }

    private String getChangedColumnNamesString() {
        String string = "\n";
        int n = 1;
        for (String string2 : this.changedColumns) {
            string = String.valueOf(string) + n++ + ")" + string2 + "\n";
        }
        return string;
    }

    public TreeColumn addColumn(ColumnInfo columnInfo, int n) {
        TreeViewerColumn treeViewerColumn = this.createColumn(columnInfo.getId(), columnInfo.getTooltip(), n);
        this.getEditorInput().addColumn(columnInfo.getId());
        this.getModel().addColumn(columnInfo);
        for (String string : columnInfo.getCells().keySet()) {
            try {
                CellInfo cellInfo = columnInfo.getCells().get(string);
                if (cellInfo.getValue() != null) {
                    this.getEditorInput().setValue(columnInfo.getId(), string, cellInfo.getValue());
                    continue;
                }
                if (!cellInfo.hasChildren()) continue;
                List<CellInfo> list = cellInfo.getChildren();
                boolean bl = true;
                for (CellInfo cellInfo2 : list) {
                    if (cellInfo2 == null || cellInfo2.getValue() == null) continue;
                    bl = false;
                    break;
                }
                if (bl) continue;
                for (CellInfo cellInfo2 : list) {
                    this.getEditorInput().setValue(columnInfo.getId(), string, cellInfo2.getValue(), cellInfo2.getPosition());
                }
            }
            catch (SequoyahException sequoyahException) {
                BasePlugin.logError((String)("Error adding column: " + columnInfo.getId()), (Throwable)sequoyahException);
            }
        }
        this.refresh();
        this.fireDirtyPropertyChanged();
        this.syncPages();
        return treeViewerColumn.getColumn();
    }

    public ContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public AbstractStringEditorInput getEditorInput() {
        return (AbstractStringEditorInput)super.getEditorInput();
    }

    public void removeColumn(String string) {
        this.getEditorInput().removeColumn(string);
        this.getModel().removeColumn(string);
        TreeColumn[] treeColumnArray = this.getEditorViewer().getTree().getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn treeColumn = treeColumnArray[n2];
            if (treeColumn.getText().equals(string)) {
                treeColumn.dispose();
            }
            ++n2;
        }
        this.fireDirtyPropertyChanged();
        this.refresh();
        this.syncPages();
    }

    public void addRow(RowInfo rowInfo) {
        rowInfo = this.getEditorInput().addRow(rowInfo);
        this.getModel().addRow(rowInfo);
        this.fireDirtyPropertyChanged();
    }

    public void removeRow(String string) {
        this.getModel().removeRow(string);
        this.getEditorInput().removeRow(string);
        this.fireDirtyPropertyChanged();
    }

    public void removeRow(String string, Integer n) {
        this.getModel().removeRow(string, n);
        this.getEditorInput().removeChildRow(string, n);
        this.fireDirtyPropertyChanged();
    }

    public void renameKey(String string, String string2) {
        this.getModel().renameKey(string, string2);
        try {
            this.getEditorInput().renameKey(string, string2);
        }
        catch (SequoyahException sequoyahException) {
            this.getModel().renameKey(string2, string);
        }
        RowInfo rowInfo = this.getModel().getRow(string2);
        boolean bl = this.getEditorViewer().getExpandedState((Object)rowInfo);
        this.getEditorViewer().update((Object)rowInfo, null);
        this.getEditorViewer().setExpandedState((Object)rowInfo, bl);
        this.fireDirtyPropertyChanged();
    }

    public StringEditorViewerModel getModel() {
        return (StringEditorViewerModel)this.getEditorViewer().getInput();
    }

    public void dispose() {
        if (this.getEditorInput() != null) {
            this.getEditorInput().removeInputChangeListener(this.inputChangeListener);
            this.getEditorInput().dispose();
        }
        super.dispose();
    }

    public void fireDirtyPropertyChanged() {
        this.firePropertyChange(257);
    }

    public boolean getHighlightChanges() {
        return this.highlightChanges;
    }

    public String getSearchText() {
        return this.searchString;
    }

    public boolean getShowCellComments() {
        return this.showCellComments;
    }

    public String getKeyFilter() {
        return this.filterByKeyString;
    }

    public void executeOperation(EditorOperation editorOperation) {
        try {
            editorOperation.addContext(this.getUndoContext());
            this.getOperationHistory().execute((IUndoableOperation)editorOperation, this.getProgressMonitor(), null);
        }
        catch (ExecutionException executionException) {
            BasePlugin.logError((String)("Error executing editor operation: " + editorOperation.getLabel()), (Throwable)executionException);
        }
    }

    public ViewerCell getActiveRow() {
        return this.activeRow;
    }

    public int getActiveColumn() {
        return this.activeColumn;
    }

    public void setEditorStatus(IStatus iStatus) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        if (iStatus != null && !iStatus.isOK()) {
            if (iStatus.isMultiStatus()) {
                IStatus[] iStatusArray = iStatus.getChildren();
                int n2 = iStatusArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    IStatus iStatus2 = iStatusArray[n3];
                    stringBuilder.append(iStatus2.getMessage());
                    stringBuilder.append("\n");
                    ++n3;
                }
            } else {
                stringBuilder.append(iStatus.getMessage());
            }
            switch (iStatus.getSeverity()) {
                case 2: {
                    n = 2;
                    break;
                }
                case 4: {
                    n = 3;
                    break;
                }
            }
            this.editorComposite.setMessage(stringBuilder.toString(), n);
        } else {
            this.editorComposite.setMessage(null);
        }
    }

    public TreeColumn getColumnByID(String string) {
        TreeColumn treeColumn = null;
        TreeColumn[] treeColumnArray = this.getEditorViewer().getTree().getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn treeColumn2 = treeColumnArray[n2];
            if (treeColumn2.getText().equals(string)) {
                treeColumn = treeColumn2;
            }
            ++n2;
        }
        return treeColumn;
    }

    public Image getErrorImage() {
        return this.errorImage;
    }

    public Image getWarningImage() {
        return this.warningImage;
    }

    public Image getOKImage() {
        return this.okImage;
    }

    private List<IFile> findPagesToAdd() {
        ArrayList<IFile> arrayList = new ArrayList<IFile>();
        List<IFile> list = this.getEditorInput().getFiles();
        int n = 0;
        while (n < list.size()) {
            int n2 = 1;
            String string = this.getEditorInput().getSourcePageNameForFile(list.get(n));
            boolean bl = false;
            while (n2 < this.getPageCount() && !bl) {
                if (this.getPageText(n2).equals(string)) {
                    bl = true;
                }
                ++n2;
            }
            if (!bl) {
                arrayList.add(list.get(n));
            }
            ++n;
        }
        return arrayList;
    }

    private List<Integer> findPagesToRemove() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        List<IFile> list = this.getEditorInput().getFiles();
        int n = 1;
        while (n < this.getPageCount()) {
            int n2 = 0;
            String string = this.getPageText(n);
            boolean bl = false;
            while (n2 < list.size() && !bl) {
                if (this.getEditorInput().getSourcePageNameForFile(list.get(n2)).equals(string)) {
                    bl = true;
                }
                ++n2;
            }
            if (!bl) {
                arrayList.add(n);
            }
            ++n;
        }
        Comparator comparator = Collections.reverseOrder();
        Collections.sort(arrayList, comparator);
        return arrayList;
    }

    private void syncPages() {
        List<Integer> list = this.findPagesToRemove();
        List<IFile> list2 = this.findPagesToAdd();
        for (int n : list) {
            this.removePage(n);
        }
        for (IFile iFile : list2) {
            try {
                this.addPage(iFile);
            }
            catch (PartInitException partInitException) {
                BasePlugin.logError((String)"Impossible to add a new page to the String Editor", (Throwable)partInitException);
            }
        }
    }

    private void notifyEditorChanged() {
        int n = 1;
        while (n < this.getPageCount()) {
            IEditorPart iEditorPart = this.getEditor(n);
            if (iEditorPart instanceof ITextEditor) {
                ITextEditor iTextEditor = (ITextEditor)iEditorPart;
                IEditorInput iEditorInput = iTextEditor.getEditorInput();
                if (iTextEditor.isDirty()) {
                    this.pageChangedWithDirtySourceEditors = true;
                    this.getEditorInput().notifyEditorChanged(iEditorInput, iTextEditor.getDocumentProvider().getDocument((Object)iEditorInput).get());
                }
            }
            ++n;
        }
    }

    private void updatePageContent(int n) {
        ITextEditor iTextEditor;
        ITextEditor iTextEditor2 = iTextEditor = this.getEditor(n) instanceof ITextEditor ? (ITextEditor)this.getEditor(n) : null;
        if (iTextEditor != null) {
            IFileEditorInput iFileEditorInput;
            IFileEditorInput iFileEditorInput2 = iFileEditorInput = iTextEditor.getEditorInput() instanceof IFileEditorInput ? (IFileEditorInput)iTextEditor.getEditorInput() : null;
            if (iFileEditorInput != null) {
                String string = this.getEditorInput().getContentForFileAsText(iFileEditorInput);
                if (!iTextEditor.getDocumentProvider().getDocument((Object)iFileEditorInput).get().equals(string)) {
                    iTextEditor.getDocumentProvider().getDocument((Object)iFileEditorInput).set(string);
                }
            }
        }
    }

    protected void pageChange(int n) {
        if (n == 0) {
            this.registerActionHandlers();
            if (this.isDirty()) {
                this.notifyEditorChanged();
            }
        } else {
            this.updatePageContent(n);
        }
        super.pageChange(n);
    }

    public void refresh() {
        Object[] objectArray = this.getEditorViewer().getExpandedElements();
        this.getEditorViewer().refresh();
        this.getEditorViewer().setExpandedElements(objectArray);
    }

    public void setMessage(String string, int n) {
        this.editorComposite.setMessage(string, n);
    }

    class ColumnSelectionListener
    implements SelectionListener {
        private final TreeViewer viewer;

        public ColumnSelectionListener(TreeViewer treeViewer) {
            this.viewer = treeViewer;
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            if ((selectionEvent.stateMask & 0x40000) == 0) {
                TreeColumn treeColumn = (TreeColumn)selectionEvent.widget;
                this.viewer.getTree().setSortColumn(treeColumn);
                this.viewer.getTree().setSortDirection(this.viewer.getTree().getSortDirection() == 1024 ? 128 : 1024);
                this.viewer.refresh();
            }
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }
    }

    class FilterByKeyTextModifyListener
    implements ModifyListener {
        FilterByKeyTextModifyListener() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            StringEditorPart.this.filterByKeyString = ((Text)modifyEvent.widget).getText();
        }
    }

    class SearchTextModifyListener
    implements ModifyListener {
        SearchTextModifyListener() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            StringEditorPart.this.searchString = ((Text)modifyEvent.widget).getText();
            StringEditorPart.this.updateViewer(null);
        }
    }
}

