/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.editor.model.operations;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.sequoyah.localization.editor.datatype.CellInfo;
import org.eclipse.sequoyah.localization.editor.datatype.ColumnInfo;
import org.eclipse.sequoyah.localization.editor.i18n.Messages;
import org.eclipse.sequoyah.localization.editor.model.StringEditorPart;
import org.eclipse.sequoyah.localization.editor.model.operations.EditorOperation;

public class CloneOperation
extends EditorOperation {
    private final String sourceColumnID;
    private final ColumnInfo destinationColumn;

    public CloneOperation(StringEditorPart stringEditorPart, String string, ColumnInfo columnInfo) {
        super(Messages.CloneOperation_0, stringEditorPart);
        this.sourceColumnID = string;
        this.destinationColumn = columnInfo;
    }

    public IStatus execute(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        ColumnInfo columnInfo = this.getModel().getColumn(this.sourceColumnID);
        for (String string : columnInfo.getCells().keySet()) {
            CellInfo cellInfo = columnInfo.getCells().get(string);
            if (cellInfo == null) continue;
            this.destinationColumn.addCell(string, new CellInfo(cellInfo));
        }
        return this.redo(iProgressMonitor, iAdaptable);
    }

    public IStatus redo(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        this.getEditor().addColumn(this.destinationColumn, -1);
        return Status.OK_STATUS;
    }

    public IStatus undo(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        this.getEditor().removeColumn(this.destinationColumn.getId());
        return Status.OK_STATUS;
    }
}

