/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.command;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.andmore.android.certmanager.command.AbstractHandler2;
import org.eclipse.andmore.android.certmanager.core.KeyStoreManager;
import org.eclipse.andmore.android.certmanager.exception.KeyStoreManagerException;
import org.eclipse.andmore.android.certmanager.i18n.CertificateManagerNLS;
import org.eclipse.andmore.android.certmanager.ui.dialogs.BackupDialog;
import org.eclipse.andmore.android.certmanager.ui.model.IKeyStore;
import org.eclipse.andmore.android.certmanager.ui.model.ITreeNode;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.common.utilities.FileUtil;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;

public class BackupHandler
extends AbstractHandler2
implements IHandler {
    public static final String KS_TYPES_FILENAME = "KsTypes.csv";
    private static final String KEYSTORE_EXT = ".keystore";
    private static Date lastBackupDate = new Date();
    private final Calendar cal = GregorianCalendar.getInstance();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        BackupDialog dialog = new BackupDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        try {
            List<IKeyStore> keyStores = KeyStoreManager.getInstance().getKeyStores();
            ArrayList<String> initialInputList = new ArrayList<String>(keyStores.size());
            int i = 0;
            while (i < keyStores.size()) {
                ITreeNode ksNode;
                IStatus nodeStatus;
                boolean insert = true;
                IKeyStore keyStore = keyStores.get(i);
                if (keyStore instanceof ITreeNode && !(nodeStatus = (ksNode = (ITreeNode)((Object)keyStore)).getNodeStatus()).isOK() && nodeStatus.getCode() == 1) {
                    insert = false;
                }
                if (insert) {
                    initialInputList.add(keyStore.getFile().getAbsolutePath());
                }
                ++i;
            }
            dialog.setInput(initialInputList.toArray(new String[initialInputList.size()]));
            dialog.selectKeyStores(this.getSelection());
        }
        catch (KeyStoreManagerException e) {
            throw new ExecutionException(e.getLocalizedMessage());
        }
        int diagReturn = dialog.open();
        if (diagReturn == 0) {
            File archiveFile = dialog.getArchiveFile();
            List<String> selectedKeyStores = dialog.getSelectedKeyStores();
            if (FileUtil.canWrite((File)archiveFile)) {
                try {
                    this.updateBackupDate(selectedKeyStores);
                    this.createZipArchive(archiveFile, selectedKeyStores);
                }
                catch (KeyStoreManagerException keyStoreManagerException) {
                    EclipseUtils.showErrorDialog((String)CertificateManagerNLS.BackupHandler_Error_BackUp_Title, (String)CertificateManagerNLS.BackupHandler_Error_Setting_Date);
                }
                catch (IOException iOException) {
                    EclipseUtils.showErrorDialog((String)CertificateManagerNLS.BackupHandler_Error_BackUp_Title, (String)NLS.bind((String)CertificateManagerNLS.BackupHandler_Error_Writing_Archive, (Object)archiveFile));
                }
            } else {
                EclipseUtils.showErrorDialog((String)CertificateManagerNLS.BackupHandler_Error_BackUp_Title, (String)NLS.bind((String)CertificateManagerNLS.BackupHandler_Error_Writing_Archive, (Object)archiveFile));
            }
        }
        return null;
    }

    private void updateBackupDate(List<String> selectedKeyStores) throws KeyStoreManagerException {
        KeyStoreManager keyStoreManager = KeyStoreManager.getInstance();
        List<IKeyStore> keyStores = keyStoreManager.getKeyStores();
        Long lastDateInMillis = this.cal.getTimeInMillis();
        lastBackupDate.setTime(lastDateInMillis);
        for (IKeyStore keyStore : keyStores) {
            if (!selectedKeyStores.contains(keyStore.getFile().getAbsolutePath())) continue;
            keyStore.setLastBackupDate(lastBackupDate);
        }
    }

    private void createZipArchive(File zipFile, List<String> filePaths) throws IOException, KeyStoreManagerException {
        DeflaterOutputStream zos = null;
        FileInputStream in = null;
        try {
            zos = new ZipOutputStream(new FileOutputStream(zipFile));
            Iterator<String> it = filePaths.iterator();
            ArrayList<String> entriesNames = new ArrayList<String>(filePaths.size());
            Properties typeProperties = new Properties();
            int nameSuffix = 1;
            while (it.hasNext()) {
                String keyStore = it.next();
                File keyStoreFile = new File(keyStore);
                if (!keyStoreFile.exists()) continue;
                String entryName = keyStoreFile.getName();
                while (entriesNames.contains(entryName)) {
                    entryName = entryName.toLowerCase().endsWith(KEYSTORE_EXT) ? entryName.replace(KEYSTORE_EXT, "_" + nameSuffix + KEYSTORE_EXT) : entryName.concat(Integer.toString(nameSuffix));
                    ++nameSuffix;
                }
                this.putKsType(typeProperties, entryName, keyStore);
                ZipEntry zipEntry = new ZipEntry(entryName);
                ((ZipOutputStream)zos).putNextEntry(zipEntry);
                entriesNames.add(entryName);
                byte[] buf = new byte[4096];
                in = new FileInputStream(keyStoreFile);
                try {
                    int len;
                    while ((len = in.read(buf)) > 0) {
                        ((ZipOutputStream)zos).write(buf, 0, len);
                    }
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
                zos.flush();
            }
            ((ZipOutputStream)zos).putNextEntry(new ZipEntry(KS_TYPES_FILENAME));
            this.putLastBackupDate(typeProperties);
            typeProperties.store(zos, "KeyStore types");
        }
        finally {
            if (zos != null) {
                try {
                    zos.flush();
                    ((ZipOutputStream)zos).close();
                }
                catch (IOException e) {
                    AndmoreLogger.error((String)("Could not close steam while creating zip archive. " + e.getMessage()));
                }
            }
        }
    }

    private void putKsType(Properties properties, String entryName, String filePaths) throws KeyStoreManagerException {
        List<IKeyStore> keyStores = KeyStoreManager.getInstance().getKeyStores();
        for (IKeyStore keyStore : keyStores) {
            String keyStorePath = keyStore.getFile().getAbsolutePath();
            if (!filePaths.contains(keyStorePath)) continue;
            String type = keyStore.getType();
            if (type == null) break;
            properties.put(entryName, type);
            break;
        }
    }

    private void putLastBackupDate(Properties properties) {
        Long time = lastBackupDate.getTime();
        String timeString = time.toString();
        properties.put("lastBackupDate", timeString);
    }
}

