/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.command;

import java.util.List;
import org.eclipse.andmore.android.certmanager.command.AbstractHandler2;
import org.eclipse.andmore.android.certmanager.i18n.CertificateManagerNLS;
import org.eclipse.andmore.android.certmanager.ui.model.ITreeNode;
import org.eclipse.andmore.android.certmanager.ui.model.KeyStoreNode;
import org.eclipse.andmore.android.certmanager.ui.model.SigningAndKeysModelManager;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DeleteKeystoreHandler
extends AbstractHandler2
implements IHandler2 {
    private static boolean toggleState = false;

    private boolean showQuestion(List<ITreeNode> nodesToDelete) {
        final Boolean[] reply = new Boolean[2];
        final String keystoreName = nodesToDelete.size() == 1 ? nodesToDelete.get(0).getName() : null;
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow ww = workbench.getActiveWorkbenchWindow();
                Shell shell = ww.getShell();
                MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)CertificateManagerNLS.DeleteKeystoreHandler_ConfirmationQuestionDialog_Title, (String)(keystoreName != null ? NLS.bind((String)CertificateManagerNLS.DeleteKeystoreHandler_ConfirmationQuestionDialog_Description, (Object)keystoreName) : CertificateManagerNLS.DeleteKeystoreHandler_Delete_Selected_Keystores), (String)CertificateManagerNLS.DeleteKeystoreHandler_ConfirmationQuestionDialog_Toggle, (boolean)false, null, null);
                reply[0] = dialog.getReturnCode() == 2;
                reply[1] = dialog.getToggleState();
            }
        });
        toggleState = reply[1];
        return reply[0];
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        boolean shouldProceed;
        List<ITreeNode> nodesToDelete = this.getSelection();
        if (!nodesToDelete.isEmpty() && (shouldProceed = this.showQuestion(nodesToDelete))) {
            for (ITreeNode node2Delete : nodesToDelete) {
                KeyStoreNode keyStoreNode = (KeyStoreNode)node2Delete;
                SigningAndKeysModelManager.getInstance().unmapKeyStore(keyStoreNode);
                if (!toggleState) continue;
                keyStoreNode.getFile().delete();
            }
        }
        nodesToDelete.clear();
        return null;
    }
}

