/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.command;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.eclipse.andmore.android.certmanager.core.KeyStoreManager;
import org.eclipse.andmore.android.certmanager.event.KeyStoreModelEvent;
import org.eclipse.andmore.android.certmanager.event.KeyStoreModelEventManager;
import org.eclipse.andmore.android.certmanager.exception.KeyStoreManagerException;
import org.eclipse.andmore.android.certmanager.i18n.CertificateManagerNLS;
import org.eclipse.andmore.android.certmanager.ui.dialogs.RestoreBackupDialog;
import org.eclipse.andmore.android.certmanager.ui.model.IKeyStore;
import org.eclipse.andmore.android.certmanager.ui.model.ITreeNode;
import org.eclipse.andmore.android.certmanager.ui.model.KeyStoreNode;
import org.eclipse.andmore.android.certmanager.ui.model.SigningAndKeysModelManager;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.common.utilities.FileUtil;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;

public class RestoreBackupHandler
extends AbstractHandler
implements IHandler {
    Date lastBackupDate = new Date();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        RestoreBackupDialog dialog = new RestoreBackupDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        int diagReturn = dialog.open();
        if (diagReturn == 0) {
            File archiveFile = dialog.getArchiveFile();
            File destinationFile = dialog.getDestinationDir();
            List<String> selectedKeyStores = dialog.getSelectedKeyStores();
            this.restoreBackup(archiveFile, destinationFile, selectedKeyStores);
        }
        return null;
    }

    private void restoreBackup(File archiveFile, File destinationFile, List<String> selectedKeyStores) {
        boolean extractionSuccess = false;
        File typePropertiesFile = new File(destinationFile, "KsTypes.csv");
        try {
            extractionSuccess = FileUtil.extractZipArchive((File)archiveFile, (File)destinationFile, Arrays.asList("KsTypes.csv"), (IProgressMonitor)new NullProgressMonitor());
            extractionSuccess = FileUtil.extractZipArchive((File)archiveFile, (File)destinationFile, selectedKeyStores, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException e) {
            this.rollBackDeleteExtractedFiles(destinationFile, selectedKeyStores);
            EclipseUtils.showErrorDialog((String)CertificateManagerNLS.RestoreBackupHandler_Error_Restoring_Backup_Title, (String)NLS.bind((String)CertificateManagerNLS.RestoreBackupHandler_Error_Restoring_Backup_Message, (Object)archiveFile), (IStatus)new Status(4, CertificateManagerNLS.RestoreBackupHandler_Error_Restoring_Backup_Status, "org.eclipse.andmore.android.certmanager", (Throwable)e));
        }
        if (extractionSuccess) {
            Properties properties = null;
            if (typePropertiesFile != null && !typePropertiesFile.exists()) {
                this.showWarningAboutNonIdentifiedKeystoreType(selectedKeyStores);
            }
            properties = this.loadTypeProperties(typePropertiesFile, properties);
            this.getDateFromProperties(properties);
            ArrayList<String> nonIdentifiedKeystoreTypes = new ArrayList<String>();
            for (String keyStoreFileName : selectedKeyStores) {
                File keyStoreFile = new File(destinationFile, keyStoreFileName);
                String ksType = null;
                if (properties != null && (ksType = (String)properties.get(keyStoreFileName)) == null) {
                    nonIdentifiedKeystoreTypes.add(keyStoreFileName);
                }
                if (ksType == null) {
                    ksType = KeyStoreManager.getInstance().getDefaultType();
                }
                KeyStoreNode keyStoreNode = new KeyStoreNode(keyStoreFile, ksType);
                keyStoreNode.setLastBackupDate(this.lastBackupDate);
                boolean map = true;
                try {
                    List<IKeyStore> keyStores = KeyStoreManager.getInstance().getKeyStores();
                    for (IKeyStore keyStore : keyStores) {
                        if (!keyStore.getFile().equals(keyStoreFile)) continue;
                        if (ksType != null && ksType.compareToIgnoreCase(keyStore.getType()) != 0) {
                            keyStore.setType(ksType);
                        }
                        KeyStoreModelEventManager.getInstance().fireEvent((ITreeNode)((Object)keyStore), KeyStoreModelEvent.EventType.COLLAPSE);
                        map = false;
                        keyStore.setLastBackupDate(this.lastBackupDate);
                    }
                    if (!map) continue;
                    SigningAndKeysModelManager.getInstance().mapKeyStore(keyStoreNode);
                }
                catch (KeyStoreManagerException e) {
                    EclipseUtils.showErrorDialog((String)CertificateManagerNLS.RestoreBackupHandler_Error_Mapping_Title, (String)CertificateManagerNLS.RestoreBackupHandler_Error_Mapping_Message, (IStatus)new Status(4, CertificateManagerNLS.RestoreBackupHandler_Error_Mapping_Status, "org.eclipse.andmore.android.certmanager", (Throwable)((Object)e)));
                    if (!map) continue;
                    SigningAndKeysModelManager.getInstance().unmapKeyStore(keyStoreNode);
                }
            }
            if (nonIdentifiedKeystoreTypes != null && !nonIdentifiedKeystoreTypes.isEmpty()) {
                this.showWarningAboutNonIdentifiedKeystoreType(nonIdentifiedKeystoreTypes);
            }
        } else {
            this.rollBackDeleteExtractedFiles(destinationFile, selectedKeyStores);
            EclipseUtils.showErrorDialog((String)CertificateManagerNLS.RestoreBackupHandler_Error_Restoring_Backup_Title, (String)NLS.bind((String)CertificateManagerNLS.RestoreBackupHandler_Error_Restoring_Backup_Message, (Object)archiveFile));
        }
    }

    private void rollBackDeleteExtractedFiles(File destinationFile, List<String> selectedKeyStores) {
        File ksTypeDest = new File(destinationFile, "KsTypes.csv");
        if (ksTypeDest.exists()) {
            ksTypeDest.delete();
        }
        for (String keyStoreFileName : selectedKeyStores) {
            File keyStoreFile = new File(destinationFile, keyStoreFileName);
            if (!keyStoreFile.exists()) continue;
            keyStoreFile.delete();
        }
    }

    private void getDateFromProperties(Properties properties) {
        if (properties != null) {
            String lastString = properties.getProperty("lastBackupDate");
            Long time = new Long(lastString);
            this.lastBackupDate.setTime(time);
        } else {
            AndmoreLogger.debug((String)"KsTypes.csv not available to get lastBackupDate properties");
        }
    }

    private void showWarningAboutNonIdentifiedKeystoreType(List<String> selectedKeyStores) {
        EclipseUtils.showWarningDialog((String)CertificateManagerNLS.RestoreBackupHandler_RestoreIssue_WarningTitle, (String)NLS.bind((String)CertificateManagerNLS.RestoreBackupHandler_RestoreIssue_MissingMetadataFile_WarningDescription, selectedKeyStores, (Object)KeyStore.getDefaultType()));
    }

    private Properties loadTypeProperties(File typePropertiesFile, Properties properties) {
        block17: {
            if (typePropertiesFile != null && typePropertiesFile.exists()) {
                FileInputStream propInStream = null;
                properties = new Properties();
                try {
                    try {
                        propInStream = new FileInputStream(typePropertiesFile);
                        properties.load(propInStream);
                        typePropertiesFile.delete();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        properties = null;
                        if (propInStream == null) break block17;
                        try {
                            propInStream.close();
                        }
                        catch (IOException e) {
                            AndmoreLogger.error((String)("Could not close steam while loading type properties. " + e.getMessage()));
                        }
                        typePropertiesFile.delete();
                    }
                    catch (IOException iOException) {
                        properties = null;
                        if (propInStream == null) break block17;
                        try {
                            propInStream.close();
                        }
                        catch (IOException e) {
                            AndmoreLogger.error((String)("Could not close steam while loading type properties. " + e.getMessage()));
                        }
                        typePropertiesFile.delete();
                    }
                }
                finally {
                    if (propInStream != null) {
                        try {
                            propInStream.close();
                        }
                        catch (IOException e) {
                            AndmoreLogger.error((String)("Could not close steam while loading type properties. " + e.getMessage()));
                        }
                        typePropertiesFile.delete();
                    }
                }
            }
        }
        return properties;
    }
}

