/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.andmore.android.common.log.AndmoreLogger;

class SaveStateManager {
    private static final String FILE_COMMENT = "-- Signing and keys view persistence --";
    private static final String STATE_FILENAME = "state.properties";
    private final File persistenceFile = new File(String.valueOf(System.getProperty("user.home")) + File.separator + "." + "org.eclipse.andmore.android.certmanager", "state.properties");
    private static final String KEYSTORE_TYPE = "keystore_type=";
    private static final String BACKUP_DATE = "backup_date=";
    private static SaveStateManager _instance;

    public static synchronized SaveStateManager getInstance() throws IOException {
        if (_instance == null) {
            _instance = new SaveStateManager();
        }
        return _instance;
    }

    private SaveStateManager() throws IOException {
        if (!this.persistenceFile.getParentFile().exists()) {
            this.persistenceFile.getParentFile().mkdirs();
        }
        if (!this.persistenceFile.exists()) {
            this.persistenceFile.createNewFile();
            this.store(new Properties());
        }
    }

    private String write(ViewStateEntry entry) {
        StringBuffer buffer = new StringBuffer();
        if (entry.getKeystoreType() != null) {
            buffer.append(KEYSTORE_TYPE + entry.getKeystoreType() + File.pathSeparator);
        }
        if (entry.getBackupDate() != null) {
            buffer.append(BACKUP_DATE + entry.getBackupDate().getTime());
        }
        return buffer.toString();
    }

    public Set<File> getMappedKeystores() throws IOException {
        HashSet<File> mappedKeystores = new HashSet<File>();
        Properties properties = this.load();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (!(k instanceof String)) continue;
            String key = (String)k;
            File keystoreFile = new File(key);
            mappedKeystores.add(keystoreFile);
        }
        return mappedKeystores;
    }

    public ViewStateEntry getEntry(File keystoreFile) throws IOException {
        Properties properties = this.load();
        Object v = properties.get(keystoreFile.getAbsolutePath());
        ViewStateEntry entry = null;
        if (v instanceof String) {
            String value = (String)v;
            StringTokenizer stringTokenizer = new StringTokenizer(value, File.pathSeparator);
            entry = new ViewStateEntry(keystoreFile);
            while (stringTokenizer.hasMoreTokens()) {
                String token = stringTokenizer.nextToken();
                if (token.contains(KEYSTORE_TYPE)) {
                    token = token.substring(KEYSTORE_TYPE.length());
                    entry.setKeystoreType(token);
                    continue;
                }
                if (!token.contains(BACKUP_DATE)) continue;
                token = token.substring(BACKUP_DATE.length());
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(Long.parseLong(token));
                Date date = calendar.getTime();
                entry.setBackupDate(date);
            }
        }
        return entry;
    }

    public boolean isKeystoreMapped(File keystoreFile) throws IOException {
        Properties properties = this.load();
        return properties.containsKey(keystoreFile.getAbsolutePath());
    }

    public void addEntry(File keystoreFile, String keystoreType) throws IOException {
        ViewStateEntry stateEntry = new ViewStateEntry(keystoreFile, keystoreType);
        this.addEntry(keystoreFile, stateEntry);
    }

    private void addEntry(File keystoreFile, ViewStateEntry stateEntry) throws IOException {
        Properties prop = this.load();
        prop.setProperty(keystoreFile.getAbsolutePath(), this.write(stateEntry));
        this.store(prop);
    }

    public void removeEntry(File keystoreFile) throws IOException {
        Properties properties = this.load();
        properties.remove(keystoreFile.getAbsolutePath());
        this.store(properties);
    }

    public void setBackupDate(File keystoreFile, Date backupDate) throws IOException {
        ViewStateEntry entry = this.getEntry(keystoreFile);
        entry.setBackupDate(backupDate);
        this.addEntry(keystoreFile, entry);
    }

    private Properties load() throws IOException {
        FileInputStream in = null;
        Properties props = new Properties();
        try {
            in = new FileInputStream(this.persistenceFile);
            props.loadFromXML(in);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return props;
    }

    private void store(Properties prop) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.persistenceFile);
            prop.storeToXML(out, FILE_COMMENT);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    AndmoreLogger.error((String)("Could not close stream while saving properties. " + e.getMessage()));
                }
            }
        }
    }

    protected class ViewStateEntry {
        private final File keystoreFile;
        private String keystoreType;
        private Date backupDate;

        public ViewStateEntry(File keystoreFile) {
            this.keystoreFile = keystoreFile;
        }

        public ViewStateEntry(File keystoreFile, String keystoreType) {
            this.keystoreFile = keystoreFile;
            this.keystoreType = keystoreType;
        }

        public Date getBackupDate() {
            return this.backupDate;
        }

        public void setBackupDate(Date backupDate) {
            this.backupDate = backupDate;
        }

        public String getKeystoreType() {
            return this.keystoreType;
        }

        public void setKeystoreType(String keystoreType) {
            this.keystoreType = keystoreType;
        }

        public String toString() {
            return "ViewStateEntry [keystoreFile=" + this.keystoreFile + ", keystoreType=" + this.keystoreType + ", backupDate=" + this.backupDate + "]";
        }

        protected File getKeystoreFile() {
            return this.keystoreFile;
        }
    }
}

