/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.packaging.sign;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateEncodingException;
import java.util.jar.Attributes;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.util.encoders.Base64Encoder;
import org.eclipse.andmore.android.certmanager.exception.KeyStoreManagerException;
import org.eclipse.andmore.android.certmanager.packaging.PackageFile;
import org.eclipse.andmore.android.certmanager.packaging.sign.SignException;
import org.eclipse.andmore.android.certmanager.packaging.sign.SignatureBlockFile;
import org.eclipse.andmore.android.certmanager.packaging.sign.SignatureFile;
import org.eclipse.andmore.android.certmanager.ui.model.IKeyStoreEntry;
import org.eclipse.andmore.android.common.log.AndmoreLogger;

public class PackageFileSigner {
    public static final String ECLIPSE_ANDMORE = "Eclipse Andmore";

    public static void signPackage(PackageFile packageFile, IKeyStoreEntry keystoreEntry, String keyEntryPassword, String createdBy) throws SignException, UnrecoverableKeyException {
        try {
            Base64Encoder encoder = new Base64Encoder();
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            PackageFileSigner.addFilesDigestsToManifest(packageFile, encoder, messageDigest);
            PackageFileSigner.addSignatureFiles(packageFile, keystoreEntry, keyEntryPassword, encoder, createdBy);
        }
        catch (UnrecoverableKeyException e) {
            throw e;
        }
        catch (Exception e) {
            AndmoreLogger.error(PackageFileSigner.class, (String)"Error signing package", (Throwable)e);
            throw new SignException(e.getMessage(), e);
        }
    }

    public static void removePackageSignature(PackageFile packageFile) throws IOException {
        packageFile.removeMetaEntryFiles();
    }

    private static void addFilesDigestsToManifest(PackageFile packageFile, Base64Encoder encoder, MessageDigest messageDigest) throws IOException {
        FileInputStream fileInputStream = null;
        ReadableByteChannel rc = null;
        ByteArrayOutputStream encodedStream = null;
        for (String entryName : packageFile.getEntryNames()) {
            File file = packageFile.getEntryFile(entryName);
            if (!file.isFile()) continue;
            try {
                fileInputStream = new FileInputStream(file);
                rc = Channels.newChannel(fileInputStream);
                ByteBuffer byteBuffer = ByteBuffer.allocate((int)file.length());
                rc.read(byteBuffer);
                messageDigest.reset();
                byte[] digestedArray = messageDigest.digest(byteBuffer.array());
                encodedStream = new ByteArrayOutputStream();
                encoder.encode(digestedArray, 0, digestedArray.length, (OutputStream)encodedStream);
                String digestedMessage = encodedStream.toString();
                Attributes jarEntryAttributes = new Attributes();
                jarEntryAttributes.putValue("SHA1-Digest", digestedMessage);
                packageFile.getManifest().getEntries().put(entryName, jarEntryAttributes);
            }
            finally {
                try {
                    if (encodedStream != null) {
                        encodedStream.close();
                    }
                    if (rc != null) {
                        rc.close();
                    }
                    if (fileInputStream != null) {
                        ((InputStream)fileInputStream).close();
                    }
                }
                catch (IOException e) {
                    AndmoreLogger.error((String)("Could not close stream while signing package. " + e.getMessage()));
                }
            }
        }
    }

    private static void addSignatureFiles(PackageFile packageFile, IKeyStoreEntry keystoreEntry, String keyEntryPassword, Base64Encoder encoder, String createdBy) throws IOException, SignException, UnrecoverableKeyException, KeyStoreException, KeyStoreManagerException, NoSuchAlgorithmException, InvalidKeyException, CertificateEncodingException, OperatorCreationException, CMSException {
        SignatureFile signatureFile = new SignatureFile(packageFile, keystoreEntry.getAlias(), encoder, createdBy);
        File sigFile = File.createTempFile("tmppkg_", null);
        FileOutputStream sigFileOutStream = null;
        try {
            sigFileOutStream = new FileOutputStream(sigFile);
            signatureFile.write(sigFileOutStream);
        }
        finally {
            if (sigFileOutStream != null) {
                try {
                    sigFileOutStream.close();
                }
                catch (IOException e) {
                    AndmoreLogger.error((String)("Could not close stream while adding signature files to package. " + e.getMessage()));
                }
            }
        }
        packageFile.setTempEntryFile(signatureFile.toString(), sigFile);
        SignatureBlockFile signatureBlockFile = new SignatureBlockFile(signatureFile, keystoreEntry, keyEntryPassword);
        File sigBlockFile = File.createTempFile("tmppkg_", null);
        FileOutputStream sigBlockFileOutStream = null;
        try {
            sigBlockFileOutStream = new FileOutputStream(sigBlockFile);
            signatureBlockFile.write(sigBlockFileOutStream);
        }
        finally {
            if (sigBlockFileOutStream != null) {
                try {
                    sigBlockFileOutStream.close();
                }
                catch (IOException e) {
                    AndmoreLogger.error((String)("Could not close stream while adding signature files to package. " + e.getMessage()));
                }
            }
        }
        packageFile.setTempEntryFile(signatureBlockFile.toString(), sigBlockFile);
    }
}

