/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.ui.dialogs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.andmore.android.certmanager.i18n.CertificateManagerNLS;
import org.eclipse.andmore.android.certmanager.ui.dialogs.BackupContentProvider;
import org.eclipse.andmore.android.certmanager.ui.dialogs.BackupLabelProvider;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class RestoreBackupDialog
extends TitleAreaDialog {
    private static final String ZIP_EXT = "*.zip";
    private static final String WIZARD_BANNER = "icons/wizban/restore_keystore_wiz.png";
    public static final String RESTORE_KEYSTORE_HELP_ID = "org.eclipse.andmore.android.certmanager.restore_keystore";
    private final IContentProvider contentProvider;
    private final IBaseLabelProvider labelProvider;
    private CheckboxTableViewer tableViewer;
    private final String title;
    private File archiveFile;
    private List<String> selectedKeyStores;
    private File destinationFile;
    private Button selectAllButton;
    private String destinationPath = "";

    public RestoreBackupDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.contentProvider = new BackupContentProvider();
        this.labelProvider = new BackupLabelProvider();
        this.title = CertificateManagerNLS.RestoreBackupDialog_Dialog_Title;
        this.selectedKeyStores = new ArrayList<String>();
        this.setTitleImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.andmore.android.certmanager", (String)WIZARD_BANNER).createImage());
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.title);
        this.setTitle(CertificateManagerNLS.RestoreBackupDialog_TitleArea_Message);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), RESTORE_KEYSTORE_HELP_ID);
        Composite dialogArea = new Composite(parent, 4);
        dialogArea.setLayout((Layout)new GridLayout());
        dialogArea.setLayoutData((Object)new GridData(4, 4, true, true));
        Group pathGroup = new Group(dialogArea, 32);
        pathGroup.setText(CertificateManagerNLS.RestoreBackupDialog_Path_Group);
        pathGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        pathGroup.setLayout((Layout)new GridLayout(3, false));
        Label pathLabel = new Label((Composite)pathGroup, 0);
        pathLabel.setText(CertificateManagerNLS.RestoreBackupDialog_BackUp_File);
        pathLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        final Text pathText = new Text((Composite)pathGroup, 2048);
        pathText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        pathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RestoreBackupDialog.this.archiveFile = new File(pathText.getText());
                RestoreBackupDialog.this.selectAllButton.setSelection(false);
                RestoreBackupDialog.this.validate();
                RestoreBackupDialog.this.loadArchiveEntries();
            }
        });
        Button browseButton = new Button((Composite)pathGroup, 8);
        browseButton.setText(CertificateManagerNLS.RestoreBackupDialog_Browse_Button);
        browseButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(RestoreBackupDialog.this.getShell());
                fileDialog.setFilterExtensions(new String[]{RestoreBackupDialog.ZIP_EXT});
                fileDialog.setOverwrite(false);
                String choosenPath = fileDialog.open();
                pathText.setText(choosenPath);
                super.widgetSelected(e);
            }
        });
        Label destinPath = new Label((Composite)pathGroup, 0);
        destinPath.setText(CertificateManagerNLS.RestoreBackupDialog_Destination);
        destinPath.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        final Text destinText = new Text((Composite)pathGroup, 2048);
        destinText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        destinText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RestoreBackupDialog.this.destinationPath = destinText.getText();
                RestoreBackupDialog.this.destinationFile = new File(RestoreBackupDialog.this.destinationPath);
                RestoreBackupDialog.this.validate();
            }
        });
        Button destinBrowseButton = new Button((Composite)pathGroup, 8);
        destinBrowseButton.setText(CertificateManagerNLS.RestoreBackupDialog_Browse_Button);
        destinBrowseButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        destinBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog directoryDialog = new DirectoryDialog(RestoreBackupDialog.this.getShell());
                String choosenPath = directoryDialog.open();
                destinText.setText(choosenPath);
                super.widgetSelected(e);
            }
        });
        Group keystoresGroup = new Group(dialogArea, 32);
        keystoresGroup.setText(CertificateManagerNLS.RestoreBackupDialog_KeyStores);
        keystoresGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        keystoresGroup.setLayout((Layout)new GridLayout(1, false));
        this.tableViewer = CheckboxTableViewer.newCheckList((Composite)keystoresGroup, (int)2848);
        this.tableViewer.setContentProvider(this.contentProvider);
        this.tableViewer.setLabelProvider(this.labelProvider);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.widthHint = 400;
        layoutData.heightHint = 200;
        this.tableViewer.getControl().setLayoutData((Object)layoutData);
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                String keyStore = null;
                Object element = event.getElement();
                if (element instanceof String) {
                    keyStore = (String)element;
                }
                if (keyStore != null) {
                    if (event.getChecked()) {
                        RestoreBackupDialog.this.selectedKeyStores.add(keyStore);
                    } else {
                        RestoreBackupDialog.this.selectedKeyStores.remove(keyStore);
                    }
                }
                if (RestoreBackupDialog.this.tableViewer.getCheckedElements().length == RestoreBackupDialog.this.tableViewer.getTable().getItems().length) {
                    RestoreBackupDialog.this.selectAllButton.setSelection(true);
                } else {
                    RestoreBackupDialog.this.selectAllButton.setSelection(false);
                }
                RestoreBackupDialog.this.validate();
            }
        });
        Composite selectButtonArea = new Composite((Composite)keystoresGroup, 0);
        selectButtonArea.setLayout((Layout)new GridLayout(1, true));
        selectButtonArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.selectAllButton = new Button(selectButtonArea, 32);
        this.selectAllButton.setText(CertificateManagerNLS.RestoreBackupDialog_Select_All);
        this.selectAllButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RestoreBackupDialog.this.tableViewer.setAllChecked(RestoreBackupDialog.this.selectAllButton.getSelection());
                RestoreBackupDialog.this.selectedKeyStores.clear();
                Object[] objectArray = RestoreBackupDialog.this.tableViewer.getCheckedElements();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    String keyStoreEl = (String)element;
                    RestoreBackupDialog.this.selectedKeyStores.add(keyStoreEl);
                    ++n2;
                }
                RestoreBackupDialog.this.validate();
                super.widgetSelected(e);
            }
        });
        this.setMessage(CertificateManagerNLS.RestoreBackupDialog_Default_Message);
        return dialogArea;
    }

    protected void loadArchiveEntries() {
        Runnable loadRunnable = new Runnable(){

            @Override
            public void run() {
                block14: {
                    if (RestoreBackupDialog.this.archiveFile.exists()) {
                        final List[] holderArray = new List[1];
                        ZipFile zipFile = null;
                        try {
                            try {
                                ArrayList<String> keyStores;
                                zipFile = new ZipFile(RestoreBackupDialog.this.archiveFile, 1);
                                holderArray[0] = keyStores = new ArrayList<String>(zipFile.size());
                                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                                while (entries.hasMoreElements()) {
                                    ZipEntry zipEntry = entries.nextElement();
                                    if (zipEntry.getName().equalsIgnoreCase("KsTypes.csv")) continue;
                                    keyStores.add(zipEntry.getName());
                                }
                                Display.getDefault().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        RestoreBackupDialog.this.tableViewer.setInput((Object)holderArray[0]);
                                    }
                                });
                            }
                            catch (Exception exception) {
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        RestoreBackupDialog.this.clearKeystoresTableViewer();
                                        RestoreBackupDialog.this.setErrorMessage(NLS.bind((String)CertificateManagerNLS.RestoreBackupDialog_Error_Loading_Entries, (Object)RestoreBackupDialog.this.archiveFile));
                                        RestoreBackupDialog.this.getButton(0).setEnabled(false);
                                    }
                                });
                                if (zipFile == null) break block14;
                                try {
                                    zipFile.close();
                                }
                                catch (IOException e) {
                                    AndmoreLogger.error((String)("Could not close stream while restoring backup. " + e.getMessage()));
                                }
                            }
                        }
                        finally {
                            if (zipFile != null) {
                                try {
                                    zipFile.close();
                                }
                                catch (IOException e) {
                                    AndmoreLogger.error((String)("Could not close stream while restoring backup. " + e.getMessage()));
                                }
                            }
                        }
                    }
                }
            }
        };
        Thread thread = new Thread(loadRunnable);
        thread.start();
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonBar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return buttonBar;
    }

    private void validate() {
        boolean isValid = true;
        if (!this.archiveFile.exists()) {
            this.clearKeystoresTableViewer();
            this.setErrorMessage(CertificateManagerNLS.RestoreBackupDialog_BackUpFile_Not_Exist);
            isValid = false;
        } else {
            this.setErrorMessage(null);
            isValid = true;
        }
        if (isValid) {
            if (this.destinationPath.isEmpty()) {
                this.setErrorMessage(CertificateManagerNLS.RestoreBackupDialog_Invalid_Dest_Path);
                isValid = false;
            } else if (this.destinationFile != null && this.destinationFile.isFile()) {
                this.setErrorMessage(CertificateManagerNLS.RestoreBackupDialog_Invalid_Dest_Path);
                isValid = false;
            } else {
                this.setErrorMessage(null);
                isValid = true;
            }
        }
        if (isValid) {
            if (this.selectedKeyStores.isEmpty()) {
                this.setErrorMessage(CertificateManagerNLS.RestoreBackupDialog_Select_KeyStore);
                isValid = false;
            } else {
                this.setErrorMessage(null);
                isValid = true;
            }
        }
        this.getButton(0).setEnabled(isValid);
    }

    private void clearKeystoresTableViewer() {
        this.tableViewer.setInput(null);
    }

    public File getArchiveFile() {
        return this.archiveFile;
    }

    public List<String> getSelectedKeyStores() {
        return this.selectedKeyStores;
    }

    public File getDestinationDir() {
        return this.destinationFile;
    }
}

