/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.ui.tree;

import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.Locale;
import org.eclipse.andmore.android.certmanager.ui.model.EntryNode;
import org.eclipse.andmore.android.certmanager.ui.model.IKeyStoreEntry;
import org.eclipse.jface.viewers.ColumnLabelProvider;

public class ExpiresInColumnLabelProvider
extends ColumnLabelProvider {
    public String getText(Object element) {
        if (element instanceof IKeyStoreEntry) {
            EntryNode keyStoreEntry = (EntryNode)element;
            X509Certificate x509Certificate = keyStoreEntry.getX509Certificate();
            return this.getExpiresInDate(x509Certificate);
        }
        return "";
    }

    private String getExpiresInDate(X509Certificate x509Certificate) {
        return x509Certificate != null ? DateFormat.getDateInstance(2, Locale.getDefault()).format(x509Certificate.getNotAfter()) : "";
    }
}

