/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.common.utilities.ui;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.TreeItem;

public class WidgetsFactory {
    public static final int GROUP_MARGIN_HEIGHT = 10;
    public static final int GROUP_MARGIN_WIDTH = 10;

    public static Composite createComposite(Composite parent) {
        Composite toReturn = new Composite(parent, 0);
        toReturn.setLayout((Layout)WidgetsFactory.createGridLayout());
        toReturn.setLayoutData((Object)new GridData(768));
        return toReturn;
    }

    public static Composite createComposite(Composite parent, int numColumns) {
        Composite toReturn = WidgetsFactory.createComposite(parent);
        ((GridLayout)toReturn.getLayout()).numColumns = numColumns;
        return toReturn;
    }

    public static Label createLine(Composite parent) {
        Label toReturn = new Label(parent, 259);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = ((GridLayout)parent.getLayout()).numColumns;
        toReturn.setLayoutData((Object)gridData);
        return toReturn;
    }

    public static GridLayout createGridLayout() {
        GridLayout toReturn = new GridLayout();
        toReturn.numColumns = 2;
        toReturn.makeColumnsEqualWidth = false;
        toReturn.marginWidth = 0;
        toReturn.marginHeight = 0;
        return toReturn;
    }

    public static GridLayout createGridLayout(int numColumns) {
        GridLayout toReturn = new GridLayout();
        toReturn.numColumns = numColumns;
        toReturn.makeColumnsEqualWidth = false;
        toReturn.marginWidth = 0;
        toReturn.marginHeight = 0;
        return toReturn;
    }

    public static GridLayout createGridLayout(int numColumns, Composite composite) {
        GridLayout toReturn = new GridLayout();
        toReturn.numColumns = numColumns;
        toReturn.makeColumnsEqualWidth = false;
        toReturn.marginWidth = 0;
        toReturn.marginHeight = 0;
        composite.setLayout((Layout)toReturn);
        return toReturn;
    }

    public static Label createLabel(Composite parent, String text) {
        return WidgetsFactory.createLabel(parent, text, 0);
    }

    public static Label createLabel(Composite parent, String text, int style) {
        Label toReturn = new Label(parent, style);
        if (text != null) {
            toReturn.setText(text);
        }
        toReturn.setFont(parent.getFont());
        return toReturn;
    }

    public static Combo createCombo(Composite parent) {
        Combo toReturn = new Combo(parent, 8);
        GridData data = new GridData(768);
        data.widthHint = 200;
        data.horizontalSpan = 1;
        toReturn.setLayoutData((Object)data);
        return toReturn;
    }

    public static Label createValueLabel(Composite parent, String text) {
        WidgetsFactory.createLabel(parent, text);
        return WidgetsFactory.createLabel(parent, null);
    }

    public static Button createButton(Composite parent, String text) {
        Button toReturn = new Button(parent, 8);
        toReturn.setFont(parent.getFont());
        toReturn.setText(text);
        toReturn.setLayoutData((Object)new GridData(768));
        return toReturn;
    }

    public static Table createTable(Composite parent) {
        Table toReturn = new Table(parent, 68354);
        GridData data = new GridData(1808);
        data.widthHint = 200;
        data.heightHint = toReturn.getItemHeight();
        data.horizontalSpan = 1;
        toReturn.setLayoutData((Object)data);
        return toReturn;
    }

    public static Table createTableMultiSelection(Composite parent) {
        Table toReturn = new Table(parent, 68354);
        GridData data = new GridData(1808);
        data.widthHint = 200;
        data.heightHint = toReturn.getItemHeight();
        data.horizontalSpan = 1;
        toReturn.setLayoutData((Object)data);
        return toReturn;
    }

    public static TableColumn createTableColumn(Table table, String text) {
        TableColumn toReturn = new TableColumn(table, 0);
        toReturn.setText(text);
        return toReturn;
    }

    public static TableItem createTableItem(Table table, Image image, String s) {
        TableItem toReturn = new TableItem(table, 0);
        toReturn.setText(s);
        if (image != null) {
            toReturn.setImage(image);
        }
        return toReturn;
    }

    public static TableItem createTableItem(Table table, Image image, String ... s) {
        TableItem toReturn = new TableItem(table, 0);
        toReturn.setText(s);
        if (image != null) {
            toReturn.setImage(image);
        }
        return toReturn;
    }

    public static Text createText(Composite parent) {
        Text toReturn = new Text(parent, 2048);
        GridData data = new GridData(768);
        data.widthHint = 200;
        toReturn.setLayoutData((Object)data);
        return toReturn;
    }

    public static TreeItem createTreeItem(TreeItem itemParent, Image image, String field, String text) {
        TreeItem toReturn = new TreeItem(itemParent, 0);
        toReturn.setText(text == null ? field : String.valueOf(field) + " (" + text + ")");
        toReturn.setImage(image);
        toReturn.setExpanded(true);
        return toReturn;
    }

    public static ToolBar createHorizontalToolBar(Composite parent) {
        return new ToolBar(parent, 256);
    }

    public static ToolItem createPushToolItem(ToolBar toolBar) {
        return new ToolItem(toolBar, 8);
    }

    public static Group createTitledGroup(Composite parent, String title) {
        Group toReturn = new Group(parent, 32);
        toReturn.setText(title);
        toReturn.setLayout((Layout)new GridLayout());
        toReturn.setLayoutData((Object)new GridData(1808));
        return toReturn;
    }

    public static Group createTitledGroup(Composite parent, String title, int numColumns) {
        Group toReturn = new Group(parent, 32);
        toReturn.setText(title);
        toReturn.setLayoutData((Object)new GridData(768));
        GridLayout layout = WidgetsFactory.createGridLayout(numColumns);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        toReturn.setLayout((Layout)layout);
        return toReturn;
    }

    public static Group createGroup(Composite parent) {
        Group toReturn = new Group(parent, 32);
        return toReturn;
    }

    public static Button createRadioButton(Composite parent, String text) {
        Button toReturn = new Button(parent, 16);
        toReturn.setText(text);
        toReturn.setLayoutData((Object)new GridData(1808));
        return toReturn;
    }

    public static List createList(Composite parent) {
        return new List(parent, 2052);
    }
}

