/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.model.manifest.dom;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.andmore.android.model.manifest.dom.ActionNode;
import org.eclipse.andmore.android.model.manifest.dom.AndroidManifestNode;
import org.eclipse.andmore.android.model.manifest.dom.CategoryNode;
import org.eclipse.andmore.android.model.manifest.dom.DataNode;
import org.eclipse.andmore.android.model.manifest.dom.IAndroidManifestProperties;
import org.eclipse.andmore.android.model.manifest.dom.UsesPermissionNode;
import org.eclipse.core.runtime.IStatus;

public class IntentFilterNode
extends AndroidManifestNode
implements IAndroidManifestProperties {
    private String propIcon = null;
    private String propLabel = null;
    private Integer propPriority = null;

    static {
        defaultProperties.add("android:icon");
        defaultProperties.add("android:label");
        defaultProperties.add("android:priority");
    }

    @Override
    protected boolean canContains(AndroidManifestNode.NodeType nodeType) {
        return nodeType == AndroidManifestNode.NodeType.Action || nodeType == AndroidManifestNode.NodeType.Category || nodeType == AndroidManifestNode.NodeType.Data || nodeType == AndroidManifestNode.NodeType.Comment;
    }

    @Override
    public Map<String, String> getNodeProperties() {
        this.properties.clear();
        if (this.propIcon != null && this.propIcon.trim().length() > 0) {
            this.properties.put("android:icon", this.propIcon);
        }
        if (this.propLabel != null && this.propLabel.length() > 0) {
            this.properties.put("android:label", this.propLabel);
        }
        if (this.propPriority != null) {
            this.properties.put("android:priority", this.propPriority.toString());
        }
        return this.properties;
    }

    @Override
    public AndroidManifestNode.NodeType getNodeType() {
        return AndroidManifestNode.NodeType.IntentFilter;
    }

    @Override
    protected boolean isNodeValid() {
        AndroidManifestNode[] actions = this.getAllChildrenFromType(AndroidManifestNode.NodeType.Action);
        return actions.length > 0;
    }

    public String getIcon() {
        return this.propIcon;
    }

    public void setIcon(String icon) {
        this.propIcon = icon;
    }

    public String getLabel() {
        return this.propLabel;
    }

    public void setLabel(String label) {
        this.propLabel = label;
    }

    public Integer getPriority() {
        return this.propPriority;
    }

    public void setPriority(Integer priority) {
        this.propPriority = priority;
    }

    public void addActionNode(ActionNode action) {
        if (action != null && !this.children.contains(action)) {
            this.children.add(action);
        }
    }

    public List<ActionNode> getActionNodes() {
        LinkedList<ActionNode> actions = new LinkedList<ActionNode>();
        AndroidManifestNode[] androidManifestNodeArray = this.getAllChildrenFromType(AndroidManifestNode.NodeType.Action);
        int n = androidManifestNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AndroidManifestNode node = androidManifestNodeArray[n2];
            actions.add((ActionNode)node);
            ++n2;
        }
        return actions;
    }

    public void removeActionNode(ActionNode action) {
        if (action != null) {
            this.children.remove(action);
        }
    }

    public void addCategoryNode(CategoryNode category) {
        if (category != null && !this.children.contains(category)) {
            this.children.add(category);
        }
    }

    public void addUsesPermissionNode(UsesPermissionNode permission) {
        if (permission != null && !this.children.contains(permission)) {
            this.children.add(permission);
        }
    }

    public List<CategoryNode> getCategoryNodes() {
        LinkedList<CategoryNode> categories = new LinkedList<CategoryNode>();
        AndroidManifestNode[] androidManifestNodeArray = this.getAllChildrenFromType(AndroidManifestNode.NodeType.Category);
        int n = androidManifestNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AndroidManifestNode node = androidManifestNodeArray[n2];
            categories.add((CategoryNode)node);
            ++n2;
        }
        return categories;
    }

    public List<UsesPermissionNode> getUsesPermissionNodes() {
        LinkedList<UsesPermissionNode> permissions = new LinkedList<UsesPermissionNode>();
        AndroidManifestNode[] androidManifestNodeArray = this.getAllChildrenFromType(AndroidManifestNode.NodeType.UsesPermission);
        int n = androidManifestNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AndroidManifestNode node = androidManifestNodeArray[n2];
            permissions.add((UsesPermissionNode)node);
            ++n2;
        }
        return permissions;
    }

    public void removeCategoryNode(CategoryNode category) {
        if (category != null) {
            this.children.remove(category);
        }
    }

    public void removeUsesPermissionNode(UsesPermissionNode permission) {
        if (permission != null) {
            this.children.remove(permission);
        }
    }

    public void addDataNode(DataNode data) {
        if (data != null && !this.children.contains(data)) {
            this.children.add(data);
        }
    }

    public List<DataNode> getDataNodes() {
        LinkedList<DataNode> datas = new LinkedList<DataNode>();
        AndroidManifestNode[] androidManifestNodeArray = this.getAllChildrenFromType(AndroidManifestNode.NodeType.Data);
        int n = androidManifestNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AndroidManifestNode node = androidManifestNodeArray[n2];
            datas.add((DataNode)node);
            ++n2;
        }
        return datas;
    }

    public void removeDataNode(DataNode data) {
        if (data != null) {
            this.children.remove(data);
        }
    }

    @Override
    protected List<IStatus> getSpecificNodeProblems() {
        return null;
    }

    public boolean isEmpty() {
        return this.getActionNodes().isEmpty() && this.getCategoryNodes().isEmpty() && this.getDataNodes().isEmpty() && this.getNodeProperties().isEmpty();
    }

    public ActionNode getActionNode(String name) {
        ActionNode result = null;
        for (ActionNode actionNode : this.getActionNodes()) {
            if (!actionNode.getName().equals(name)) continue;
            result = actionNode;
        }
        return result;
    }

    public CategoryNode getCategoryNode(String name) {
        CategoryNode result = null;
        for (CategoryNode categoryNode : this.getCategoryNodes()) {
            if (!categoryNode.getName().equals(name)) continue;
            result = categoryNode;
        }
        return result;
    }
}

