/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.devices.services.lang;

import java.util.List;
import java.util.Map;
import org.eclipse.andmore.android.DDMSUtils;
import org.eclipse.andmore.android.ISerialNumbered;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.devices.services.DeviceServicesPlugin;
import org.eclipse.andmore.android.devices.services.lang.model.LangWizard;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.sequoyah.device.framework.model.handler.IServiceHandler;
import org.eclipse.sequoyah.device.framework.model.handler.ServiceHandler;
import org.eclipse.ui.PlatformUI;

public class LangServiceHandler
extends ServiceHandler {
    private String languageID;
    private String countryID;

    public IServiceHandler newInstance() {
        return new LangServiceHandler();
    }

    public IStatus runService(IInstance instance, Map<Object, Object> arguments, IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        String serialNumber = ((ISerialNumbered)instance).getSerialNumber();
        DDMSUtils.changeLanguage((String)serialNumber, (String)this.languageID, (String)this.countryID);
        try {
            AndmoreLogger.collectUsageData((String)"change_language", (String)"emulator", (String)this.languageID, (String)"org.eclipse.andmore.android.devices.services", (String)DeviceServicesPlugin.getDefault().getBundle().getVersion().toString());
        }
        catch (Throwable throwable) {}
        return status;
    }

    public IStatus updatingService(IInstance instance, IProgressMonitor monitor) {
        AndmoreLogger.info((String)"Updating change language service");
        return Status.OK_STATUS;
    }

    public IStatus singleInit(List<IInstance> instances) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    LangWizard wizard = new LangWizard();
                    WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                    dialog.setPageSize(250, 75);
                    int ret = dialog.open();
                    if (ret == 0) {
                        LangServiceHandler.this.languageID = wizard.getlanguageId();
                        LangServiceHandler.this.countryID = wizard.getcountryId();
                    } else {
                        LangServiceHandler.this.languageID = null;
                        LangServiceHandler.this.countryID = null;
                    }
                }
                catch (Exception exception) {
                    AndmoreLogger.error((String)"Change Language TmL Service: could not open UI");
                }
            }
        });
        return super.singleInit(instances);
    }
}

