/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.gltrace.views.detail;

import java.util.Arrays;
import java.util.List;
import org.eclipse.andmore.gltrace.editors.GLCallGroups;
import org.eclipse.andmore.gltrace.editors.GLFunctionTraceViewer;
import org.eclipse.andmore.gltrace.model.GLCall;
import org.eclipse.andmore.gltrace.model.GLTrace;
import org.eclipse.andmore.gltrace.state.IGLProperty;
import org.eclipse.andmore.gltrace.views.StateView;
import org.eclipse.andmore.gltrace.views.detail.GlDrawCallDetailProvider;
import org.eclipse.andmore.gltrace.views.detail.ICallDetailProvider;
import org.eclipse.andmore.gltrace.views.detail.IDetailProvider;
import org.eclipse.andmore.gltrace.views.detail.IStateDetailProvider;
import org.eclipse.andmore.gltrace.views.detail.ShaderSourceDetailsProvider;
import org.eclipse.andmore.gltrace.views.detail.ShaderUniformDetailsProvider;
import org.eclipse.andmore.gltrace.views.detail.TextureImageDetailsProvider;
import org.eclipse.andmore.gltrace.views.detail.VboDetailProvider;
import org.eclipse.andmore.gltrace.views.detail.VertexAttribPointerDataDetailProvider;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;

public class DetailsPage
extends Page
implements ISelectionListener {
    private GLTrace mTrace;
    private IToolBarManager mToolBarManager;
    private Composite mTopComposite;
    private StackLayout mStackLayout;
    private Composite mBlankComposite;
    private List<IDetailProvider> mDetailProviders = Arrays.asList(new ShaderSourceDetailsProvider(), new ShaderUniformDetailsProvider(), new TextureImageDetailsProvider(), new VboDetailProvider(), new GlDrawCallDetailProvider(), new VertexAttribPointerDataDetailProvider());

    public DetailsPage(GLTrace trace) {
        this.mTrace = trace;
    }

    public void setInput(GLTrace trace) {
        this.mTrace = trace;
    }

    public void createControl(Composite parent) {
        this.mTopComposite = new Composite(parent, 0);
        this.mStackLayout = new StackLayout();
        this.mTopComposite.setLayout((Layout)this.mStackLayout);
        this.mTopComposite.setLayoutData((Object)new GridData(1808));
        this.mBlankComposite = new Composite(this.mTopComposite, 0);
        this.mToolBarManager = this.getSite().getActionBars().getToolBarManager();
        for (IDetailProvider provider : this.mDetailProviders) {
            provider.createControl(this.mTopComposite);
            for (IContributionItem item : provider.getToolBarItems()) {
                this.mToolBarManager.add(item);
            }
        }
        this.setDetailsProvider(null);
    }

    private void setDetailsProvider(IDetailProvider provider) {
        IContributionItem[] iContributionItemArray = this.mToolBarManager.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            item.setVisible(false);
            ++n2;
        }
        if (provider == null) {
            this.setTopControl((Control)this.mBlankComposite);
        } else {
            this.setTopControl(provider.getControl());
            for (IContributionItem item : provider.getToolBarItems()) {
                item.setVisible(true);
            }
        }
        this.mToolBarManager.update(true);
    }

    private void setTopControl(Control c) {
        this.mStackLayout.topControl = c;
        this.mTopComposite.layout();
    }

    public Control getControl() {
        return this.mTopComposite;
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        pageSite.getPage().addSelectionListener((ISelectionListener)this);
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        for (IDetailProvider provider : this.mDetailProviders) {
            provider.disposeControl();
        }
        super.dispose();
    }

    public void setFocus() {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part instanceof GLFunctionTraceViewer) {
            GLCall selectedCall = this.getSelectedCall((GLFunctionTraceViewer)part, selection);
            if (selectedCall == null) {
                return;
            }
            this.callSelected(selectedCall);
            return;
        }
        if (part instanceof StateView) {
            IGLProperty selectedProperty = this.getSelectedProperty((StateView)part, selection);
            if (selectedProperty == null) {
                return;
            }
            this.stateVariableSelected(selectedProperty);
            return;
        }
    }

    private void stateVariableSelected(IGLProperty property) {
        for (IDetailProvider p : this.mDetailProviders) {
            IStateDetailProvider sp;
            if (!(p instanceof IStateDetailProvider) || !(sp = (IStateDetailProvider)p).isApplicable(property)) continue;
            sp.updateControl(property);
            this.setDetailsProvider(sp);
            return;
        }
        this.setDetailsProvider(null);
    }

    private void callSelected(GLCall selectedCall) {
        for (IDetailProvider p : this.mDetailProviders) {
            ICallDetailProvider cp;
            if (!(p instanceof ICallDetailProvider) || !(cp = (ICallDetailProvider)p).isApplicable(selectedCall)) continue;
            cp.updateControl(this.mTrace, selectedCall);
            this.setDetailsProvider(cp);
            return;
        }
        this.setDetailsProvider(null);
    }

    private GLCall getSelectedCall(GLFunctionTraceViewer part, ISelection selection) {
        if (part.getTrace() != this.mTrace) {
            return null;
        }
        if (!(selection instanceof TreeSelection)) {
            return null;
        }
        Object data = ((TreeSelection)selection).getFirstElement();
        if (data instanceof GLCallGroups.GLCallNode) {
            return ((GLCallGroups.GLCallNode)data).getCall();
        }
        return null;
    }

    private IGLProperty getSelectedProperty(StateView view, ISelection selection) {
        Object data;
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection ssel = (IStructuredSelection)selection;
        List objects = ssel.toList();
        if (objects.size() > 0 && (data = objects.get(0)) instanceof IGLProperty) {
            return (IGLProperty)data;
        }
        return null;
    }
}

