/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.hierarchyviewer;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Log;
import com.android.hierarchyviewerlib.HierarchyViewerDirector;
import java.util.Calendar;
import org.eclipse.andmore.hierarchyviewer.HierarchyViewerPluginDirector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class HierarchyViewerPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.andmore.hierarchyviewer";
    public static final String ADB_LOCATION = "org.eclipse.andmore.hierarchyviewer.adb";
    private static HierarchyViewerPlugin sPlugin;
    private Color mRedColor;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        sPlugin = this;
        final MessageConsole messageConsole = new MessageConsole("Hierarchy Viewer", null);
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{messageConsole});
        final MessageConsoleStream consoleStream = messageConsole.newMessageStream();
        final MessageConsoleStream errorConsoleStream = messageConsole.newMessageStream();
        this.mRedColor = new Color((Device)Display.getDefault(), 255, 0, 0);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                errorConsoleStream.setColor(HierarchyViewerPlugin.this.mRedColor);
            }
        });
        Log.setLogOutput((Log.ILogOutput)new Log.ILogOutput(){

            public void printLog(Log.LogLevel logLevel, String tag, String message) {
                if (logLevel.getPriority() >= Log.LogLevel.ERROR.getPriority()) {
                    HierarchyViewerPlugin.printToStream(errorConsoleStream, tag, message);
                    ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)messageConsole);
                } else {
                    HierarchyViewerPlugin.printToStream(consoleStream, tag, message);
                }
            }

            public void printAndPromptLog(final Log.LogLevel logLevel, final String tag, final String message) {
                this.printLog(logLevel, tag, message);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = Display.getDefault().getActiveShell();
                        if (logLevel == Log.LogLevel.ERROR) {
                            MessageDialog.openError((Shell)shell, (String)tag, (String)message);
                        } else {
                            MessageDialog.openWarning((Shell)shell, (String)tag, (String)message);
                        }
                    }
                });
            }
        });
        final HierarchyViewerDirector director = HierarchyViewerPluginDirector.createDirector();
        director.startListenForDevices();
        AndroidDebugBridge.addDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)new AndroidDebugBridge.IDebugBridgeChangeListener(){

            public void bridgeChanged(AndroidDebugBridge bridge) {
                director.acquireBridge(bridge);
            }
        });
        director.acquireBridge(AndroidDebugBridge.getBridge());
        new Thread(){

            @Override
            public void run() {
                director.populateDeviceSelectionModel();
            }
        }.start();
    }

    public void stop(BundleContext context) throws Exception {
        sPlugin = null;
        super.stop(context);
        this.mRedColor.dispose();
        HierarchyViewerDirector director = HierarchyViewerDirector.getDirector();
        director.stopListenForDevices();
        director.stopDebugBridge();
        director.terminate();
    }

    public static HierarchyViewerPlugin getPlugin() {
        return sPlugin;
    }

    private static synchronized void printToStream(MessageConsoleStream stream, String tag, String message) {
        String dateTag = HierarchyViewerPlugin.getMessageTag(tag);
        stream.print(dateTag);
        stream.println(message);
    }

    private static String getMessageTag(String tag) {
        Calendar c = Calendar.getInstance();
        if (tag == null) {
            return String.format("[%1$tF %1$tT]", c);
        }
        return String.format("[%1$tF %1$tT - %2$s]", c, tag);
    }
}

