/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.hierarchyviewer.views;

import com.android.ddmuilib.ImageLoader;
import com.android.hierarchyviewerlib.HierarchyViewerDirector;
import com.android.hierarchyviewerlib.models.TreeViewModel;
import com.android.hierarchyviewerlib.ui.LayoutViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class LayoutView
extends ViewPart
implements TreeViewModel.ITreeChangeListener {
    public static final String ID = "org.eclipse.andmore.hierarchyviewer.views.LayoutView";
    private LayoutViewer mLayoutViewer;
    private Image mOnBlack;
    private Image mOnWhite;
    private Action mShowExtrasAction = new Action("Show &Extras", 2){

        public void run() {
            LayoutView.this.mLayoutViewer.setShowExtras(this.isChecked());
        }
    };
    private Action mLoadAllViewsAction = new Action("Load All &Views"){

        public void run() {
            HierarchyViewerDirector.getDirector().loadAllViews();
            LayoutView.this.mShowExtrasAction.setChecked(true);
            LayoutView.this.mLayoutViewer.setShowExtras(true);
        }
    };
    private Action mOnBlackWhiteAction = new Action("Change Background &Color"){

        public void run() {
            boolean newValue = !LayoutView.this.mLayoutViewer.getOnBlack();
            LayoutView.this.mLayoutViewer.setOnBlack(newValue);
            if (newValue) {
                this.setImageDescriptor(ImageDescriptor.createFromImage((Image)LayoutView.this.mOnWhite));
            } else {
                this.setImageDescriptor(ImageDescriptor.createFromImage((Image)LayoutView.this.mOnBlack));
            }
        }
    };

    public void createPartControl(Composite parent) {
        this.mShowExtrasAction.setAccelerator(SWT.MOD1 + 69);
        ImageLoader imageLoader = ImageLoader.getLoader(HierarchyViewerDirector.class);
        Image image = imageLoader.loadImage("show-extras.png", Display.getDefault());
        this.mShowExtrasAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)image));
        this.mShowExtrasAction.setToolTipText("Show images");
        this.mShowExtrasAction.setEnabled(TreeViewModel.getModel().getTree() != null);
        this.mOnWhite = imageLoader.loadImage("on-white.png", Display.getDefault());
        this.mOnBlack = imageLoader.loadImage("on-black.png", Display.getDefault());
        this.mOnBlackWhiteAction.setAccelerator(SWT.MOD1 + 67);
        this.mOnBlackWhiteAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)this.mOnWhite));
        this.mOnBlackWhiteAction.setToolTipText("Change layout viewer background color");
        this.mLoadAllViewsAction.setAccelerator(SWT.MOD1 + 86);
        image = imageLoader.loadImage("load-all-views.png", Display.getDefault());
        this.mLoadAllViewsAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)image));
        this.mLoadAllViewsAction.setToolTipText("Load all view images");
        this.mLoadAllViewsAction.setEnabled(TreeViewModel.getModel().getTree() != null);
        parent.setLayout((Layout)new FillLayout());
        this.mLayoutViewer = new LayoutViewer(parent);
        this.placeActions();
        TreeViewModel.getModel().addTreeChangeListener((TreeViewModel.ITreeChangeListener)this);
    }

    public void placeActions() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager mm = actionBars.getMenuManager();
        mm.removeAll();
        mm.add((IAction)this.mOnBlackWhiteAction);
        mm.add((IAction)this.mShowExtrasAction);
        mm.add((IAction)this.mLoadAllViewsAction);
        IToolBarManager tm = actionBars.getToolBarManager();
        tm.removeAll();
        tm.add((IAction)this.mOnBlackWhiteAction);
        tm.add((IAction)this.mShowExtrasAction);
        tm.add((IAction)this.mLoadAllViewsAction);
    }

    public void dispose() {
        super.dispose();
        TreeViewModel.getModel().removeTreeChangeListener((TreeViewModel.ITreeChangeListener)this);
    }

    public void setFocus() {
        this.mLayoutViewer.setFocus();
    }

    public void selectionChanged() {
    }

    public void treeChanged() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                LayoutView.this.mLoadAllViewsAction.setEnabled(TreeViewModel.getModel().getTree() != null);
                LayoutView.this.mShowExtrasAction.setEnabled(TreeViewModel.getModel().getTree() != null);
            }
        });
    }

    public void viewportChanged() {
    }

    public void zoomChanged() {
    }
}

