/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.tools.datamodel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.sequoyah.localization.editor.datatype.RowInfo;
import org.eclipse.sequoyah.localization.editor.datatype.RowInfoLeaf;
import org.eclipse.sequoyah.localization.tools.datamodel.LocalizationFile;
import org.eclipse.sequoyah.localization.tools.datamodel.LocalizationFileBean;
import org.eclipse.sequoyah.localization.tools.datamodel.LocalizationFileFactory;
import org.eclipse.sequoyah.localization.tools.datamodel.node.Node;
import org.eclipse.sequoyah.localization.tools.datamodel.node.NodeComment;
import org.eclipse.sequoyah.localization.tools.datamodel.node.StringArrayItemNode;
import org.eclipse.sequoyah.localization.tools.datamodel.node.StringArrayNode;
import org.eclipse.sequoyah.localization.tools.datamodel.node.StringNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringLocalizationFile
extends LocalizationFile {
    private final Map<String, StringNode> stringNodesMap = new HashMap<String, StringNode>();

    static {
        LocalizationFileFactory.getInstance().addFileType(StringLocalizationFile.class.getName(), StringLocalizationFile.class);
    }

    public StringLocalizationFile() {
    }

    public StringLocalizationFile(LocalizationFileBean localizationFileBean) {
        super(localizationFileBean);
        this.clearStringNodes();
        this.setStringNodes(localizationFileBean.getStringNodes());
        this.setStringArrayNodes(localizationFileBean.getStringArrays());
    }

    public static LocalizationFile create(LocalizationFileBean localizationFileBean) {
        StringLocalizationFile stringLocalizationFile = localizationFileBean != null ? new StringLocalizationFile(localizationFileBean) : null;
        return stringLocalizationFile;
    }

    public List<StringNode> getStringNodes() {
        ArrayList<StringNode> arrayList = new ArrayList<StringNode>();
        for (StringNode stringNode : this.stringNodesMap.values()) {
            if (stringNode instanceof StringArrayNode) continue;
            arrayList.add(stringNode);
        }
        return arrayList;
    }

    public List<StringArrayNode> getStringArrays() {
        ArrayList<StringArrayNode> arrayList = new ArrayList<StringArrayNode>();
        for (StringNode stringNode : this.stringNodesMap.values()) {
            if (!(stringNode instanceof StringArrayNode)) continue;
            StringArrayNode stringArrayNode = (StringArrayNode)stringNode;
            arrayList.add(stringArrayNode);
        }
        return arrayList;
    }

    public List<StringNode> getNodesWithTextContent() {
        ArrayList<StringNode> arrayList = new ArrayList<StringNode>();
        for (StringNode stringNode : this.stringNodesMap.values()) {
            if (!(stringNode instanceof StringArrayNode)) {
                arrayList.add(stringNode);
                continue;
            }
            StringArrayNode stringArrayNode = (StringArrayNode)stringNode;
            for (StringNode stringNode2 : stringArrayNode.getValues()) {
                arrayList.add(stringNode2);
            }
        }
        return arrayList;
    }

    public List<StringNode> getTopLevelNodes() {
        ArrayList<StringNode> arrayList = new ArrayList<StringNode>();
        arrayList.addAll(this.stringNodesMap.values());
        return arrayList;
    }

    public StringNode createNode(RowInfo rowInfo, String string, String string2) {
        Object object;
        Node node = null;
        if (rowInfo instanceof RowInfoLeaf) {
            object = (RowInfoLeaf)rowInfo;
            if (object.getParent() == null) {
                node = this.addStringNode(new StringNode(rowInfo.getKey(), string));
            } else {
                StringArrayNode stringArrayNode = this.stringNodesMap.containsKey(rowInfo.getKey()) ? (StringArrayNode)this.stringNodesMap.get(rowInfo.getKey()) : new StringArrayNode(rowInfo.getKey());
                this.stringNodesMap.put(stringArrayNode.getKey(), stringArrayNode);
                StringArrayItemNode stringArrayItemNode = new StringArrayItemNode(string, stringArrayNode, object.getPosition());
                node = this.addStringArrayItemNode(stringArrayItemNode);
            }
        } else if (rowInfo instanceof RowInfo) {
            object = rowInfo.getChildren();
            StringArrayNode stringArrayNode = new StringArrayNode(rowInfo.getKey());
            int n = 0;
            while (n < object.size()) {
                stringArrayNode.addValue(string, n);
                ++n;
            }
            node = this.addStringNode(stringArrayNode);
        }
        if (node != null) {
            node.setLocalizationFile(this);
            node.setDirty(true);
            object = new NodeComment();
            ((NodeComment)object).setComment(string2);
            node.setNodeComment((NodeComment)object);
        }
        return node;
    }

    public StringNode getStringNodeByKey(String string) {
        StringNode stringNode = this.stringNodesMap.get(string);
        return stringNode;
    }

    public void clearStringNodes() {
        this.stringNodesMap.clear();
    }

    public boolean containsKey(String string) {
        return this.stringNodesMap.containsKey(string);
    }

    public void setStringNodes(List<StringNode> list) {
        if (list != null) {
            for (StringNode stringNode : list) {
                this.stringNodesMap.put(stringNode.getKey(), stringNode);
                stringNode.setLocalizationFile(this);
            }
        }
    }

    public void setStringArrayNodes(List<StringArrayNode> list) {
        if (list != null) {
            for (StringArrayNode stringArrayNode : list) {
                List<StringArrayItemNode> list2 = stringArrayNode.getValues();
                for (StringNode stringNode : list2) {
                    stringNode.setLocalizationFile(this);
                }
                stringArrayNode.setLocalizationFile(this);
                this.stringNodesMap.put(stringArrayNode.getKey(), stringArrayNode);
            }
        }
    }

    public void removeNode(String string) {
        this.stringNodesMap.remove(string);
    }

    public List<StringNode> getModifiedStringNodes() {
        ArrayList<StringNode> arrayList = new ArrayList<StringNode>();
        for (StringNode stringNode : this.getNodesWithTextContent()) {
            if (!stringNode.isDirty()) continue;
            arrayList.add(stringNode);
        }
        return arrayList;
    }

    public StringNode addStringNode(StringNode stringNode) {
        StringNode stringNode2 = stringNode;
        stringNode2.setLocalizationFile(this);
        this.stringNodesMap.put(stringNode2.getKey(), stringNode2);
        this.setDirty(true);
        return stringNode2;
    }

    public void removeStringNode(StringNode stringNode) {
        if (this.stringNodesMap.containsKey(stringNode.getKey())) {
            this.stringNodesMap.remove(stringNode.getKey());
            this.setDirty(true);
        }
    }

    public void removeStringArrayItemNode(StringArrayItemNode stringArrayItemNode) {
        if (stringArrayItemNode != null && this.stringNodesMap.containsKey(stringArrayItemNode.getParent().getKey())) {
            stringArrayItemNode.getParent().removeValue(stringArrayItemNode);
            this.setDirty(true);
        }
    }

    public StringNode addStringArrayItemNode(StringArrayItemNode stringArrayItemNode) {
        StringArrayItemNode stringArrayItemNode2 = stringArrayItemNode;
        if (stringArrayItemNode != null) {
            StringNode stringNode = this.stringNodesMap.get(stringArrayItemNode.getParent().getKey());
            if (stringNode instanceof StringArrayNode) {
                ((StringArrayNode)stringNode).addValue(stringArrayItemNode.getValue(), stringArrayItemNode.getPosition(), false);
            }
            this.setDirty(true);
        }
        return stringArrayItemNode2;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = true;
        if (!super.equals(object)) {
            bl = false;
        } else {
            StringLocalizationFile stringLocalizationFile = (StringLocalizationFile)object;
            List<StringNode> list = stringLocalizationFile.getNodesWithTextContent();
            List<StringNode> list2 = this.removeBlankArrayItems(this.getNodesWithTextContent());
            List<StringNode> list3 = this.removeBlankArrayItems(list);
            Collections.sort(list2);
            Collections.sort(list3);
            if (list2.size() != list3.size()) {
                bl = false;
            } else {
                int n = 0;
                while (n < list2.size()) {
                    boolean bl2;
                    boolean bl3 = list2.get(n).getKey().equals(list3.get(n).getKey());
                    String string = System.getProperty("line.separator");
                    String string2 = list2.get(n).getValue() != null ? list2.get(n).getValue().replaceAll(string, "\n") : null;
                    String string3 = list3.get(n).getValue();
                    boolean bl4 = bl2 = string2 != null && string3 != null ? string2.equals(string3) : false;
                    if (!bl3 || !bl2) {
                        bl = false;
                        break;
                    }
                    ++n;
                }
            }
        }
        return bl;
    }

    private List<StringNode> removeBlankArrayItems(List<StringNode> list) {
        ArrayList<StringNode> arrayList = new ArrayList<StringNode>();
        for (StringNode stringNode : list) {
            if (stringNode instanceof StringArrayNode) {
                if (stringNode.getValue().equals("")) continue;
                arrayList.add(stringNode);
                continue;
            }
            arrayList.add(stringNode);
        }
        return arrayList;
    }

    public void renameNodeKey(String string, String string2) {
        StringNode stringNode = this.getStringNodeByKey(string);
        if (stringNode != null) {
            this.removeStringNode(stringNode);
            stringNode.setKey(string2);
            this.addStringNode(stringNode);
        }
    }
}

