/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.packaging.sign;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.jar.Attributes;
import org.bouncycastle.util.encoders.Base64Encoder;
import org.eclipse.andmore.android.common.log.AndmoreLogger;

public class ManifestEntry {
    public static final String MANIFEST_NEW_LINE = "\r\n";
    public static final String ENTRY_NAME_ATTRIBUTE = "Name: ";
    public static final String UTF8_CHARSET = "UTF-8";
    public static final int SAFE_LIMIT = 72;
    private final String name;
    private final Attributes attributes;

    public ManifestEntry(String name, Attributes attr) {
        this.name = name;
        this.attributes = attr;
    }

    public byte[] toManifestEntryBytes() {
        byte[] result = null;
        FilterOutputStream dataOut = null;
        ByteArrayOutputStream stream = null;
        try {
            try {
                stream = new ByteArrayOutputStream();
                dataOut = new DataOutputStream(stream);
                String nameField = ManifestEntry.wrap72bytes(ENTRY_NAME_ATTRIBUTE + this.name);
                ((DataOutputStream)dataOut).writeBytes(nameField);
                ((DataOutputStream)dataOut).writeBytes(MANIFEST_NEW_LINE);
                ((DataOutputStream)dataOut).writeBytes(this.getAttributesString());
                ((DataOutputStream)dataOut).writeBytes(MANIFEST_NEW_LINE);
                ((DataOutputStream)dataOut).writeBytes(MANIFEST_NEW_LINE);
                result = stream.toString().getBytes(UTF8_CHARSET);
            }
            catch (IOException iOException) {
                AndmoreLogger.error(ManifestEntry.class, (String)"Error getting manifest like bytes");
                try {
                    if (dataOut != null) {
                        dataOut.close();
                    }
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e) {
                    AndmoreLogger.error((String)("Could not close stream while writing manifest" + e.getMessage()));
                }
            }
        }
        finally {
            try {
                if (dataOut != null) {
                    dataOut.close();
                }
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                AndmoreLogger.error((String)("Could not close stream while writing manifest" + e.getMessage()));
            }
        }
        return result;
    }

    public byte[] digest() {
        byte[] digested = null;
        try {
            MessageDigest digester = MessageDigest.getInstance("SHA-1");
            digester.reset();
            digester.update(this.toManifestEntryBytes());
            digested = digester.digest();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            AndmoreLogger.error(ManifestEntry.class, (String)"Error digesting manifest bytes");
        }
        return digested;
    }

    private String getAttributesString() {
        StringBuilder builder = new StringBuilder();
        Iterator<Object> it = this.attributes.keySet().iterator();
        while (it.hasNext()) {
            Object next = it.next();
            String line = ManifestEntry.wrap72bytes(next + ": " + this.attributes.get(next));
            if (it.hasNext()) {
                line = String.valueOf(line) + MANIFEST_NEW_LINE;
            }
            builder.append(line);
        }
        return builder.toString();
    }

    public static String wrap72bytes(String line) {
        String returnString = line;
        if (line.length() > 72) {
            int maximumLength = 72 - MANIFEST_NEW_LINE.length();
            StringBuilder wrapped = new StringBuilder();
            int index = maximumLength;
            String first = line.substring(0, index);
            first = String.valueOf(first) + MANIFEST_NEW_LINE;
            wrapped.append(first);
            while (index < line.length()) {
                String medium = " ";
                medium = index + maximumLength < line.length() ? String.valueOf(medium) + line.substring(index, index + maximumLength) : String.valueOf(medium) + line.substring(index);
                wrapped.append(medium);
                index += maximumLength;
            }
            returnString = wrapped.toString();
        }
        return returnString;
    }

    public String getName() {
        return this.name;
    }

    public String toDigestedManifestEntry() throws IOException {
        Base64Encoder encoder = new Base64Encoder();
        StringBuilder builder = new StringBuilder();
        ByteArrayOutputStream output = null;
        try {
            output = new ByteArrayOutputStream();
            builder.append(ManifestEntry.wrap72bytes(ENTRY_NAME_ATTRIBUTE + this.name));
            builder.append(MANIFEST_NEW_LINE);
            builder.append("SHA1-Digest: ");
            byte[] digest = this.digest();
            encoder.encode(digest, 0, digest.length, (OutputStream)output);
            builder.append(output.toString());
            builder.append(MANIFEST_NEW_LINE);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    AndmoreLogger.error((String)("Could not close stream: " + e.getMessage()));
                }
            }
        }
        return builder.toString();
    }
}

