/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.certmanager.packaging.sign;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.bouncycastle.util.encoders.Base64Encoder;
import org.eclipse.andmore.android.certmanager.packaging.PackageFile;
import org.eclipse.andmore.android.certmanager.packaging.sign.ManifestDigester;
import org.eclipse.andmore.android.certmanager.packaging.sign.ManifestEntry;
import org.eclipse.andmore.android.certmanager.packaging.sign.SignException;
import org.eclipse.andmore.android.common.log.AndmoreLogger;

public class SignatureFile {
    private final PackageFile packageFile;
    private Base64Encoder encoder = new Base64Encoder();
    private final String createdBy;

    public SignatureFile(PackageFile packageFile, String alias, Base64Encoder encoder, String createdBy) {
        this.packageFile = packageFile;
        this.encoder = encoder;
        this.createdBy = createdBy;
    }

    public String toString() {
        return "META-INF/CERT.SF";
    }

    public void write(OutputStream outputStream) throws IOException, SignException {
        Manifest manifestFile = this.packageFile.getManifest();
        ManifestDigester manifestDigester = new ManifestDigester(manifestFile);
        Manifest signatureFile = new Manifest();
        byte[] digestedMainAttributes = manifestDigester.getDigestedManifestMainAttributes();
        byte[] digestedManifest = manifestDigester.getDigestedManifest();
        Attributes signatureFileMainAtt = signatureFile.getMainAttributes();
        signatureFileMainAtt.putValue("Signature-Version", "1.0");
        signatureFileMainAtt.putValue("Created-By", this.createdBy);
        ByteArrayOutputStream stream = null;
        try {
            stream = new ByteArrayOutputStream();
            this.encoder.encode(digestedMainAttributes, 0, digestedMainAttributes.length, (OutputStream)stream);
            String encodedMainAttributesDigest = stream.toString();
            stream.reset();
            this.encoder.encode(digestedManifest, 0, digestedManifest.length, (OutputStream)stream);
            String encodedManifestDigest = stream.toString();
            signatureFileMainAtt.putValue("SHA1-Digest-Manifest-Main-Attributes", encodedMainAttributesDigest);
            signatureFileMainAtt.putValue("SHA1-Digest-Manifest", encodedManifestDigest);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    AndmoreLogger.error((String)("Could not close stream writing signature file. " + e.getMessage()));
                }
            }
        }
        ByteArrayOutputStream baos = null;
        try {
            try {
                baos = new ByteArrayOutputStream();
                manifestFile.write(baos);
                Map<String, Attributes> manifestEntries = manifestFile.getEntries();
                Map<String, Attributes> signatureFileEntries = signatureFile.getEntries();
                HashMap<String, ManifestEntry> entries = manifestDigester.getEntries();
                for (String manifestEntryKey : manifestEntries.keySet()) {
                    ManifestEntry signatureFileEntry = entries.get(manifestEntryKey);
                    byte[] digestedArray = signatureFileEntry.digest();
                    ByteArrayOutputStream encodedStream = null;
                    try {
                        encodedStream = new ByteArrayOutputStream();
                        this.encoder.encode(digestedArray, 0, digestedArray.length, (OutputStream)encodedStream);
                        String digestedValue = encodedStream.toString();
                        Attributes signatureFileAtt = new Attributes();
                        signatureFileAtt.putValue("SHA1-Digest", digestedValue);
                        signatureFileEntries.put(manifestEntryKey, signatureFileAtt);
                    }
                    finally {
                        try {
                            if (encodedStream != null) {
                                encodedStream.close();
                            }
                        }
                        catch (IOException e) {
                            AndmoreLogger.error((String)("Could not close stream: " + e.getMessage()));
                        }
                    }
                }
            }
            catch (IOException e) {
                AndmoreLogger.error(SignatureFile.class, (String)("I/O error digesting manifest entries: " + e.getMessage()));
                throw new SignException("I/O error digesting manifest entries", e);
            }
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                }
            }
            catch (IOException e) {
                AndmoreLogger.error((String)("Could not close stream: " + e.getMessage()));
            }
        }
        signatureFile.write(outputStream);
        AndmoreLogger.info(SignatureFile.class, (String)"Signature file was written");
    }
}

