/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.manifest;

import org.eclipse.andmore.android.common.exception.AndroidException;
import org.eclipse.andmore.android.common.utilities.FileUtil;
import org.eclipse.andmore.android.common.utilities.i18n.UtilitiesNLS;
import org.eclipse.andmore.android.model.manifest.AndroidManifestFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;

public class AndroidProjectManifestFile {
    private static final String ANDROID_MANIFEST_FILENAME = "AndroidManifest.xml";

    public static AndroidManifestFile getFromProject(IProject project) throws AndroidException, CoreException {
        Assert.isLegal((project != null ? 1 : 0) != 0);
        AndroidManifestFile androidManifestFile = null;
        IResource resManifest = project.findMember("/AndroidManifest.xml");
        if (resManifest != null && resManifest instanceof IFile) {
            if (!resManifest.exists()) {
                String errMsg = NLS.bind((String)UtilitiesNLS.ERR_AndroidProjectManifest_AndroidManifestDoesNotExist, (Object)project.getName());
                throw new AndroidException(errMsg);
            }
        } else {
            String errMsg = NLS.bind((String)UtilitiesNLS.ERR_AndroidProjectManifest_AndroidManifestDoesNotExist, (Object)project.getName());
            throw new AndroidException(errMsg);
        }
        IFile manifestFile = (IFile)resManifest;
        IDocument document = FileUtil.readFile(manifestFile);
        androidManifestFile = new AndroidManifestFile();
        androidManifestFile.parseDocument(document);
        return androidManifestFile;
    }

    public static void saveToProject(IProject project, AndroidManifestFile androidManifestFile, boolean overwrite) throws AndroidException, CoreException {
        Assert.isLegal((project != null ? 1 : 0) != 0);
        Assert.isLegal((androidManifestFile != null ? 1 : 0) != 0);
        IFile manifestFile = project.getFile("/AndroidManifest.xml");
        IDocument document = androidManifestFile.getContent();
        FileUtil.saveFile(manifestFile, document, "UTF-8", overwrite);
    }
}

