/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.db.core.command;

import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.db.core.CanRefreshStatus;
import org.eclipse.andmore.android.db.core.DbCoreActivator;
import org.eclipse.andmore.android.db.core.i18n.DbCoreNLS;
import org.eclipse.andmore.android.db.core.ui.ITreeNode;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;

public class RefreshNodeHandler
extends AbstractHandler
implements IHandler {
    private ITreeNode node;

    public RefreshNodeHandler() {
    }

    public RefreshNodeHandler(ITreeNode node) {
        this.node = node;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.node == null) {
            this.node = this.getSelectedItem();
        }
        Runnable asyncRefresh = new Runnable(){

            @Override
            public void run() {
                if (RefreshNodeHandler.this.node != null) {
                    boolean canRefresh = false;
                    boolean canRefreshInput = true;
                    IStatus status = RefreshNodeHandler.this.node.canRefresh();
                    if (status.isOK()) {
                        canRefresh = true;
                    } else if (status instanceof CanRefreshStatus && status.matches(16)) {
                        if (status.matches(48)) {
                            int dialogResults = EclipseUtils.showQuestionWithCancelDialog((String)NLS.bind((String)DbCoreNLS.RefreshNodeHandler_RefreshingNode_Msg_Title, (Object)RefreshNodeHandler.this.node.getName()), (String)status.getMessage());
                            if (dialogResults != 256) {
                                canRefreshInput = dialogResults == 64;
                                canRefresh = true;
                            }
                        } else {
                            canRefresh = EclipseUtils.showQuestionDialog((String)NLS.bind((String)DbCoreNLS.RefreshNodeHandler_RefreshingNode_Msg_Title, (Object)RefreshNodeHandler.this.node.getName()), (String)status.getMessage());
                        }
                    } else {
                        EclipseUtils.showErrorDialog((String)NLS.bind((String)DbCoreNLS.RefreshNodeHandler_RefreshingNode_Error_Msg, (Object)RefreshNodeHandler.this.node.getName()), (String)status.getMessage(), (IStatus)status);
                    }
                    if (canRefresh) {
                        RefreshNodeHandler.this.node.refreshAsync(canRefreshInput);
                        RefreshNodeHandler.this.node = null;
                    }
                }
            }
        };
        Thread refreshThread = new Thread(asyncRefresh);
        refreshThread.start();
        return null;
    }

    private ITreeNode getSelectedItem() {
        ITreeNode selectedNode = DbCoreActivator.getAndmoreDatabaseExplorerView().getSelectedItemOnTree();
        return selectedNode;
    }
}

