/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.db.core.event;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.andmore.android.db.core.event.DatabaseModelEvent;
import org.eclipse.andmore.android.db.core.event.IDatabaseModelListener;
import org.eclipse.andmore.android.db.core.ui.ITreeNode;

public class DatabaseModelEventManager {
    private static DatabaseModelEventManager _instance;
    private final List<IDatabaseModelListener> listeners = new ArrayList<IDatabaseModelListener>();

    private DatabaseModelEventManager() {
    }

    public static synchronized DatabaseModelEventManager getInstance() {
        if (_instance == null) {
            _instance = new DatabaseModelEventManager();
        }
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IDatabaseModelListener listener) {
        IDatabaseModelListener iDatabaseModelListener = listener;
        synchronized (iDatabaseModelListener) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListeners(IDatabaseModelListener listener) {
        IDatabaseModelListener iDatabaseModelListener = listener;
        synchronized (iDatabaseModelListener) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEvent(ITreeNode node, DatabaseModelEvent.EVENT_TYPE eventType) {
        DatabaseModelEvent databaseModelEvent = new DatabaseModelEvent(node, eventType);
        List<IDatabaseModelListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners != null) {
                for (IDatabaseModelListener listener : this.listeners) {
                    switch (eventType) {
                        case ADD: {
                            listener.handleNodeAdditionEvent(databaseModelEvent);
                            break;
                        }
                        case REMOVE: {
                            listener.handleNodeRemovalEvent(databaseModelEvent);
                            break;
                        }
                        case UPDATE: {
                            listener.handleNodeUpdateEvent(databaseModelEvent);
                            break;
                        }
                        case CLEAR: {
                            listener.handleNodeClearEvent(databaseModelEvent);
                            break;
                        }
                        case EXPAND: {
                            listener.handleNodeExpandEvent(databaseModelEvent);
                            break;
                        }
                        case SELECT: {
                            listener.handleNodeSelectEvent(databaseModelEvent);
                            break;
                        }
                    }
                }
            }
        }
    }
}

