/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.db.core.filesystem;

import java.util.List;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.db.core.event.DatabaseModelEvent;
import org.eclipse.andmore.android.db.core.event.DatabaseModelEventManager;
import org.eclipse.andmore.android.db.core.exception.AndmoreDbException;
import org.eclipse.andmore.android.db.core.i18n.DbCoreNLS;
import org.eclipse.andmore.android.db.core.ui.AbstractTreeNode;
import org.eclipse.andmore.android.db.core.ui.DbNode;
import org.eclipse.andmore.android.db.core.ui.IDbMapperNode;
import org.eclipse.andmore.android.db.core.ui.IDbNode;
import org.eclipse.andmore.android.db.core.ui.ISaveStateTreeNode;
import org.eclipse.andmore.android.db.core.ui.ITreeNode;
import org.eclipse.andmore.android.db.core.ui.view.SaveStateManager;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class FilesystemRootNode
extends AbstractTreeNode
implements IDbMapperNode,
ISaveStateTreeNode {
    private static final String MEMENTO_KEY = "FileSystemNode";
    private static final String MEMENTO_PATH_PREFIX = "MappedPath_";
    private static final String ICON_PATH = "icons/filesystem.png";

    public FilesystemRootNode() {
    }

    public FilesystemRootNode(ITreeNode parent) {
        super(parent);
    }

    public FilesystemRootNode(String id, String name, ITreeNode parent) {
        super(id, name, parent);
    }

    public FilesystemRootNode(String id, String name, ITreeNode parent, ImageDescriptor icon) {
        super(id, name, parent, icon);
    }

    @Override
    public void refresh() {
        List<ITreeNode> children = this.getChildren();
        for (ITreeNode child : children) {
            if (!(child instanceof DbNode)) continue;
            DbNode dbNode = (DbNode)child;
            if (!dbNode.existsDbFile()) {
                Status error = new Status(4, "org.eclipse.andmore.android.db.core", DbCoreNLS.FilesystemRootNode_Mapped_Db_Not_Found);
                dbNode.setNodeStatus((IStatus)error);
                continue;
            }
            dbNode.setNodeStatus(Status.OK_STATUS);
        }
    }

    @Override
    public boolean isLeaf() {
        return this.getChildren().isEmpty();
    }

    @Override
    public ImageDescriptor getIcon() {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.andmore.android.db.core", (String)ICON_PATH);
    }

    @Override
    public boolean testAttribute(Object target, String name, String value) {
        boolean canUnmap = false;
        if (name.equals("org.eclipse.andmore.android.db.core.mappedDatabases") && value.equals("org.eclipse.andmore.android.db.core.atLeastOne") && !this.getChildren().isEmpty()) {
            canUnmap = true;
        }
        return canUnmap;
    }

    @Override
    public IStatus map(IPath dbFilePath) {
        Status status = new Status(0, "org.eclipse.andmore.android.db.core", DbCoreNLS.FilesystemRootNode_Map_Successful);
        DbNode dbNode = null;
        try {
            dbNode = new DbNode(dbFilePath, this);
            this.putChild(dbNode);
            DatabaseModelEventManager.getInstance().fireEvent(dbNode, DatabaseModelEvent.EVENT_TYPE.SELECT);
            this.saveState(SaveStateManager.getInstance().getPrefNode());
        }
        catch (AndmoreDbException andmoreDbException) {
            status = new Status(4, "org.eclipse.andmore.android.db.core", NLS.bind((String)DbCoreNLS.FilesystemRootNode_Error_Mapping_Description, (Object)dbFilePath));
        }
        return status;
    }

    @Override
    public IStatus unmap(ITreeNode dbNode) {
        Status status = new Status(0, "org.eclipse.andmore.android.db.core", DbCoreNLS.FilesystemRootNode_Unmapping_Successful);
        if (dbNode instanceof IDbNode) {
            IDbNode node = (IDbNode)dbNode;
            if (node.isConnected()) {
                status = node.disconnect();
            }
            this.removeChild(node);
            this.saveState(SaveStateManager.getInstance().getPrefNode());
        }
        return status;
    }

    @Override
    public IStatus unmap(List<ITreeNode> dbNodeList) {
        MultiStatus operationsStatus = null;
        if (dbNodeList != null) {
            String msg;
            boolean hasError = false;
            IStatus[] children = new IStatus[dbNodeList.size()];
            int i = 0;
            for (ITreeNode treeNode : dbNodeList) {
                IStatus operationStatus = this.unmap(treeNode);
                if (!operationStatus.isOK()) {
                    hasError = true;
                }
                children[i] = operationStatus;
                ++i;
            }
            int code = hasError ? 4 : 0;
            operationsStatus = new MultiStatus("org.eclipse.andmore.android.db.core", code, children, msg = hasError ? DbCoreNLS.FilesystemRootNode_UnmappingList_Error : DbCoreNLS.FilesystemRootNode_UnmappingList_Successful, null);
            if (operationsStatus.isOK()) {
                this.saveState(SaveStateManager.getInstance().getPrefNode());
            }
        }
        return operationsStatus;
    }

    @Override
    public void saveState(IEclipsePreferences preferences) {
        Preferences node = preferences.node(MEMENTO_KEY);
        int i = 1;
        List<ITreeNode> children = this.getChildren();
        for (ITreeNode child : children) {
            DbNode dbNode = (DbNode)child;
            node.put(MEMENTO_PATH_PREFIX + i, dbNode.getPath().toString());
            ++i;
        }
        try {
            preferences.flush();
        }
        catch (BackingStoreException backingStoreException) {
            AndmoreLogger.debug((Object)this, (String)"Unable to save preferences, flush failed.");
        }
    }

    @Override
    public void restoreState(IEclipsePreferences preferences) {
        try {
            Preferences node;
            String[] attributeKeys;
            if (preferences.nodeExists(MEMENTO_KEY) && (attributeKeys = (node = preferences.node(MEMENTO_KEY)).keys()).length > 0) {
                String[] stringArray = attributeKeys;
                int n = attributeKeys.length;
                int n2 = 0;
                while (n2 < n) {
                    String mappedPath;
                    String key = stringArray[n2];
                    if (key.startsWith(MEMENTO_PATH_PREFIX) && (mappedPath = node.get(key, null)) != null) {
                        this.map((IPath)new Path(mappedPath));
                    }
                    ++n2;
                }
            }
        }
        catch (BackingStoreException backingStoreException) {
            AndmoreLogger.debug((Object)this, (String)"Unable to restore preferences.");
        }
    }
}

