/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.db.core.ui;

import org.eclipse.andmore.android.db.core.i18n.DbCoreNLS;
import org.eclipse.andmore.android.db.core.model.DbModel;
import org.eclipse.andmore.android.db.core.ui.AbstractTreeNode;
import org.eclipse.andmore.android.db.core.ui.IDataSampler;
import org.eclipse.andmore.android.db.core.ui.ITreeNode;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.jface.resource.ImageDescriptor;

public class ColumnNode
extends AbstractTreeNode
implements IDataSampler {
    private boolean isPrimKey = false;
    private final Column column;
    private final DbModel model;

    public ColumnNode(Column column, DbModel model, ITreeNode parent) {
        super(parent);
        StringBuilder nameBuilder;
        this.column = column;
        this.model = model;
        this.setId(column.getName());
        StringBuilder stringBuilder = nameBuilder = column.getDataType() != null ? new StringBuilder(String.valueOf(column.getName()) + " [" + column.getDataType().getName()) : new StringBuilder(String.valueOf(column.getName()) + " [" + DbCoreNLS.ColumnNode_UnknownType);
        if (column.isPartOfPrimaryKey()) {
            nameBuilder.append(" PK");
            this.isPrimKey = true;
        }
        nameBuilder.append("]");
        this.setName(nameBuilder.toString());
    }

    @Override
    public void refresh() {
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public ImageDescriptor getIcon() {
        String iconPath = this.isPrimKey ? "icons/pkColumn.gif" : "icons/columns.gif";
        return this.getSpecificIcon("org.eclipse.datatools.connectivity.sqm.core.ui", iconPath);
    }

    @Override
    public void sampleDbContents() {
        this.model.sampleContents(this.column);
    }
}

