/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.db.core.ui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.db.core.exception.AndmoreDbException;
import org.eclipse.andmore.android.db.core.i18n.DbCoreNLS;
import org.eclipse.andmore.android.db.core.model.DbModel;
import org.eclipse.andmore.android.db.core.model.TableModel;
import org.eclipse.andmore.android.db.core.ui.AbstractDbResultManagerAdapter;
import org.eclipse.andmore.android.db.core.ui.AbstractTreeNode;
import org.eclipse.andmore.android.db.core.ui.IDbMapperNode;
import org.eclipse.andmore.android.db.core.ui.IDbNode;
import org.eclipse.andmore.android.db.core.ui.ITableNode;
import org.eclipse.andmore.android.db.core.ui.ITreeNode;
import org.eclipse.andmore.android.db.core.ui.TableNode;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.ConnectionProfileException;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.sqltools.result.ResultsViewAPI;
import org.eclipse.datatools.sqltools.result.core.IResultManagerListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class DbNode
extends AbstractTreeNode
implements IDbNode {
    public static final String PROP_NAMESPACE = "org.eclipse.andmore.android.db.core";
    public static final String PROP_VALUE_DB_DISCONNECTED = "org.eclipse.andmore.android.db.core.databaseDisconnected";
    public static final String PROP_VALUE_DB_CONNECTED = "org.eclipse.andmore.android.db.core.databaseConnected";
    public static final String PROP_NAME_DB_CONNECTION = "org.eclipse.andmore.android.db.core.databaseConnection";
    public static final String PROP_NAME_DB_NODE_TYPE = "org.eclipse.andmore.android.db.core.IDbNodeType";
    public static final String PROP_VALUE_DB_NODE_IS_EXT_STORAGE = "org.eclipse.andmore.android.db.core.isExternalStorage";
    public static final String ICON_PATH = "icons/obj16/dbplate.gif";
    protected DbModel model;
    private IResultManagerListener resultManagerListener;
    protected boolean forceCloseEditors;

    private DbNode() {
    }

    protected DbNode(ITreeNode parent) {
        super(parent);
    }

    public DbNode(IPath dbFilePath, ITreeNode parent) throws AndmoreDbException {
        this(parent);
        this.init(dbFilePath);
        this.model = new DbModel(dbFilePath);
    }

    public DbNode(IPath dbPath, ITreeNode parent, boolean create) throws AndmoreDbException {
        this(parent);
        this.init(dbPath);
        try {
            this.model = new DbModel(dbPath, create);
        }
        catch (AndmoreDbException e) {
            throw new AndmoreDbException("Could not create DBNode", (Throwable)((Object)e));
        }
    }

    @Override
    public IStatus connect() {
        IStatus status = this.model.connect();
        if (status.isOK() && this.resultManagerListener == null) {
            this.resultManagerListener = new ResultManagerAdapter();
            ResultsViewAPI.getInstance().getResultManager().addResultManagerListener(this.resultManagerListener);
        }
        this.setNodeStatus(status);
        return status;
    }

    @Override
    public IStatus disconnect() {
        IStatus status = this.closeAssociatedEditors();
        if (status.isOK()) {
            status = this.model.disconnect();
            if (status.isOK()) {
                if (this.resultManagerListener != null) {
                    ResultsViewAPI.getInstance().getResultManager().removeResultManagerListener(this.resultManagerListener);
                    this.resultManagerListener = null;
                }
                this.clear();
            }
            if (status.getSeverity() != 8) {
                this.setNodeStatus(status);
            }
        }
        if (status.getSeverity() != 8) {
            this.setNodeStatus(status);
        }
        return status;
    }

    @Override
    public IStatus createTables(List<TableModel> tables) {
        IStatus status = Status.OK_STATUS;
        ArrayList<ITreeNode> tableNodes = new ArrayList<ITreeNode>(tables.size());
        for (TableModel table : tables) {
            status = this.model.createTable(table);
            if (!status.isOK()) break;
            TableNode tableNode = new TableNode(this.getTable(table.getName()), this.model, this);
            tableNodes.add(tableNode);
        }
        if (status.isOK()) {
            this.putChildren(tableNodes);
        }
        return status;
    }

    @Override
    public IStatus createTable(TableModel table) {
        IStatus status = this.model.createTable(table);
        if (status.isOK()) {
            TableNode tableNode = new TableNode(this.getTable(table.getName()), this.model, this);
            this.putChild(tableNode);
        }
        return status;
    }

    @Override
    public IStatus deleteTable(ITableNode tableNode) {
        IStatus status = this.model.deleteTable(tableNode.getName());
        if (status.isOK()) {
            this.removeChild(tableNode);
        }
        return status;
    }

    @Override
    public List<Table> getTables() {
        return this.model.getTables();
    }

    @Override
    public void refresh() {
        if (!this.model.isConnected()) {
            this.connect();
        }
        this.clear();
        List<Table> tables = this.getTables();
        ArrayList<ITreeNode> tableNodes = new ArrayList<ITreeNode>(tables.size());
        for (Table table : tables) {
            TableNode tableNode = new TableNode(table, this.model, this);
            tableNodes.add(tableNode);
        }
        this.putChildren(tableNodes);
    }

    protected IStatus closeAssociatedEditors(final boolean quiet, final boolean forceClose) {
        Set<IEditorPart> associatedEditors = this.getAssociatedEditors();
        IStatus status = Status.OK_STATUS;
        if (!associatedEditors.isEmpty()) {
            final boolean[] success = new boolean[]{true};
            for (final IEditorPart editor : associatedEditors) {
                final IWorkbenchPage page = EclipseUtils.getPageForEditor((IEditorPart)editor);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!quiet) {
                            page.bringToTop((IWorkbenchPart)editor);
                            if (!forceClose) {
                                if (!page.closeEditor(editor, true)) {
                                    success[0] = false;
                                }
                            } else {
                                boolean shallSave;
                                if (editor.isDirty() && (shallSave = EclipseUtils.showQuestionDialog((String)DbCoreNLS.DbNode_Close_Editor_Msg_Title, (String)NLS.bind((String)DbCoreNLS.DbNode_Close_Editor_Msg, (Object)DbNode.this.getName())))) {
                                    editor.doSave((IProgressMonitor)new NullProgressMonitor());
                                }
                                page.closeEditor(editor, false);
                            }
                        } else {
                            page.closeEditor(editor, false);
                        }
                    }
                });
                if (!success[0]) break;
            }
            if (!success[0]) {
                status = new Status(8, PROP_NAMESPACE, DbCoreNLS.DbNode_Canceled_Save_Operation);
            }
        }
        return status;
    }

    protected IStatus closeAssociatedEditors() {
        return this.closeAssociatedEditors(false, this.forceCloseEditors);
    }

    @Override
    public Table getTable(String tableName) {
        return this.model.getTable(tableName);
    }

    private void init(IPath dbFilePath) {
        String dbFileName = dbFilePath.lastSegment();
        String id = String.valueOf(dbFilePath.toFile().getParent()) + "." + dbFileName;
        this.setId(id);
        this.setName(dbFileName);
        ImageDescriptor icon = AbstractUIPlugin.imageDescriptorFromPlugin((String)PROP_NAMESPACE, (String)ICON_PATH);
        this.setIcon(icon);
        this.setToolTip(dbFilePath);
    }

    private void setToolTip(IPath dbPath) {
        if (this.getParent() instanceof IDbMapperNode) {
            this.setTooltip(NLS.bind((String)DbCoreNLS.DbNode_Tooltip_Prefix, (Object)dbPath.toString()));
        }
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public IStatus deleteDb() {
        this.closeAssociatedEditors(true, this.forceCloseEditors);
        this.disconnect();
        return this.model.deleteDb();
    }

    @Override
    public boolean testAttribute(Object target, String name, String value) {
        boolean result = false;
        if (name.equals(PROP_NAME_DB_CONNECTION) || PROP_NAME_DB_CONNECTION.equals("org.eclipse.andmore.android.db.core." + name)) {
            if (value.equals(PROP_VALUE_DB_CONNECTED)) {
                result = this.isConnected();
            } else if (value.equals(PROP_VALUE_DB_DISCONNECTED)) {
                result = !this.isConnected();
            }
        } else if (name.equals(PROP_NAME_DB_NODE_TYPE)) {
            if (value.equals(PROP_VALUE_DB_NODE_IS_EXT_STORAGE)) {
                result = this.getParent() instanceof IDbMapperNode;
            }
        } else {
            result = super.testAttribute(target, name, value);
        }
        return result;
    }

    @Override
    public ImageDescriptor getIcon() {
        return this.getSpecificIcon("org.eclipse.datatools.connectivity.sqm.core.ui", "icons/database.gif");
    }

    @Override
    public boolean isConnected() {
        return this.model != null ? this.model.isConnected() : false;
    }

    @Override
    public void cleanUp() {
        this.setForceCloseEditors(true);
        this.disconnect();
        if (this.model != null) {
            try {
                this.model.cleanModel();
            }
            catch (ConnectionProfileException connectionProfileException) {
                AndmoreLogger.debug((Object)this, (String)"Unable to cleanup db model.");
            }
        }
        super.cleanUp();
    }

    public Set<IEditorPart> getAssociatedEditors() {
        return this.model != null ? this.model.getAssociatedEditors() : new HashSet(0);
    }

    public boolean existsDbFile() {
        return this.model != null ? this.model.getDbPath().toFile().exists() : false;
    }

    public IPath getPath() {
        return this.model != null ? this.model.getDbPath() : null;
    }

    protected void setForceCloseEditors(boolean forceCloseEditors) {
        this.forceCloseEditors = forceCloseEditors;
    }

    private class ResultManagerAdapter
    extends AbstractDbResultManagerAdapter {
        private ResultManagerAdapter() {
        }

        @Override
        public void statementExecuted(String profileName, String sqlStatement) {
            if (DbNode.this.model.getProfileName().equals(profileName) && !sqlStatement.equals("Group Execution") && sqlStatement.indexOf("select") != 0 && !sqlStatement.equals("")) {
                if (sqlStatement.startsWith("drop table") || sqlStatement.startsWith("create table")) {
                    DbNode.this.refreshAsync();
                } else if (sqlStatement.startsWith("alter table")) {
                    if (!sqlStatement.contains("rename")) {
                        String tableName = sqlStatement.replace("alter table ", "");
                        tableName.substring(0, tableName.indexOf(" "));
                        List<ITreeNode> children = DbNode.this.getChildren();
                        for (ITreeNode child : children) {
                            if (!child.getName().equalsIgnoreCase(tableName)) continue;
                            child.refreshAsync();
                            break;
                        }
                    } else {
                        DbNode.this.refreshAsync();
                    }
                }
            }
        }
    }
}

