/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.db.core.ui.action;

import org.eclipse.andmore.android.codeutils.wizards.DatabaseManagementClassesCreationWizard;
import org.eclipse.andmore.android.db.core.project.ProjectNode;
import org.eclipse.andmore.android.db.core.ui.IDbNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CreateDatabaseManagementClassesAction
extends Action {
    private IDbNode dbNodeSelected;
    private ProjectNode dbProjectNodeSelected;

    public void run() {
        IWorkbenchWindow window;
        IResource resource = null;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && !workbench.isClosing() && (window = workbench.getActiveWorkbenchWindow()) != null) {
            if (this.dbNodeSelected != null) {
                if (this.dbNodeSelected.getParent() instanceof ProjectNode) {
                    ProjectNode pNode = (ProjectNode)this.dbNodeSelected.getParent();
                    resource = ResourcesPlugin.getWorkspace().getRoot().getProject(pNode.getName()).getFile("assets/" + this.dbNodeSelected.getName());
                    if (!resource.exists()) {
                        resource = resource.getProject();
                    }
                }
            } else if (this.dbProjectNodeSelected != null) {
                ProjectNode pNode = this.dbProjectNodeSelected;
                resource = ResourcesPlugin.getWorkspace().getRoot().getProject(pNode.getName()).getFile("assets/" + this.dbProjectNodeSelected.getName());
                if (!resource.exists()) {
                    resource = resource.getProject();
                }
            } else {
                Object selectionElement = this.getSelectionElement(window);
                resource = selectionElement == null ? null : this.getResourceFromSelection(selectionElement);
            }
            this.openDialogBasedOnResourceSelected(resource, window);
        }
    }

    private void openDialogBasedOnResourceSelected(IResource resource, IWorkbenchWindow window) {
        WizardDialog dialog = null;
        dialog = resource != null ? (resource instanceof IFile ? new WizardDialog(window.getShell(), (IWizard)new DatabaseManagementClassesCreationWizard(resource.getProject(), resource)) : new WizardDialog(window.getShell(), (IWizard)new DatabaseManagementClassesCreationWizard(resource.getProject(), null))) : new WizardDialog(window.getShell(), (IWizard)new DatabaseManagementClassesCreationWizard(null, null));
        if (dialog != null) {
            dialog.open();
        }
    }

    private IResource getResourceFromSelection(Object selectionElement) {
        IResource resource = null;
        if (selectionElement instanceof IResource) {
            resource = (IResource)selectionElement;
        } else if (selectionElement instanceof IAdaptable) {
            try {
                resource = (IResource)((IAdaptable)selectionElement).getAdapter(IResource.class);
            }
            catch (Exception exception) {}
        }
        return resource;
    }

    private Object getSelectionElement(IWorkbenchWindow window) {
        ISelection selection = window.getSelectionService().getSelection();
        Object structureSelection = null;
        structureSelection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : new StructuredSelection();
        Object selectionElement = structureSelection.getFirstElement();
        return selectionElement;
    }

    public void setDbNodeSelected(IDbNode dbNodeSelected) {
        this.dbNodeSelected = dbNodeSelected;
    }

    protected IDbNode getDbNodeSelected() {
        return this.dbNodeSelected;
    }

    public void setProjectNodeSelected(ProjectNode selectedProjectNode) {
        this.dbProjectNodeSelected = selectedProjectNode;
    }
}

