/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.db.core.ui.view;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.db.core.DbCoreActivator;
import org.eclipse.andmore.android.db.core.DbRootNodeReader;
import org.eclipse.andmore.android.db.core.event.DatabaseModelEvent;
import org.eclipse.andmore.android.db.core.event.DatabaseModelEventManager;
import org.eclipse.andmore.android.db.core.event.IDatabaseModelListener;
import org.eclipse.andmore.android.db.core.ui.AbstractTreeNode;
import org.eclipse.andmore.android.db.core.ui.ITreeNode;
import org.eclipse.andmore.android.db.core.ui.RootNode;
import org.eclipse.andmore.android.db.core.ui.tree.DatabaseExplorerTreeContentProvider;
import org.eclipse.andmore.android.db.core.ui.tree.DatabaseExplorerTreeLabelProvider;
import org.eclipse.andmore.android.db.core.ui.view.SaveStateManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.IEvaluationService;

public class AndmoreDatabaseExplorerView
extends ViewPart
implements IDatabaseModelListener {
    public static final String VIEW_ID = "org.eclipse.andmore.android.db.databaseView";
    public static final String DB_EXPLORER_VIEW_HELP = "org.eclipse.andmore.android.db.core.dbexplorer";
    public static final String DB_EXPLORER_VIEW_CONTR_BROWSE_TABLE_ID = "org.eclipse.andmore.android.db.core.createTableCommand";
    private TreeViewer treeViewer;

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 2;
        parent.setLayout((Layout)layout);
        GridData layoutData = new GridData();
        layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        this.treeViewer = new TreeViewer(parent, 0x10000004);
        this.treeViewer.setContentProvider((IContentProvider)new DatabaseExplorerTreeContentProvider(this.treeViewer));
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setAutoExpandLevel(0);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new DatabaseExplorerTreeLabelProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer);
        this.treeViewer.setInput(this.getInitalInput());
        this.treeViewer.getControl().setLayoutData((Object)layoutData);
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TreeSelection treeSelection;
                Object element;
                ISelection selection = event.getSelection();
                if (selection instanceof TreeSelection && (element = (treeSelection = (TreeSelection)selection).getFirstElement()) instanceof AbstractTreeNode) {
                    if (!AndmoreDatabaseExplorerView.this.treeViewer.getExpandedState(element)) {
                        AndmoreDatabaseExplorerView.this.treeViewer.expandToLevel(element, 1);
                    } else {
                        AndmoreDatabaseExplorerView.this.treeViewer.collapseToLevel(element, 1);
                    }
                }
            }
        });
        this.hookContextMenu();
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        DatabaseModelEventManager.getInstance().addListener(this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, DB_EXPLORER_VIEW_HELP);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.treeViewer.getTree(), DB_EXPLORER_VIEW_HELP);
    }

    private Object getInitalInput() {
        HashMap<String, AbstractTreeNode> model = new HashMap<String, AbstractTreeNode>();
        RootNode rootNode = new RootNode();
        try {
            DbRootNodeReader.loadRootNode(model);
            Set<Map.Entry<String, AbstractTreeNode>> modelEntries = model.entrySet();
            ArrayList<ITreeNode> childrenList = new ArrayList<ITreeNode>(modelEntries.size());
            for (Map.Entry<String, AbstractTreeNode> childNode : modelEntries) {
                childrenList.add(childNode.getValue());
            }
            rootNode.putChildren(childrenList);
        }
        catch (PartInitException e) {
            AndmoreLogger.error(AndmoreDatabaseExplorerView.class, (String)"Problem creating Andmore Database Explorer Tree", (Throwable)e);
        }
        return rootNode;
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                AndmoreDatabaseExplorerView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.treeViewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
    }

    public void setFocus() {
        this.treeViewer.getTree().setFocus();
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public ITreeNode getSelectedItemOnTree() {
        ITreeNode result = null;
        ITreeSelection treeSelection = null;
        ISelection selection = this.treeViewer.getSelection();
        if (selection instanceof ITreeSelection) {
            treeSelection = (ITreeSelection)selection;
            result = (ITreeNode)treeSelection.getFirstElement();
        }
        return result;
    }

    public void collapseAllTreeItems() {
        this.treeViewer.collapseAll();
    }

    public void saveState(IMemento memento) {
        SaveStateManager.getInstance().saveState();
        super.saveState(memento);
    }

    @Override
    public void handleNodeAdditionEvent(final DatabaseModelEvent databaseModelEvent) {
        Display display = Display.getDefault();
        if (!display.isDisposed()) {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    ITreeNode treeNodeItem = databaseModelEvent.getTreeNodeItem();
                    ITreeNode parentNode = treeNodeItem.getParent();
                    if (AndmoreDatabaseExplorerView.this.getTreeViewer().getExpandedState((Object)parentNode)) {
                        AndmoreDatabaseExplorerView.this.getTreeViewer().add((Object)parentNode, (Object)treeNodeItem);
                    } else {
                        List<ITreeNode> children = parentNode.getChildren();
                        if (children.size() > 0) {
                            AndmoreDatabaseExplorerView.this.getTreeViewer().setChildCount((Object)parentNode, children.size());
                        }
                    }
                }
            });
        }
    }

    @Override
    public void handleNodeRemovalEvent(final DatabaseModelEvent databaseModelEvent) {
        Display display = Display.getDefault();
        if (!display.isDisposed()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!AndmoreDatabaseExplorerView.this.treeViewer.getTree().isDisposed()) {
                        AndmoreDatabaseExplorerView.this.getTreeViewer().remove((Object)databaseModelEvent.getTreeNodeItem());
                        ITreeNode parentNode = databaseModelEvent.getTreeNodeItem().getParent();
                        AndmoreDatabaseExplorerView.this.getTreeViewer().setChildCount((Object)parentNode, parentNode.getChildren().size());
                    }
                }
            });
        }
    }

    @Override
    public void handleNodeUpdateEvent(final DatabaseModelEvent databaseModelEvent) {
        Display display = Display.getDefault();
        if (!display.isDisposed()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    ITreeNode treeNode = databaseModelEvent.getTreeNodeItem();
                    AndmoreDatabaseExplorerView.this.getTreeViewer().update((Object)treeNode, null);
                    for (String property : DbCoreActivator.getPluginProperties()) {
                        IEvaluationService service = (IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class);
                        service.requestEvaluation(property);
                    }
                }
            });
        }
    }

    @Override
    public void handleNodeClearEvent(final DatabaseModelEvent databaseModelEvent) {
        Display display = Display.getDefault();
        if (!display.isDisposed()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    ITreeNode parentNode = databaseModelEvent.getTreeNodeItem();
                    if (parentNode.isLoading()) {
                        AndmoreDatabaseExplorerView.this.treeViewer.remove((Object)parentNode, parentNode.getChildren().toArray());
                        AndmoreDatabaseExplorerView.this.treeViewer.refresh((Object)parentNode);
                    } else {
                        AndmoreDatabaseExplorerView.this.treeViewer.collapseToLevel((Object)parentNode, -1);
                    }
                }
            });
        }
    }

    @Override
    public void handleNodeRefreshEvent(final DatabaseModelEvent databaseModelEvent) {
        Display display = Display.getDefault();
        if (!display.isDisposed()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    ITreeNode node = databaseModelEvent.getTreeNodeItem();
                    AndmoreDatabaseExplorerView.this.getTreeViewer().refresh((Object)node);
                }
            });
        }
    }

    public void dispose() {
        super.dispose();
        DatabaseModelEventManager.getInstance().removeListeners(this);
    }

    @Override
    public void handleNodeExpandEvent(final DatabaseModelEvent databaseModelEvent) {
        Display display = Display.getDefault();
        if (!display.isDisposed()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    AndmoreDatabaseExplorerView.this.treeViewer.expandToLevel((Object)databaseModelEvent.getTreeNodeItem(), 1);
                }
            });
        }
    }

    @Override
    public void handleNodeSelectEvent(final DatabaseModelEvent databaseModelEvent) {
        Display display = Display.getDefault();
        if (!display.isDisposed()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    AndmoreDatabaseExplorerView.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)databaseModelEvent.getTreeNodeItem()), true);
                }
            });
        }
    }
}

