/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.db.core.workspace;

import java.util.Collection;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.db.core.project.ProjectNode;
import org.eclipse.andmore.android.db.core.ui.AbstractTreeNode;
import org.eclipse.andmore.android.db.core.ui.IRootNode;
import org.eclipse.andmore.android.db.core.ui.ITreeNode;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;

public class WorkspaceRootNode
extends AbstractTreeNode
implements IRootNode,
IResourceChangeListener {
    public WorkspaceRootNode() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 7);
    }

    @Override
    public void refresh() {
        this.clear();
        this.loadContent();
    }

    @Override
    public ImageDescriptor getIcon() {
        return this.getSpecificIcon("org.eclipse.jdt.ui", "icons/full/elcl16/prj_mode.gif");
    }

    public Collection<ITreeNode> loadContent() {
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            this.addProject(project);
            ++n2;
        }
        return this.getChildren();
    }

    public void addProject(IProject project) {
        ProjectNode projectNode = null;
        try {
            if (project != null && project.isOpen() && project.getNature("org.eclipe.andmore.AndroidNature") != null) {
                projectNode = new ProjectNode(project, (ITreeNode)this);
                this.putChild(projectNode);
            }
        }
        catch (CoreException e) {
            AndmoreLogger.error(WorkspaceRootNode.class, (String)("Unable to retrieve nature from project:" + project.getName()), (Throwable)e);
        }
    }

    public void removeProject(IProject project) {
        ITreeNode projectNode = this.getChildById(project.getName());
        if (projectNode != null) {
            this.removeChild(projectNode);
        }
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResource res = event.getResource();
        IProject project = null;
        switch (event.getType()) {
            case 2: 
            case 4: {
                AndmoreLogger.info((String)("Project about to close/delete: " + res.getFullPath()));
                project = res.getProject();
                this.removeProject(project);
                break;
            }
            case 1: {
                try {
                    event.getDelta().accept((IResourceDeltaVisitor)new ResourceDeltaVisior());
                    break;
                }
                catch (CoreException e) {
                    AndmoreLogger.error(WorkspaceRootNode.class, (String)"Error listening to changes in resources", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    class ResourceDeltaVisior
    implements IResourceDeltaVisitor {
        ResourceDeltaVisior() {
        }

        public boolean visit(IResourceDelta delta) {
            IResource res = delta.getResource();
            if (res instanceof IProject) {
                IProject project = (IProject)res;
                switch (delta.getKind()) {
                    case 1: {
                        AndmoreLogger.info((String)("Project added: " + res.getFullPath()));
                        WorkspaceRootNode.this.addProject(project);
                        break;
                    }
                    case 4: {
                        int flags = delta.getFlags();
                        if ((flags & 0x4000) == 0) break;
                        AndmoreLogger.info((String)("Project opened: " + res.getFullPath()));
                        WorkspaceRootNode.this.addProject(project);
                    }
                }
            }
            return true;
        }
    }
}

