/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.db.devices.model;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.andmore.android.DDMSFacade;
import org.eclipse.andmore.android.DDMSUtils;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.common.utilities.FileUtil;
import org.eclipse.andmore.android.db.core.CanRefreshStatus;
import org.eclipse.andmore.android.db.core.exception.AndmoreDbException;
import org.eclipse.andmore.android.db.core.model.DbModel;
import org.eclipse.andmore.android.db.core.model.TableModel;
import org.eclipse.andmore.android.db.core.ui.AbstractDbResultManagerAdapter;
import org.eclipse.andmore.android.db.core.ui.DbNode;
import org.eclipse.andmore.android.db.core.ui.IDbNode;
import org.eclipse.andmore.android.db.core.ui.ITableNode;
import org.eclipse.andmore.android.db.core.ui.ITreeNode;
import org.eclipse.andmore.android.db.devices.DbDevicesPlugin;
import org.eclipse.andmore.android.db.devices.i18n.DbDevicesNLS;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.sqltools.result.ResultsViewAPI;
import org.eclipse.datatools.sqltools.result.core.IResultManagerListener;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class DeviceDbNode
extends DbNode
implements IDbNode {
    private static final int REMOTE_OPERATIONS_TIMEOUT = 2000;
    private final IPath remoteDbPath;
    private final String serialNumber;
    private IResultManagerListener resultManagerListener;
    private String localFileMd5;
    public boolean isDirty;

    public DeviceDbNode(IPath remoteDbPath, String serialNumber, ITreeNode parent) {
        super(parent);
        this.setId(String.valueOf(serialNumber) + "." + remoteDbPath.toString());
        this.remoteDbPath = remoteDbPath;
        this.serialNumber = serialNumber;
        this.setName(remoteDbPath.lastSegment());
        ImageDescriptor icon = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.andmore.android.db.core", (String)"icons/obj16/dbplate.gif");
        this.setIcon(icon);
        this.setTooltip(NLS.bind((String)DbDevicesNLS.DeviceDbNode_Tootip_Prefix, (Object)remoteDbPath.toString()));
    }

    public DeviceDbNode(IPath remoteDbPath, String serialNumber, ITreeNode parent, boolean create) throws AndmoreDbException {
        block5: {
            this(remoteDbPath, serialNumber, parent);
            if (create) {
                try {
                    File tempFile = this.getLocalTempFile();
                    Path localDbPath = null;
                    if (tempFile != null) {
                        localDbPath = new Path(tempFile.getAbsolutePath());
                        this.model = new DbModel((IPath)localDbPath, create, true);
                        IStatus status = this.pushLocalDbFile(false);
                        if (!status.isOK()) {
                            this.deleteLocalDbModel();
                            throw new AndmoreDbException(DbDevicesNLS.DeviceDbNode_Create_Device_Db_Failed);
                        }
                        break block5;
                    }
                    throw new AndmoreDbException(DbDevicesNLS.DeviceDbNode_Could_Not_Create_DeviceDbNode);
                }
                catch (IOException e) {
                    throw new AndmoreDbException(DbDevicesNLS.DeviceDbNode_Could_Not_Create_DeviceDbNode, (Throwable)e);
                }
            }
        }
    }

    private File getLocalTempFile() throws IOException {
        String tempLocation;
        IPreferenceStore preferenceStore = DbDevicesPlugin.getDefault().getPreferenceStore();
        File tempLocationFile = null;
        if (!(preferenceStore.isDefault("org.eclipse.andmore.android.db.devices.dbstudiotemppath") || (tempLocationFile = new File(tempLocation = preferenceStore.getString("org.eclipse.andmore.android.db.devices.dbstudiotemppath"))).isDirectory() && FileUtil.canWrite((File)tempLocationFile))) {
            EclipseUtils.showErrorDialog((String)DbDevicesNLS.ERR_DbUtils_Local_Db_Title, (String)NLS.bind((String)DbDevicesNLS.ERR_DbUtils_Local_Db_Msg, (Object)tempLocation));
            preferenceStore.setToDefault("org.eclipse.andmore.android.db.devices.dbstudiotemppath");
        }
        File tempFile = File.createTempFile(String.valueOf(this.serialNumber) + "_" + this.remoteDbPath.segment(1) + "_" + this.getName(), "db", tempLocationFile);
        tempFile.deleteOnExit();
        return tempFile;
    }

    public IStatus connect() {
        IStatus status = null;
        File tempFile = null;
        try {
            tempFile = this.getLocalTempFile();
            status = this.pullRemoteTempFile(tempFile);
        }
        catch (IOException e) {
            status = new Status(4, "org.eclipse.andmore.android.db.devices", DbDevicesNLS.DeviceDbNode_Create_Temp_Local_Db_Failed, (Throwable)e);
        }
        if (this.model != null && status.isOK()) {
            try {
                String newMd5Sum = FileUtil.calculateMd5Sum((File)tempFile);
                if (!newMd5Sum.equals(this.localFileMd5)) {
                    this.deleteLocalDbModel();
                }
            }
            catch (IOException e) {
                status = new Status(4, "org.eclipse.andmore.android.db.devices", DbDevicesNLS.DeviceDbNode_Calculate_Local_Md5_Failed, (Throwable)e);
            }
        }
        if (this.model == null && status.isOK()) {
            try {
                this.model = new DbModel(Path.fromOSString((String)tempFile.getAbsolutePath()));
            }
            catch (AndmoreDbException e) {
                status = new Status(4, "org.eclipse.andmore.android.db.devices", e.getMessage());
            }
        }
        if (this.model != null && status.isOK()) {
            try {
                this.localFileMd5 = this.getLocalMd5Sum();
                this.model.connect();
            }
            catch (IOException e) {
                status = new Status(4, "org.eclipse.andmore.android.db.devices", DbDevicesNLS.DeviceDbNode_Calculate_Local_Md5_Failed, (Throwable)e);
            }
        }
        if (status.isOK()) {
            if (this.resultManagerListener == null) {
                this.resultManagerListener = new ResultManagerListener();
                ResultsViewAPI.getInstance().getResultManager().addResultManagerListener(this.resultManagerListener);
            }
            this.isDirty = false;
        }
        this.setNodeStatus(status);
        return status != null ? status : Status.OK_STATUS;
    }

    private String getLocalMd5Sum() throws IOException {
        return FileUtil.calculateMd5Sum((File)this.model.getDbPath().toFile());
    }

    public IStatus disconnect() {
        IStatus status = Status.OK_STATUS;
        if (this.model != null && this.model.isConnected()) {
            boolean canDisconnect = true;
            status = this.closeAssociatedEditors();
            canDisconnect = status.isOK();
            if (canDisconnect) {
                status = this.model.disconnect();
                if (status.isOK()) {
                    this.deleteLocalDbModel();
                    if (this.resultManagerListener != null) {
                        ResultsViewAPI.getInstance().getResultManager().removeResultManagerListener(this.resultManagerListener);
                        this.resultManagerListener = null;
                    }
                }
                this.clear();
                this.setNodeStatus(status);
            }
        }
        return status;
    }

    public IStatus createTables(List<TableModel> tables) {
        IStatus status = this.checkMd5Sum(true);
        if (status.isOK() && (status = super.createTables(tables)).isOK()) {
            this.pushLocalDbFile();
        }
        return status;
    }

    public IStatus createTable(TableModel table) {
        IStatus status = this.checkMd5Sum(true);
        if (status.isOK() && (status = super.createTable(table)).isOK()) {
            this.pushLocalDbFile();
        }
        return status;
    }

    public IStatus deleteTable(ITableNode tableNode) {
        IStatus status = this.checkMd5Sum(true);
        if (status.isOK() && (status = super.deleteTable(tableNode)).isOK()) {
            this.pushLocalDbFile();
        }
        return status;
    }

    public IStatus deleteDb() {
        Status status = null;
        try {
            this.closeAssociatedEditors(true, this.forceCloseEditors);
            DDMSFacade.deleteFile((String)this.serialNumber, (String)this.remoteDbPath.toString());
            this.disconnect();
        }
        catch (IOException iOException) {
            status = new Status(4, "org.eclipse.andmore.android.db.devices", NLS.bind((String)DbDevicesNLS.DeviceDbNode_Delete_Remote_File_Failed, (Object)this.remoteDbPath.toString(), (Object)DDMSFacade.getNameBySerialNumber((String)this.serialNumber)));
        }
        return status != null ? status : Status.OK_STATUS;
    }

    public IStatus canRefresh() {
        IStatus status = null;
        if (this.isDirty) {
            status = this.checkMd5Sum(false);
            if (!status.isOK()) {
                status = new CanRefreshStatus(48, "org.eclipse.andmore.android.db.devices", NLS.bind((String)DbDevicesNLS.DeviceDbNode_DBOutOfSync_Refresh_Message, (Object)this.getName()));
            }
        } else {
            Set associatedEditors = this.getAssociatedEditors();
            if (!associatedEditors.isEmpty()) {
                status = new CanRefreshStatus(16, "org.eclipse.andmore.android.db.devices", NLS.bind((String)DbDevicesNLS.DeviceDbNode_RefreshQuestion, (Object)this.getName()));
            }
        }
        return status != null ? status : Status.OK_STATUS;
    }

    public void refresh() {
        IStatus checkMd5Sum;
        if (this.model != null && this.model.isConnected() && !(checkMd5Sum = this.checkMd5Sum(false)).isOK()) {
            this.model.disconnect();
            this.deleteLocalDbModel();
            this.clear();
        }
        IStatus status = Status.OK_STATUS;
        if (this.model == null || !this.model.isConnected()) {
            status = this.connect();
        }
        if (status.isOK()) {
            super.refresh();
        }
    }

    private boolean deleteLocalDbModel() {
        IStatus deleteDb = this.model.deleteDb();
        this.model = null;
        return deleteDb.isOK();
    }

    private IStatus pullRemoteTempFile(File tempFile) {
        Status status;
        block14: {
            status = null;
            IOConsoleOutputStream stream = null;
            try {
                try {
                    Path localDbPath = new Path(tempFile.getAbsolutePath());
                    List<File> localList = Arrays.asList(localDbPath.toFile());
                    List<String> remoteList = Arrays.asList(this.remoteDbPath.toString());
                    stream = EclipseUtils.getStudioConsoleOutputStream((boolean)false);
                    status = DDMSFacade.pullFiles((String)this.serialNumber, localList, remoteList, (int)2000, (IProgressMonitor)new NullProgressMonitor(), (OutputStream)stream);
                }
                catch (Exception e) {
                    status = new Status(4, "org.eclipse.andmore.android.db.devices", DbDevicesNLS.DeviceDbNode_Create_Temp_Local_Db_Failed, (Throwable)e);
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException e2) {
                            AndmoreLogger.error((String)"Could not close stream: ", (String)e2.getMessage());
                        }
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        AndmoreLogger.error((String)"Could not close stream: ", (String)e.getMessage());
                    }
                }
                throw throwable;
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    AndmoreLogger.error((String)"Could not close stream: ", (String)e.getMessage());
                }
            }
        }
        return status != null ? status : Status.OK_STATUS;
    }

    public void refresh(boolean canRefreshYesResponse) {
        if (canRefreshYesResponse) {
            this.closeAssociatedEditors(false, true);
        } else {
            this.pushLocalDbFile(false);
        }
        this.refresh();
    }

    private IStatus pushLocalDbFile() {
        return this.pushLocalDbFile(true);
    }

    private IStatus pushLocalDbFile(boolean warnUser) {
        Status status;
        block16: {
            status = null;
            IOConsoleOutputStream stream = null;
            try {
                try {
                    boolean applicationRunning;
                    IPath localDbPath = this.model.getDbPath();
                    File localDbFile = localDbPath.toFile();
                    List<File> localList = Arrays.asList(localDbFile);
                    List<String> remoteList = Arrays.asList(this.remoteDbPath.toString());
                    stream = EclipseUtils.getStudioConsoleOutputStream((boolean)false);
                    status = DDMSFacade.pushFiles((String)this.serialNumber, localList, remoteList, (int)2000, (IProgressMonitor)new NullProgressMonitor(), (OutputStream)stream);
                    if (status.isOK()) {
                        this.isDirty = false;
                    }
                    this.localFileMd5 = FileUtil.calculateMd5Sum((File)localDbFile);
                    String appName = this.getParent().getName();
                    if (warnUser && (applicationRunning = DDMSFacade.isApplicationRunning((String)this.serialNumber, (String)appName))) {
                        EclipseUtils.showInformationDialog((String)DbDevicesNLS.DeviceDbNode_Application_Running_Msg_Title, (String)NLS.bind((String)DbDevicesNLS.DeviceDbNode_Application_Running_Msg_Text, (Object)appName));
                    }
                }
                catch (Exception e) {
                    status = new Status(4, "org.eclipse.andmore.android.db.devices", NLS.bind((String)DbDevicesNLS.DeviceDbNode_Push_Local_File_To_Device_Failed, (Object)this.serialNumber), (Throwable)e);
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException e2) {
                            AndmoreLogger.error((String)"Could not close stream: ", (String)e2.getMessage());
                        }
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        AndmoreLogger.error((String)"Could not close stream: ", (String)e.getMessage());
                    }
                }
                throw throwable;
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    AndmoreLogger.error((String)"Could not close stream: ", (String)e.getMessage());
                }
            }
        }
        return status != null ? status : Status.OK_STATUS;
    }

    private IStatus checkMd5Sum(boolean warnUser) {
        IStatus status;
        block13: {
            File tempFile = null;
            status = null;
            if (this.localFileMd5 != null) {
                try {
                    try {
                        tempFile = this.getLocalTempFile();
                        status = this.pullRemoteTempFile(tempFile);
                        String newMd5Sum = FileUtil.calculateMd5Sum((File)tempFile);
                        if (!this.localFileMd5.equals(newMd5Sum)) {
                            if (warnUser) {
                                boolean canOverwrite = EclipseUtils.showQuestionDialog((String)DbDevicesNLS.DeviceDbNode_Remote_File_Modified_Title, (String)NLS.bind((String)DbDevicesNLS.DeviceDbNode_Remote_File_Modified_Msg, (Object)this.getName()));
                                if (!canOverwrite) {
                                    status = new Status(8, "org.eclipse.andmore.android.db.devices", DbDevicesNLS.DeviceDbNode_User_Canceled_Overwrite);
                                }
                            } else {
                                status = new Status(4, "org.eclipse.andmore.android.db.devices", DbDevicesNLS.DeviceDbNode_Md5Sum_Differs);
                            }
                        }
                    }
                    catch (IOException e) {
                        status = new Status(4, "org.eclipse.andmore.android.db.devices", DbDevicesNLS.DeviceDbNode_Create_Temp_Local_Db_Failed, (Throwable)e);
                        if (tempFile != null) {
                            tempFile.delete();
                        }
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    if (tempFile != null) {
                        tempFile.delete();
                    }
                    throw throwable;
                }
                if (tempFile != null) {
                    tempFile.delete();
                }
            }
        }
        return status != null ? status : Status.OK_STATUS;
    }

    public boolean remoteFileExists() {
        boolean remoteFileExists = false;
        try {
            remoteFileExists = DDMSUtils.remoteFileExists((String)this.serialNumber, (String)this.remoteDbPath.toString());
        }
        catch (IOException iOException) {}
        return remoteFileExists;
    }

    public IPath getRemoteDbPath() {
        return this.remoteDbPath;
    }

    public void cleanUp() {
        if (DDMSFacade.isDeviceOnline((String)this.serialNumber)) {
            super.cleanUp();
        } else {
            this.closeAssociatedEditors(true, this.forceCloseEditors);
            this.clear();
        }
    }

    private class ResultManagerListener
    extends AbstractDbResultManagerAdapter {
        private ResultManagerListener() {
        }

        public void statementExecuted(String profilename, String sqlStatement) {
            if (DeviceDbNode.this.model != null && DeviceDbNode.this.model.getProfileName().equals(profilename) && !sqlStatement.equals("Group Execution") && sqlStatement.trim().toLowerCase().indexOf("select") != 0 && !sqlStatement.trim().equals("")) {
                IStatus status = DeviceDbNode.this.checkMd5Sum(true);
                if (status.isOK()) {
                    status = DeviceDbNode.this.pushLocalDbFile();
                }
                if (!status.isOK()) {
                    DeviceDbNode.this.isDirty = true;
                }
            }
        }
    }
}

