/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.db.devices.ui.preferences;

import java.io.File;
import org.eclipse.andmore.android.db.devices.DbDevicesPlugin;
import org.eclipse.andmore.android.db.devices.i18n.DbDevicesNLS;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class DbPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String LEGACY_PLUGIN_ID = "org.eclipse.andmore.android.db";
    public static final String LEGACY_DB_PATH_PREFERENCE = "org.eclipse.andmore.android.db.dbstudiopath";
    private DirectoryFieldEditor directoryEditor;
    private static final String PREFERENCE_PAGE_HELP = "org.eclipse.andmore.android.db.devices.preference-database";

    public DbPreferencePage() {
        this.setPreferenceStore(DbDevicesPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite main = new Composite(parent, 4);
        main.setLayoutData((Object)new GridData(1808));
        main.setLayout((Layout)new GridLayout(1, false));
        this.directoryEditor = new DirectoryFieldEditor("org.eclipse.andmore.android.db.devices.dbstudiotemppath", DbDevicesNLS.UI_PreferencePage_PathLabel, main);
        this.directoryEditor.getTextControl(main).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DbPreferencePage.this.validateDirectory();
            }
        });
        this.directoryEditor.setStringValue(this.getPreferenceStore().getString("org.eclipse.andmore.android.db.devices.dbstudiotemppath"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)main, PREFERENCE_PAGE_HELP);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, PREFERENCE_PAGE_HELP);
        return main;
    }

    public boolean validateDirectory() {
        boolean valid = false;
        if (this.directoryEditor.getStringValue().trim().length() == 0) {
            valid = true;
        } else {
            try {
                File f = new File(this.directoryEditor.getStringValue());
                if (f.isDirectory()) {
                    File f2 = new File(String.valueOf(this.directoryEditor.getStringValue()) + '/' + "test");
                    f2.createNewFile();
                    f2.delete();
                    valid = true;
                }
            }
            catch (Exception exception) {
                valid = false;
            }
        }
        if (!valid) {
            this.setErrorMessage(DbDevicesNLS.ERR_DbPrefPage_InvalidDir);
            this.setValid(false);
            return false;
        }
        this.setErrorMessage(null);
        this.setValid(true);
        return true;
    }

    protected void performDefaults() {
        this.getPreferenceStore().setToDefault("org.eclipse.andmore.android.db.devices.dbstudiotemppath");
        this.directoryEditor.setStringValue(this.getPreferenceStore().getString("org.eclipse.andmore.android.db.devices.dbstudiotemppath"));
    }

    public boolean performOk() {
        boolean canReturn = true;
        if (this.directoryEditor.getStringValue().trim().length() == 0) {
            this.performDefaults();
        } else if (!this.validateDirectory()) {
            canReturn = false;
        } else {
            this.getPreferenceStore().setValue("org.eclipse.andmore.android.db.devices.dbstudiotemppath", this.directoryEditor.getStringValue());
            canReturn = super.performOk();
        }
        return canReturn;
    }

    public void init(IWorkbench workbench) {
    }

    public static void restoreBackWardPref(IPreferenceStore currentPrefStore) {
        ScopedPreferenceStore preferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, LEGACY_PLUGIN_ID);
        String backwardDbTempPath = preferenceStore.getString(LEGACY_DB_PATH_PREFERENCE);
        if (!backwardDbTempPath.isEmpty()) {
            currentPrefStore.setValue("org.eclipse.andmore.android.db.devices.dbstudiotemppath", backwardDbTempPath);
            preferenceStore.setValue(LEGACY_DB_PATH_PREFERENCE, "");
        }
    }
}

