/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.devices.services.lang.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.devices.services.DeviceServicesPlugin;
import org.eclipse.core.runtime.FileLocator;

public class Language {
    private static final String FILE_PATH = "resources/ISO-639-2_utf-8.txt";
    private static List<Language> languageList = null;
    private static Map<String, Language> languageMap = null;
    private String name;
    private String id;

    public static List<Language> getLanguageList() {
        if (languageList == null) {
            Language.loadLanguages();
        }
        return languageList;
    }

    private static void loadLanguages() {
        block15: {
            languageList = new ArrayList<Language>();
            languageMap = new HashMap<String, Language>();
            URL languagesURL = DeviceServicesPlugin.getDefault().getBundle().getResource(FILE_PATH);
            BufferedReader input = null;
            try {
                try {
                    File file = new File(FileLocator.toFileURL((URL)languagesURL).getPath());
                    input = new BufferedReader(new FileReader(file));
                    String line = null;
                    String[] lineParts = null;
                    String name = null;
                    String ID = null;
                    while ((line = input.readLine()) != null) {
                        lineParts = line.split("\\|");
                        ID = lineParts[2];
                        name = lineParts[3];
                        if (ID == null || ID.equals("") || name == null || name.equals("")) continue;
                        Language language = new Language(name, ID);
                        languageList.add(language);
                        languageMap.put(name, language);
                    }
                }
                catch (Exception exception) {
                    AndmoreLogger.error((String)"Change Language TmL Service: could not load languages list");
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String getIdFromName(String langName) {
        String id = null;
        Language language = languageMap.get(langName);
        if (language != null) {
            id = language.getId();
        }
        return id;
    }

    public Language(String name, String id) {
        this.name = name;
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

