/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.handset;

import java.util.Collection;
import java.util.Properties;
import org.eclipse.andmore.android.AndmoreEventManager;
import org.eclipse.andmore.android.AndroidPlugin;
import org.eclipse.andmore.android.DDMSFacade;
import org.eclipse.andmore.android.DdmsRunnable;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.devices.DevicesManager;
import org.eclipse.andmore.android.handset.HandsetInstanceBuilder;
import org.eclipse.sequoyah.device.common.utilities.exception.SequoyahException;
import org.eclipse.sequoyah.device.framework.model.IInstanceBuilder;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class HandsetPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.andmore.android.handset";
    public static final String HANDSET_DEVICE_TYPE_ID = "org.eclipse.andmore.android.handset.androidHandset";
    public static final String STATUS_ONLINE_ID = "org.eclipse.andmore.android.handset.status.handsetonline";
    public static final String SERVICE_INIT_ID = "org.eclipse.andmore.android.handset.initHandsetService";
    private static final Runnable sdkLoaderListener = new Runnable(){

        @Override
        public void run() {
            Collection serialNumbers = DDMSFacade.getConnectedSerialNumbers();
            for (String serial : serialNumbers) {
                HandsetPlugin.createInstance(serial);
            }
        }
    };
    private static HandsetPlugin plugin;
    private static DdmsRunnable connectedListener;
    private static DdmsRunnable disconnectedListener;

    static {
        connectedListener = new DdmsRunnable(){

            public void run(String serialNumber) {
                HandsetPlugin.createInstance(serialNumber);
            }
        };
        disconnectedListener = new DdmsRunnable(){

            public void run(String serialNumber) {
                HandsetPlugin.deleteInstance(serialNumber);
            }
        };
    }

    public void start(BundleContext context) throws Exception {
        AndmoreLogger.debug(HandsetPlugin.class, (String)"Starting Andmore Handset Plugin...");
        super.start(context);
        plugin = this;
        AndmoreEventManager.asyncAddDeviceChangeListeners((DdmsRunnable)connectedListener, (DdmsRunnable)disconnectedListener);
        AndroidPlugin.getDefault().addSDKLoaderListener(sdkLoaderListener);
        AndmoreLogger.debug(HandsetPlugin.class, (String)"Andmore Handset Plugin started.");
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        AndroidPlugin.getDefault().removeSDKLoaderListener(sdkLoaderListener);
        AndmoreEventManager.asyncRemoveDeviceChangeListeners((DdmsRunnable)connectedListener, (DdmsRunnable)disconnectedListener);
        super.stop(context);
    }

    public static HandsetPlugin getDefault() {
        return plugin;
    }

    private static void createInstance(String serialNumber) {
        if (!DDMSFacade.isEmulator((String)serialNumber) && !DDMSFacade.isRemote((String)serialNumber)) {
            try {
                Properties instanceProperties = DDMSFacade.getDeviceProperties((String)serialNumber);
                HandsetInstanceBuilder projectBuilder = new HandsetInstanceBuilder(serialNumber, instanceProperties);
                DevicesManager.getInstance().createInstanceForDevice(serialNumber, HANDSET_DEVICE_TYPE_ID, (IInstanceBuilder)projectBuilder, SERVICE_INIT_ID);
            }
            catch (SequoyahException e) {
                AndmoreLogger.error(HandsetPlugin.class, (String)("Failed to create a TmL instance for device " + serialNumber), (Throwable)e);
            }
        }
    }

    private static void deleteInstance(String serialNumber) {
        if (!DDMSFacade.isEmulator((String)serialNumber) && !DDMSFacade.isRemote((String)serialNumber)) {
            DevicesManager.getInstance().deleteInstanceOfDevice(serialNumber);
        }
    }
}

