/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.logger.collector.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.andmore.android.logger.collector.core.ILogFile;
import org.eclipse.andmore.android.logger.collector.core.internal.CollectLogFile;
import org.eclipse.andmore.android.logger.collector.util.LoggerCollectorMessages;
import org.eclipse.andmore.android.logger.collector.util.PlatformException;
import org.eclipse.andmore.android.logger.collector.util.WidgetsUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class LogFileColumn
extends Composite {
    private Table tableLogFile = null;
    CollectLogFile collectLogFile = new CollectLogFile();

    public LogFileColumn(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout gridLayoutTableView = new GridLayout();
        gridLayoutTableView.horizontalSpacing = 0;
        gridLayoutTableView.marginWidth = 0;
        gridLayoutTableView.marginHeight = 0;
        gridLayoutTableView.verticalSpacing = 0;
        GridData gridDatagridLayout = new GridData(1168);
        this.setBackgroundMode(0);
        this.setBackground(Display.getCurrent().getSystemColor(1));
        this.setLayoutData(gridDatagridLayout);
        this.setLayout((Layout)gridLayoutTableView);
        GridData gridData = new GridData(1810);
        gridData.widthHint = 230;
        gridData.heightHint = 300;
        this.setLayoutData(gridData);
        this.refresh();
    }

    public void refresh() {
        GridData gridDataTableView = new GridData(1810);
        gridDataTableView.widthHint = 236;
        gridDataTableView.heightHint = 300;
        if (this.tableLogFile == null) {
            this.tableLogFile = new Table((Composite)this, 2080);
            this.tableLogFile.setLayoutData((Object)gridDataTableView);
        }
        this.tableLogFile.removeAll();
        try {
            for (ILogFile log : this.collectLogFile.getLogFileList()) {
                TableItem tableItem = new TableItem(this.tableLogFile, 0);
                tableItem.setText(log.getLogName());
                tableItem.setData((Object)log);
            }
        }
        catch (Exception exception) {
            MessageDialog.openError((Shell)this.getShell(), (String)LoggerCollectorMessages.getInstance().getString("logger.collector.wizard.page.title"), (String)LoggerCollectorMessages.getInstance().getString("error.logger.collector.mount.tableview"));
        }
        this.packTableColumns();
        this.checkAll(true);
    }

    private void packTableColumns() {
        TableColumn[] columns = this.tableLogFile.getColumns();
        int i = 0;
        int n = columns.length;
        while (i < n) {
            columns[i].pack();
            ++i;
        }
    }

    public boolean collect(String filename) throws PlatformException {
        return new CollectLogFile().zipLogFiles(filename, WidgetsUtil.getCheckedLeafItems(this.tableLogFile));
    }

    public boolean hasNodeSelected() {
        return WidgetsUtil.getCheckedLeafItems(this.tableLogFile).size() > 0;
    }

    public ArrayList<String> selectedLogFilesExist() {
        List<TableItem> list = WidgetsUtil.getCheckedLeafItems(this.tableLogFile);
        ArrayList<String> notFoundItems = new ArrayList<String>();
        for (TableItem tableItem : list) {
            Object data = tableItem.getData();
            if (!(data instanceof ILogFile)) continue;
            ILogFile logFile = (ILogFile)data;
            for (IPath path : logFile.getLogFilePath()) {
                if (WidgetsUtil.fileExist(path.toOSString())) continue;
                notFoundItems.add(logFile.getLogName());
            }
        }
        return notFoundItems;
    }

    public void addTableListener(int eventType, Listener listener) {
        this.tableLogFile.addListener(eventType, listener);
    }

    public void checkAll(boolean selectionValue) {
        TableItem[] tableItemArray = this.tableLogFile.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            item.setChecked(selectionValue);
            ++n2;
        }
    }
}

