/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.logger.collector.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.andmore.android.logger.Logger;

public class PlatformLogger {
    private final Logger logger;
    private static Map<Class<? extends Object>, PlatformLogger> instances = new HashMap<Class<? extends Object>, PlatformLogger>();

    private PlatformLogger(Class<? extends Object> clazz) {
        this.logger = Logger.getLogger((String)clazz.getName());
    }

    public static synchronized PlatformLogger getInstance(Class<? extends Object> clazz) {
        PlatformLogger instance = instances.get(clazz);
        if (instance == null) {
            instance = new PlatformLogger(clazz);
            instances.put(clazz, instance);
        }
        return instance;
    }

    public void debug(String message) {
        this.debug(message, null);
    }

    public void debug(String message, Throwable exception) {
        if (exception == null) {
            this.logger.debug(message);
        } else {
            this.logger.debug(message, exception);
        }
    }

    public void warn(String message) {
        this.warn(message, null);
    }

    public void warn(String message, Throwable exception) {
        if (exception == null) {
            this.logger.warn(message);
        } else {
            this.logger.warn(message, exception);
        }
    }

    public void fatal(String message) {
        this.fatal(message, null);
    }

    public void fatal(String message, Throwable exception) {
        if (exception == null) {
            this.logger.fatal(message);
        } else {
            this.logger.fatal(message, exception);
        }
    }

    public void info(String message) {
        this.info(message, null);
    }

    public void info(String message, Throwable exception) {
        if (exception == null) {
            this.logger.info(message);
        } else {
            this.logger.info(message, exception);
        }
    }

    public void error(String message) {
        this.logger.error(message);
    }

    public void error(String message, Throwable exception) {
        this.logger.error(message, exception);
    }
}

