/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android;

import com.android.ddmlib.AndroidDebugBridge;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.andmore.android.DdmsRunnable;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;

public class AndmoreEventManager {
    private static final HashMap<EventType, List<DdmsRunnable>> listeners = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addEventListener(EventType type, DdmsRunnable listener) {
        HashMap<EventType, List<DdmsRunnable>> hashMap = listeners;
        synchronized (hashMap) {
            List<DdmsRunnable> typeListeners = listeners.get((Object)type);
            if (typeListeners == null) {
                typeListeners = new LinkedList<DdmsRunnable>();
                listeners.put(type, typeListeners);
            }
            typeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeEventListener(EventType type, DdmsRunnable listener) {
        HashMap<EventType, List<DdmsRunnable>> hashMap = listeners;
        synchronized (hashMap) {
            List<DdmsRunnable> typeListeners = listeners.get((Object)type);
            if (typeListeners == null) {
                typeListeners = new LinkedList<DdmsRunnable>();
                listeners.put(type, typeListeners);
            }
            typeListeners.remove(listener);
        }
    }

    public static void asyncAddClientChangeListener(final AndroidDebugBridge.IClientChangeListener listener) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)listener);
            }
        }).start();
    }

    public static void asyncRemoveClientChangeListener(final AndroidDebugBridge.IClientChangeListener listener) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                AndroidDebugBridge.removeClientChangeListener((AndroidDebugBridge.IClientChangeListener)listener);
            }
        }).start();
    }

    public static void asyncAddDebugBridgeChangeListener(final AndroidDebugBridge.IDebugBridgeChangeListener listener) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                AndroidDebugBridge.addDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)listener);
            }
        }).start();
    }

    public static void asyncRemoveDebugBridgeChangeListener(final AndroidDebugBridge.IDebugBridgeChangeListener listener) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                AndroidDebugBridge.removeDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)listener);
            }
        }).start();
    }

    public static void asyncAddDeviceChangeListeners(final DdmsRunnable connectedListener, final DdmsRunnable disconnectedListener) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (connectedListener != null) {
                    AndmoreEventManager.addEventListener(EventType.DEVICE_CONNECTED, connectedListener);
                }
                if (disconnectedListener != null) {
                    AndmoreEventManager.addEventListener(EventType.DEVICE_DISCONNECTED, disconnectedListener);
                }
            }
        }).start();
    }

    public static void asyncRemoveDeviceChangeListeners(final DdmsRunnable connectedListener, final DdmsRunnable disconnectedListener) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (connectedListener != null) {
                    AndmoreEventManager.removeEventListener(EventType.DEVICE_CONNECTED, connectedListener);
                }
                if (disconnectedListener != null) {
                    AndmoreEventManager.removeEventListener(EventType.DEVICE_DISCONNECTED, disconnectedListener);
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fireEvent(EventType type, final String serialNumber) {
        HashMap<EventType, List<DdmsRunnable>> hashMap = listeners;
        synchronized (hashMap) {
            if (listeners.get((Object)type) != null) {
                for (final DdmsRunnable runnable : listeners.get((Object)type)) {
                    SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                        public void run() throws Exception {
                            runnable.run(serialNumber);
                        }
                    });
                }
            }
        }
    }

    public static enum EventType {
        DEVICE_CONNECTED,
        DEVICE_DISCONNECTED,
        PACKAGE_INSTALLED,
        PACKAGE_UNINSTALLED,
        LANGUAGE_CHANGED;

    }
}

