/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.EmulatorConsole;
import com.android.ddmlib.FileListingService;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.SyncService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.android.AndmoreEventManager;
import org.eclipse.andmore.android.AndmoreHProfDumpHandler;
import org.eclipse.andmore.android.AndroidPlugin;
import org.eclipse.andmore.android.ISerialNumbered;
import org.eclipse.andmore.android.SdkUtils;
import org.eclipse.andmore.android.common.exception.AndroidException;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.i18n.AndroidNLS;
import org.eclipse.andmore.android.utilities.TelnetFrameworkAndroid;
import org.eclipse.andmore.ddms.DdmsPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DDMSFacade {
    private static final String USB_SWITCH_BACK_COMMAND = "usb";
    private static final String DEVICE_ID_INDICATOR = "-s";
    private static final String DEFAULT_WIRELESS_DEVICE_PROPERTY = "tiwlan0";
    private static final Map<String, IDevice> connectedDevices = new HashMap<String, IDevice>();
    private static final Set<String> completelyUpDevices = new HashSet<String>();
    static final String TOOLS_FOLDER = "tools";
    static final String PLATFORM_TOOLS_FOLDER = "platform-tools";
    static final String ADB_COMMAND = "adb";
    static final String SHELL_CMD = "shell";
    private static final String AM_CMD = "am";
    private static final String START_CMD = "start";
    private static final String ADB_AM_DEBUG = "-D";
    private static final String ADB_AM_NAME = "-n";
    static final String ADB_INSTANCE_PARAMETER = "-s";
    private static final String SDCARD_FOLDER = "sdcard";
    private static final String MNT_SDCARD_FOLDER = "mnt/sdcard";
    private static final String CONNECT_TCPIP_CMD = "connect";
    private static final String DISCONNECT_TCPIP_CMD = "disconnect";
    private static final String TCPIP_CMD = "tcpip";
    private static final String IFCONFIG_CMD = "ifconfig";
    static Object consoleLock = new Object();
    private static Map<String, String> avdNameMap = new HashMap<String, String>();
    private static final String WIFI_INTERFACE_DEVICE_PROPERTY = "wifi.interface";
    private static final String ZERO_TO_255_PATTERN = "((\\d)|(\\d\\d)|([0-1]\\d\\d)|(2[0-4]\\d)|(25[0-5]))";
    private static final String IP_PATTERN = "(((\\d)|(\\d\\d)|([0-1]\\d\\d)|(2[0-4]\\d)|(25[0-5]))\\.((\\d)|(\\d\\d)|([0-1]\\d\\d)|(2[0-4]\\d)|(25[0-5]))\\.((\\d)|(\\d\\d)|([0-1]\\d\\d)|(2[0-4]\\d)|(25[0-5]))\\.((\\d)|(\\d\\d)|([0-1]\\d\\d)|(2[0-4]\\d)|(25[0-5])))+";

    public static void setup() {
        AndroidPlugin.getDefault().addSDKLoaderListener(new Runnable(){

            @Override
            public void run() {
                AndroidDebugBridge adb = AndroidDebugBridge.getBridge();
                if (adb == null) {
                    AndroidDebugBridge.disconnectBridge();
                    DdmsPlugin.setToolsLocation((String)AndmoreAndroidPlugin.getOsAbsoluteAdb(), (boolean)true, (String)AndmoreAndroidPlugin.getOsAbsoluteHprofConv(), (String)AndmoreAndroidPlugin.getOsAbsoluteTraceview());
                }
                if (adb != null) {
                    IDevice[] x;
                    IDevice[] newDevices = x = adb.getDevices();
                    ArrayList oldDevList = new ArrayList(connectedDevices.values());
                    IDevice[] iDeviceArray = newDevices;
                    int n = newDevices.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IDevice newDev = iDeviceArray[n2];
                        String serialNum = newDev.getSerialNumber();
                        if (connectedDevices.containsKey(serialNum)) {
                            IDevice oldDev = (IDevice)connectedDevices.get(serialNum);
                            oldDevList.remove(oldDev);
                            if (oldDev.getState().compareTo((Enum)newDev.getState()) != 0) {
                                if (newDev.getState() == IDevice.DeviceState.OFFLINE) {
                                    DDMSFacade.deviceDisconnected(newDev);
                                } else if (newDev.getState() == IDevice.DeviceState.ONLINE) {
                                    DDMSFacade.deviceConnected(newDev);
                                }
                            }
                        } else {
                            DDMSFacade.deviceConnected(newDev);
                        }
                        ++n2;
                    }
                    for (IDevice oldDev : oldDevList) {
                        DDMSFacade.deviceDisconnected(oldDev);
                    }
                }
            }
        });
        AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)new AndroidDebugBridge.IClientChangeListener(){

            public void clientChanged(Client client, int changeMask) {
                if ((changeMask & 1) == 1) {
                    final Client finalClient = client;
                    Thread t = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            IPreferenceStore store;
                            String home;
                            String applicationName = finalClient.getClientData().getClientDescription();
                            if (applicationName != null && (home = (store = AndmoreAndroidPlugin.getDefault().getPreferenceStore()).getString("org.eclipse.andmore.homePackage")).equals(applicationName)) {
                                String serialNum = finalClient.getDevice().getSerialNumber();
                                Set set = completelyUpDevices;
                                synchronized (set) {
                                    AndmoreLogger.debug((String)("Completely Up Device: " + serialNum));
                                    completelyUpDevices.add(serialNum);
                                }
                            }
                        }
                    };
                    t.start();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deviceStatusChanged(IDevice device) {
        IPreferenceStore store;
        String home;
        AndmoreLogger.debug((String)("Device changed: " + device.getSerialNumber()));
        Map<String, IDevice> map = connectedDevices;
        synchronized (map) {
            connectedDevices.put(device.getSerialNumber(), device);
        }
        if (device.getState() == IDevice.DeviceState.ONLINE && device.getClient(home = (store = AndmoreAndroidPlugin.getDefault().getPreferenceStore()).getString("org.eclipse.andmore.homePackage")) != null) {
            Set<String> set = completelyUpDevices;
            synchronized (set) {
                AndmoreLogger.debug((String)("Completely Up Device: " + device.getSerialNumber()));
                if (!completelyUpDevices.contains(device.getSerialNumber())) {
                    completelyUpDevices.add(device.getSerialNumber());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deviceConnected(IDevice device) {
        IPreferenceStore store;
        String home;
        String serialNumber = device.getSerialNumber();
        AndmoreLogger.debug((String)("Device connected: " + serialNumber));
        Map<String, IDevice> map = connectedDevices;
        synchronized (map) {
            connectedDevices.put(serialNumber, device);
        }
        if (!device.isEmulator() && !device.hasClients()) {
            boolean timeout = false;
            long startTime = System.currentTimeMillis();
            int maxInterval = 10000;
            do {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {}
                long currentTime = System.currentTimeMillis();
                boolean bl = timeout = startTime + (long)maxInterval < currentTime;
            } while (!device.hasClients() && !timeout);
            if (timeout) {
                Set<String> set = completelyUpDevices;
                synchronized (set) {
                    completelyUpDevices.add(serialNumber);
                }
            }
        }
        if (device.hasClients() && device.getClient(home = (store = AndmoreAndroidPlugin.getDefault().getPreferenceStore()).getString("org.eclipse.andmore.homePackage")) != null) {
            AndmoreLogger.debug((String)("Completely Up Device: " + serialNumber));
            Set<String> set = completelyUpDevices;
            synchronized (set) {
                completelyUpDevices.add(serialNumber);
            }
        }
        AndmoreEventManager.fireEvent(AndmoreEventManager.EventType.DEVICE_CONNECTED, serialNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deviceDisconnected(IDevice device) {
        String serialNumber = device.getSerialNumber();
        AndmoreLogger.debug((String)("Device disconnected: " + serialNumber));
        Object object = completelyUpDevices;
        synchronized (object) {
            completelyUpDevices.remove(serialNumber);
        }
        object = connectedDevices;
        synchronized (object) {
            connectedDevices.remove(serialNumber);
        }
        AndmoreEventManager.fireEvent(AndmoreEventManager.EventType.DEVICE_DISCONNECTED, serialNumber);
        avdNameMap.remove(device.getSerialNumber());
    }

    public static Collection<String> getConnectedSerialNumbers() {
        return connectedDevices.keySet();
    }

    public static IDevice getDeviceBySerialNumber(String serialNumber) {
        return connectedDevices.get(serialNumber);
    }

    public static IStatus runActivity(String serialNumber, String activityName, boolean debugMode, OutputStream processOut) {
        IStatus status = Status.OK_STATUS;
        if (serialNumber == null) {
            AndmoreLogger.error((String)"Abort run operation. Serial number is null.");
            return new Status(4, "org.eclipse.andmore.android", AndroidNLS.ERR_DDMSFacade_SerialNumberNullPointer);
        }
        if (!DDMSFacade.isDeviceOnline(serialNumber)) {
            AndmoreLogger.error((String)"Abort run operation. Device is not online.");
            return new Status(4, "org.eclipse.andmore.android", "");
        }
        try {
            String[] cmd = DDMSFacade.createRunCommand(serialNumber, activityName, debugMode);
            DDMSFacade.executeCommand(cmd, processOut);
        }
        catch (IOException e) {
            AndmoreLogger.error((String)"Deploy: Could not execute adb install command.");
            status = new Status(4, "org.eclipse.andmore.android", e.getMessage());
        }
        return status;
    }

    static String executeCommand(String[] cmd, OutputStream out) throws IOException {
        return DDMSFacade.executeCommand(cmd, out, null);
    }

    static String executeCommand(String[] cmd, OutputStream out, String serialNumber) throws IOException {
        String fullCmd = "";
        if (out != null) {
            String[] stringArray = cmd;
            int n = cmd.length;
            int n2 = 0;
            while (n2 < n) {
                String cmdArg = stringArray[n2];
                fullCmd = String.valueOf(fullCmd) + cmdArg + " ";
                ++n2;
            }
            out.write(fullCmd.getBytes());
            out.write("\n".getBytes());
        }
        Runtime r = Runtime.getRuntime();
        Process p = r.exec(cmd);
        String command_results = "";
        InputStream processIn = p.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(processIn));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                command_results = String.valueOf(command_results) + line;
                command_results = String.valueOf(command_results) + "\n";
                if (out == null) continue;
                if (serialNumber != null) {
                    out.write((String.valueOf(serialNumber) + ": ").getBytes());
                }
                out.write(line.getBytes());
                out.write("\n".getBytes());
            }
        }
        finally {
            br.close();
        }
        return command_results;
    }

    private static IStatus executeRemoteDevicesCommand(String[] cmd, OutputStream out, int timeout, String timeoutMsg, IStopCondition stopCondition, IProgressMonitor monitor) throws IOException {
        IStatus status = Status.OK_STATUS;
        long timeoutLimit = -1L;
        if (timeout != 0) {
            timeoutLimit = System.currentTimeMillis() + (long)(timeout * 1000);
        }
        String fullCmd = "";
        String[] stringArray = cmd;
        int n = cmd.length;
        int n2 = 0;
        while (n2 < n) {
            String cmdArg = stringArray[n2];
            fullCmd = String.valueOf(fullCmd) + cmdArg + " ";
            ++n2;
        }
        if (out != null) {
            out.write(fullCmd.getBytes());
            out.write("\n".getBytes());
        }
        Runtime r = Runtime.getRuntime();
        Process p = r.exec(cmd);
        int errorCode = 0;
        String[] commandResults = new String[]{"", ""};
        commandResults = DDMSFacade.readCmdOutputFromStreams(commandResults[0], commandResults[1], p.getInputStream(), p.getErrorStream(), out);
        while (!stopCondition.canStop()) {
            if (monitor != null && monitor.isCanceled()) {
                p.destroy();
                return Status.CANCEL_STATUS;
            }
            try {
                errorCode = p.exitValue();
                if (errorCode != 0) {
                    break;
                }
            }
            catch (IllegalThreadStateException illegalThreadStateException) {}
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                AndmoreLogger.error((String)"Execute command: thread has been interrupted");
            }
            if (timeout <= 0) continue;
            try {
                DDMSFacade.testTimeout(timeoutLimit, timeoutMsg != null ? timeoutMsg : AndroidNLS.ERR_GenericTimeout);
            }
            catch (TimeoutException e) {
                p.destroy();
                AndmoreLogger.debug((String)("The timeout " + timeout + " has been reached when executing the command " + fullCmd));
                return new Status(4, "org.eclipse.andmore.android", e.getMessage(), (Throwable)e);
            }
        }
        commandResults = DDMSFacade.readCmdOutputFromStreams(commandResults[0], commandResults[1], p.getInputStream(), p.getErrorStream(), out);
        if (errorCode != 0) {
            AndmoreLogger.debug((String)("Command " + cmd + " returned an error code: " + errorCode));
            status = new Status(4, "org.eclipse.andmore.android", String.valueOf(NLS.bind((String)AndroidNLS.ERR_CommandError, (Object)errorCode)) + "\n" + (!commandResults[1].equals("") ? commandResults[1] : commandResults[0]));
        } else {
            status = new Status(0, "org.eclipse.andmore.android", commandResults[0]);
        }
        return status;
    }

    private static String[] readCmdOutputFromStreams(String commandResults, String errorResults, InputStream inputStream, InputStream errorStream, OutputStream out) {
        String[] results;
        block15: {
            results = new String[2];
            String line = "";
            BufferedReader brInput = new BufferedReader(new InputStreamReader(inputStream));
            BufferedReader brError = new BufferedReader(new InputStreamReader(errorStream));
            try {
                try {
                    if (brInput.ready()) {
                        while ((line = brInput.readLine()) != null) {
                            commandResults = String.valueOf(commandResults) + line;
                            commandResults = String.valueOf(commandResults) + "\n";
                            if (out == null) continue;
                            out.write(line.getBytes());
                            out.write("\n".getBytes());
                        }
                    }
                    if (brError.ready()) {
                        while ((line = brError.readLine()) != null) {
                            errorResults = String.valueOf(errorResults) + "\n";
                            if (out == null) continue;
                            out.write(line.getBytes());
                            out.write("\n".getBytes());
                        }
                    }
                }
                catch (IOException iOException) {
                    AndmoreLogger.error((String)"Cannot read command outputs");
                    try {
                        brInput.close();
                        brError.close();
                    }
                    catch (IOException e) {
                        AndmoreLogger.error((String)("Could not close console stream: " + e.getMessage()));
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                try {
                    brInput.close();
                    brError.close();
                }
                catch (IOException e) {
                    AndmoreLogger.error((String)("Could not close console stream: " + e.getMessage()));
                }
                throw throwable;
            }
            try {
                brInput.close();
                brError.close();
            }
            catch (IOException e) {
                AndmoreLogger.error((String)("Could not close console stream: " + e.getMessage()));
            }
        }
        results[0] = commandResults;
        results[1] = errorResults;
        return results;
    }

    private static void testTimeout(long timeoutLimit, String timeoutErrorMessage) throws TimeoutException {
        if (System.currentTimeMillis() > timeoutLimit) {
            throw new TimeoutException(timeoutErrorMessage);
        }
    }

    private static String[] createRunCommand(String serialNumber, String activityName, boolean debugMode) {
        String[] cmd;
        String sdkPath = SdkUtils.getSdkPath();
        File f = new File(String.valueOf(sdkPath) + PLATFORM_TOOLS_FOLDER + File.separator);
        if (!f.exists()) {
            AndmoreLogger.error((String)("Run: Could not find tools folder on " + sdkPath + PLATFORM_TOOLS_FOLDER + File.separator));
        } else if (!f.isDirectory()) {
            AndmoreLogger.error((String)("Run: Invalid tools folder " + sdkPath + PLATFORM_TOOLS_FOLDER + File.separator));
        }
        String completeAppPath = String.valueOf(activityName.substring(0, activityName.lastIndexOf("."))) + "/" + activityName;
        if (debugMode) {
            String[] cmdTemp = new String[]{String.valueOf(sdkPath) + PLATFORM_TOOLS_FOLDER + File.separator + ADB_COMMAND, "-s", serialNumber, SHELL_CMD, AM_CMD, START_CMD, ADB_AM_DEBUG, ADB_AM_NAME, completeAppPath};
            cmd = cmdTemp;
        } else {
            String[] cmdTemp;
            cmd = cmdTemp = new String[]{String.valueOf(sdkPath) + PLATFORM_TOOLS_FOLDER + File.separator + ADB_COMMAND, "-s", serialNumber, SHELL_CMD, AM_CMD, START_CMD, ADB_AM_NAME, completeAppPath};
        }
        return cmd;
    }

    public static boolean isDeviceOnline(String serialNumber) {
        IDevice device = DDMSFacade.getDeviceBySerialNumber(serialNumber);
        return device != null && device.isOnline();
    }

    public static boolean isDeviceOffline(String serialNumber) {
        IDevice device = DDMSFacade.getDeviceBySerialNumber(serialNumber);
        return device == null || device != null && device.isOffline();
    }

    public static boolean isDeviceCompletelyLoaded(String serialNumber) {
        return completelyUpDevices.contains(serialNumber);
    }

    public static boolean isEmulator(String serialNumber) {
        IDevice device = DDMSFacade.getDeviceBySerialNumber(serialNumber);
        return device != null && device.isEmulator();
    }

    public static boolean isRemote(String serialNumber) {
        IDevice device;
        Pattern p = Pattern.compile("(.)+:(\\d)+");
        Matcher m = p.matcher(serialNumber);
        return m.matches() && (device = DDMSFacade.getDeviceBySerialNumber(serialNumber)) != null && !device.isEmulator();
    }

    public static Collection<String> execRemoteApp(String serialNumber, String remoteCommand, IProgressMonitor monitor) throws IOException {
        return DDMSFacade.executeShellCmd(serialNumber, remoteCommand, monitor);
    }

    public static Map<String, Collection<String>> execRemoteApp(String serialNumber, Collection<String> remoteCommands, IProgressMonitor monitor) throws IOException {
        LinkedHashMap<String, Collection<String>> cmdAnswers = new LinkedHashMap<String, Collection<String>>();
        for (String remoteCommand : remoteCommands) {
            AndmoreLogger.debug((String)remoteCommand);
            Collection<String> answers = DDMSFacade.executeShellCmd(serialNumber, remoteCommand, monitor);
            cmdAnswers.put(remoteCommand, answers);
        }
        return cmdAnswers;
    }

    private static Collection<String> executeShellCmd(String serialNumber, final String cmd, final IProgressMonitor monitor) {
        final ArrayList<String> results = new ArrayList<String>();
        IDevice d = DDMSFacade.getDeviceBySerialNumber(serialNumber);
        if (d != null) {
            try {
                d.executeShellCommand(cmd, (IShellOutputReceiver)new MultiLineReceiver(){

                    public boolean isCancelled() {
                        return monitor.isCanceled();
                    }

                    public void processNewLines(String[] lines) {
                        String[] stringArray = lines;
                        int n = lines.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String line = stringArray[n2];
                            if (!line.equals("") && !line.equals(cmd)) {
                                results.add(line);
                            }
                            ++n2;
                        }
                    }
                }, 0);
            }
            catch (Exception e) {
                AndmoreLogger.error(DDMSFacade.class, (String)("Error executing shell command " + cmd + " at device " + serialNumber), (Throwable)e);
            }
        }
        return results;
    }

    public static Properties getDeviceProperties(String serialNumber) {
        Properties instanceProperties = new Properties();
        if (serialNumber != null) {
            String key = "";
            String value = "";
            try {
                Collection<String> lines = DDMSFacade.execRemoteApp(serialNumber, "getprop", (IProgressMonitor)new NullProgressMonitor());
                for (String line : lines) {
                    String[] split = line.split("]:");
                    if (split.length < 2 || split[0].equals("")) continue;
                    key = split[0].substring(1, split[0].length());
                    if (split[1].equals("")) continue;
                    value = split[1].substring(2, split[1].length() - 1);
                    instanceProperties.setProperty(key, value);
                }
            }
            catch (IOException e) {
                AndmoreLogger.error((String)("IOException while executing an app on device. " + e.getMessage()));
            }
        }
        return instanceProperties;
    }

    public static String getDeviceProperty(String serialNumber, String propertyName) {
        String result = null;
        IDevice device = DDMSFacade.getDeviceBySerialNumber(serialNumber);
        if (device != null) {
            result = device.getProperty(propertyName);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getVmName(IDevice d) {
        Map<String, String> map;
        String vmName = null;
        String serialNumber = d.getSerialNumber();
        int MAX_TRIES = 120;
        int tries = 0;
        while (vmName == null && tries < MAX_TRIES) {
            block16: {
                map = avdNameMap;
                synchronized (map) {
                    vmName = avdNameMap.get(serialNumber);
                }
                if (vmName == null) {
                    vmName = d.getAvdName();
                }
                if (vmName == null) {
                    try {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            ++tries;
                            break block16;
                        }
                    }
                    catch (Throwable throwable) {
                        ++tries;
                        throw throwable;
                    }
                    ++tries;
                }
            }
            if (vmName != null) continue;
            vmName = DDMSFacade.getVmNameByTelnet(serialNumber);
        }
        if (vmName != null) {
            map = avdNameMap;
            synchronized (map) {
                if (avdNameMap.get(serialNumber) == null) {
                    avdNameMap.put(serialNumber, vmName);
                }
            }
        }
        return vmName;
    }

    private static String getVmNameByTelnet(String serialNumber) {
        String avdName;
        block16: {
            Pattern pattern = Pattern.compile("emulator-([0-9]+)");
            TelnetFrameworkAndroid telnet = new TelnetFrameworkAndroid();
            Matcher matcher = pattern.matcher(serialNumber);
            matcher.matches();
            avdName = null;
            try {
                Integer telnetPort = Integer.valueOf(matcher.group(1));
                telnet.connect("localhost", telnetPort);
                String avdNameRaw = telnet.write("avd name\r\n", new String[]{"KO"});
                String split = avdNameRaw.contains("\r\n") ? "\r\n" : "\n";
                String[] outputArray = avdNameRaw.split(split);
                if (outputArray.length > 2) {
                    avdName = outputArray[2];
                }
                if (avdName != null) {
                    avdNameMap.put(serialNumber, avdName);
                }
            }
            catch (NumberFormatException numberFormatException) {
                avdName = serialNumber;
                try {
                    telnet.disconnect();
                }
                catch (IOException iOException) {}
                break block16;
            }
            catch (IOException iOException) {
                try {
                    avdName = serialNumber;
                }
                catch (Throwable throwable) {
                    try {
                        telnet.disconnect();
                    }
                    catch (IOException iOException2) {}
                    throw throwable;
                }
                try {
                    telnet.disconnect();
                }
                catch (IOException iOException3) {}
                break block16;
            }
            try {
                telnet.disconnect();
            }
            catch (IOException iOException) {}
        }
        return avdName;
    }

    public static IDevice getDeviceWithVmName(String vmName) {
        IDevice toReturn = null;
        if (vmName != null) {
            Collection<IDevice> devices = connectedDevices.values();
            for (IDevice d : devices) {
                String deviceVmName;
                if (!d.isEmulator() || !vmName.equals(deviceVmName = DDMSFacade.getVmName(d))) continue;
                toReturn = d;
                break;
            }
        }
        return toReturn;
    }

    public static String getNameBySerialNumber(String serialNumber) {
        String avdName = null;
        IDevice d = DDMSFacade.getDeviceBySerialNumber(serialNumber);
        avdName = DDMSFacade.getNameByDevice(d);
        return avdName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSerialNumberByName(String instanceName) {
        String serialNumber = null;
        if (instanceName != null) {
            ArrayList<IDevice> devices = null;
            Map<String, IDevice> map = connectedDevices;
            synchronized (map) {
                devices = new ArrayList<IDevice>(connectedDevices.size());
                devices.addAll(connectedDevices.values());
            }
            if (devices != null) {
                for (IDevice dev : devices) {
                    if (!instanceName.equals(DDMSFacade.getNameByDevice(dev))) continue;
                    serialNumber = dev.getSerialNumber();
                    break;
                }
            }
        }
        return serialNumber;
    }

    public static Collection<String> getRunningApplications(String serialNumber) {
        Client[] clients;
        IDevice dev;
        ArrayList<String> apps = new ArrayList<String>();
        if (serialNumber != null && (dev = DDMSFacade.getDeviceBySerialNumber(serialNumber)) != null && (clients = dev.getClients()) != null && clients.length > 0) {
            Client[] clientArray = clients;
            int n = clients.length;
            int n2 = 0;
            while (n2 < n) {
                Client c = clientArray[n2];
                apps.add(c.getClientData().getClientDescription());
                ++n2;
            }
        }
        return apps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static IStatus dumpHprofFile(String clientDescription, String serialNumber, IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        monitor.beginTask(AndroidNLS.DumpHprofFile_GeneratingMemoryAnalysisOutput, 100);
        monitor.setTaskName(AndroidNLS.DumpHprofFile_GettingRunningApplications);
        IDevice dev = DDMSFacade.getDeviceBySerialNumber(serialNumber);
        Client[] clients = dev.getClients();
        monitor.worked(25);
        final Shell[] shell = new Shell[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                shell[0] = new Shell(PlatformUI.getWorkbench().getDisplay());
            }
        });
        AndmoreHProfDumpHandler hprofHandler = new AndmoreHProfDumpHandler(shell[0], monitor);
        monitor.setTaskName(AndroidNLS.DumpHprofFile_SettingApplicationToAnalyse);
        hprofHandler.setSelectedApp(clientDescription);
        monitor.worked(25);
        try {
            try {
                Client[] clientArray = clients;
                int n = clients.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        return status;
                    }
                    Client c = clientArray[n2];
                    if (c.getClientData().getClientDescription().equals(clientDescription)) {
                        ClientData.setHprofDumpHandler((ClientData.IHprofDumpHandler)hprofHandler);
                        monitor.setTaskName(AndroidNLS.DumpHprofFile_DumpingHprofFile);
                        c.dumpHprof();
                        Class<DDMSFacade> clazz = DDMSFacade.class;
                        // MONITORENTER : org.eclipse.andmore.android.DDMSFacade.class
                        DDMSFacade.class.wait();
                        // MONITOREXIT : clazz
                        monitor.worked(50);
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                status = Status.CANCEL_STATUS;
                monitor.done();
                return status;
            }
        }
        finally {
            monitor.done();
        }
    }

    private static String getNameByDevice(IDevice d) {
        String name = null;
        if (d != null) {
            name = d.isEmulator() ? DDMSFacade.getVmName(d) : d.getSerialNumber();
        }
        return name;
    }

    public static boolean createForward(String serialNumber, int from, int to) {
        boolean ok = true;
        IDevice device = DDMSFacade.getDeviceBySerialNumber(serialNumber);
        try {
            device.createForward(from, to);
        }
        catch (Exception e) {
            AndmoreLogger.error(DDMSFacade.class, (String)("Error creating forward of device: " + serialNumber + " from " + from + " to " + to), (Throwable)e);
            ok = false;
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void kill(String serialNumber) {
        IDevice deviceToKill;
        if (DDMSFacade.isDeviceOnline(serialNumber) && (deviceToKill = DDMSFacade.getDeviceBySerialNumber(serialNumber)) != null) {
            Object object = consoleLock;
            synchronized (object) {
                EmulatorConsole console = EmulatorConsole.getConsole((IDevice)deviceToKill);
                if (console != null) {
                    console.kill();
                }
            }
        }
    }

    public static IStatus pushFiles(String serialNumber, String localDir, Collection<String> fileNames, String remoteDir, int timeout, IProgressMonitor monitor, OutputStream outputStream) {
        return DDMSFacade.transferFiles(true, serialNumber, localDir, fileNames, remoteDir, timeout, monitor, outputStream);
    }

    public static IStatus pushFiles(String serialNumber, List<File> localFiles, List<String> remoteFiles, int timeout, IProgressMonitor monitor, OutputStream outputStream) {
        return DDMSFacade.transferFiles(true, serialNumber, localFiles, remoteFiles, timeout, monitor, outputStream);
    }

    public static IStatus pullFiles(String serialNumber, String localDir, Collection<String> fileNames, String remoteDir, int timeout, IProgressMonitor monitor, OutputStream outputStream) {
        return DDMSFacade.transferFiles(false, serialNumber, localDir, fileNames, remoteDir, timeout, monitor, outputStream);
    }

    public static IStatus pullFiles(String serialNumber, List<File> localFiles, List<String> remoteFiles, int timeout, IProgressMonitor monitor, OutputStream outputStream) {
        return DDMSFacade.transferFiles(false, serialNumber, localFiles, remoteFiles, timeout, monitor, outputStream);
    }

    private static SyncService getSyncService(IDevice device, int timeout, IProgressMonitor monitor) throws AndroidException {
        SyncService service = null;
        long timeoutLimit = System.currentTimeMillis() + (long)timeout;
        do {
            if (device != null && device.isOnline()) {
                try {
                    service = device.getSyncService();
                }
                catch (IOException e) {
                    AndmoreLogger.debug((String)("Couldn't get sync service; cause: " + e.getMessage()));
                }
                catch (com.android.ddmlib.TimeoutException e) {
                    AndmoreLogger.debug((String)("Couldn't get sync service; cause: " + e.getMessage()));
                }
                catch (AdbCommandRejectedException e) {
                    AndmoreLogger.debug((String)("Couldn't get sync service; cause: " + e.getMessage()));
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
            if (monitor.isCanceled()) {
                AndmoreLogger.info((String)"Operation canceled by the user");
                return null;
            }
            if (System.currentTimeMillis() <= timeoutLimit) continue;
            AndmoreLogger.error((String)"The emulator was not up within the set timeout");
            throw new AndroidException("Timeout while preparing to transfer files to the Device. " + device);
        } while (service == null);
        return service;
    }

    private static IStatus transferFiles(boolean isPush, String serialNumber, String localDir, Collection<String> fileNames, String remoteDir, int timeout, IProgressMonitor monitor, OutputStream outputStream) {
        ArrayList<File> localList = new ArrayList<File>();
        ArrayList<String> remoteList = new ArrayList<String>();
        for (String name : fileNames) {
            localList.add(new File(localDir, name));
            remoteList.add(String.valueOf(remoteDir) + "/" + name);
        }
        return DDMSFacade.transferFiles(isPush, serialNumber, localList, remoteList, timeout, monitor, outputStream);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static IStatus transferFiles(boolean isPush, String serialNumber, List<File> localFiles, List<String> remoteFiles, int timeout, final IProgressMonitor monitor, OutputStream outputStream) {
        if (localFiles.size() != remoteFiles.size()) {
            return new Status(4, "org.eclipse.andmore.android", AndroidNLS.ERR_DDMSFacade_IncompatibleFileLists);
        }
        IStatus status = Status.OK_STATUS;
        IDevice device = DDMSFacade.getDeviceBySerialNumber(serialNumber);
        SyncService service = null;
        try {
            try {
                service = DDMSFacade.getSyncService(device, timeout, monitor);
                if (service == null) {
                    status = Status.CANCEL_STATUS;
                    return status;
                }
                SyncService.ISyncProgressMonitor syncMonitor = new SyncService.ISyncProgressMonitor(){

                    public void start(int i) {
                    }

                    public void stop() {
                    }

                    public void advance(int i) {
                    }

                    public boolean isCanceled() {
                        return monitor.isCanceled();
                    }

                    public void startSubTask(String s) {
                    }
                };
                FileListingService flService = device.getFileListingService();
                int i = 0;
                while (i < localFiles.size()) {
                    File localFile = localFiles.get(i);
                    String remotePath = remoteFiles.get(i);
                    String absLocalFile = localFile.getAbsolutePath();
                    String resultMessage = null;
                    if (isPush) {
                        AndmoreLogger.debug((String)("Push " + absLocalFile + " to " + remotePath));
                        try {
                            service.pushFile(absLocalFile, remotePath, syncMonitor);
                        }
                        catch (SyncException e1) {
                            AndmoreLogger.debug((String)("Push result: SyncException occured " + e1.getMessage()));
                            resultMessage = String.valueOf(NLS.bind((String)AndroidNLS.CON_ConsolePush, (Object)absLocalFile, (Object)remotePath)) + ": " + e1.getLocalizedMessage();
                        }
                        catch (FileNotFoundException e1) {
                            AndmoreLogger.debug((String)("Push result: FileNotFoundException occured " + e1.getMessage()));
                            resultMessage = String.valueOf(NLS.bind((String)AndroidNLS.CON_ConsolePush, (Object)absLocalFile, (Object)remotePath)) + ": " + e1.getLocalizedMessage();
                        }
                        catch (IOException e1) {
                            AndmoreLogger.debug((String)("Push result: IOException occured " + e1.getMessage()));
                            resultMessage = String.valueOf(NLS.bind((String)AndroidNLS.CON_ConsolePush, (Object)absLocalFile, (Object)remotePath)) + ": " + e1.getLocalizedMessage();
                        }
                        catch (com.android.ddmlib.TimeoutException e1) {
                            AndmoreLogger.debug((String)("Push result: TimeoutException occured " + e1.getMessage()));
                            resultMessage = String.valueOf(NLS.bind((String)AndroidNLS.CON_ConsolePush, (Object)absLocalFile, (Object)remotePath)) + ": " + e1.getLocalizedMessage();
                        }
                        if (outputStream != null && resultMessage != null) {
                            try {
                                outputStream.write(resultMessage.getBytes());
                                outputStream.write(10);
                                outputStream.flush();
                            }
                            catch (Exception exception) {}
                        }
                    } else {
                        FileListingService.FileEntry f1 = null;
                        FileListingService.FileEntry f2 = null;
                        f2 = flService.getRoot();
                        flService.getChildren(f2, false, null);
                        String[] dirs = remotePath.split("/");
                        int j = 1;
                        while (j < dirs.length - 1) {
                            f1 = f2.findChild(dirs[j]);
                            flService.getChildren(f1, false, null);
                            f2 = f1;
                            ++j;
                        }
                        FileListingService.FileEntry fileToPull = f2.findChild(dirs[dirs.length - 1]);
                        if (fileToPull != null) {
                            try {
                                service.pullFile(fileToPull, absLocalFile, syncMonitor);
                            }
                            catch (FileNotFoundException e) {
                                resultMessage = e.getLocalizedMessage();
                                AndmoreLogger.debug((String)("Pull result: " + e.getMessage()));
                            }
                            catch (SyncException e) {
                                resultMessage = e.getLocalizedMessage();
                                AndmoreLogger.debug((String)("Pull result: " + e.getMessage()));
                            }
                            catch (IOException e) {
                                resultMessage = e.getLocalizedMessage();
                                AndmoreLogger.debug((String)("Pull result: " + e.getMessage()));
                            }
                            catch (com.android.ddmlib.TimeoutException e) {
                                resultMessage = e.getLocalizedMessage();
                                AndmoreLogger.debug((String)("Pull result: " + e.getMessage()));
                            }
                            if (outputStream != null && resultMessage != null) {
                                String message = String.valueOf(NLS.bind((String)AndroidNLS.CON_ConsolePull, (Object)fileToPull.getFullPath(), (Object)absLocalFile)) + ": " + resultMessage;
                                try {
                                    outputStream.write(message.getBytes());
                                    outputStream.write(10);
                                    outputStream.flush();
                                }
                                catch (IOException iOException) {}
                            }
                        } else {
                            resultMessage = NLS.bind((String)AndroidNLS.DDMSFacade_Remote_File_Not_Found, (Object)remotePath);
                            AndmoreLogger.debug((String)("Pull result: File not found " + remotePath));
                        }
                    }
                    if (resultMessage != null) {
                        status = new Status(4, "org.eclipse.andmore.android", resultMessage);
                    }
                    if (syncMonitor.isCanceled()) {
                        status = Status.CANCEL_STATUS;
                        return status;
                    }
                    ++i;
                }
                return status;
            }
            catch (AndroidException e) {
                status = new Status(4, "org.eclipse.andmore.android", e.getMessage());
                if (service == null) return status;
                service.close();
                return status;
            }
            catch (NullPointerException nullPointerException) {
                status = new Status(4, "org.eclipse.andmore.android", AndroidNLS.ERR_DDMSFacade_FileNotFound);
                if (service == null) return status;
                service.close();
                return status;
            }
        }
        finally {
            if (service != null) {
                service.close();
            }
        }
    }

    public static boolean isApplicationRunning(String serialNumber, String applicationName) {
        IDevice dev = null;
        boolean running = false;
        dev = connectedDevices.get(serialNumber);
        if (dev != null) {
            running = dev.getClient(applicationName) != null;
        }
        return running;
    }

    public static IStatus connectTcpIp(final ISerialNumbered device, String host, String port, int timeout, IProgressMonitor monitor) throws IOException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
        subMonitor.beginTask(AndroidNLS.DDMSFacade_MsgConnectingToDeviceViaTCPIP, 10);
        IStatus status = Status.OK_STATUS;
        String serialNumber = device.getSerialNumber();
        if (!DDMSFacade.isDeviceOnline(serialNumber)) {
            String[] cmd = DDMSFacade.createConnectTcpIpCommand(host, port);
            status = DDMSFacade.executeRemoteDevicesCommand(cmd, null, timeout, NLS.bind((String)AndroidNLS.ERR_RemoteDevice_TimeoutWhileConnecting, (Object)device.getDeviceName()), new IStopCondition(){

                @Override
                public boolean canStop() {
                    String serialNumber = device.getSerialNumber();
                    if (serialNumber != null) {
                        return DDMSFacade.isDeviceOnline(serialNumber);
                    }
                    return false;
                }
            }, (IProgressMonitor)subMonitor.newChild(1000));
        }
        subMonitor.worked(1000);
        return status;
    }

    public static IStatus switchFromTCPConnectionModeToUSBConnectionMode(final ISerialNumbered device, String host, String port, int timeout, IProgressMonitor monitor) throws IOException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
        subMonitor.beginTask(AndroidNLS.DDMSFacade_MsgSwitchingDeviceFromTCPIPToUSB, 10);
        IStatus status = Status.OK_STATUS;
        String serialNumber = device.getSerialNumber();
        if (DDMSFacade.isDeviceOnline(serialNumber)) {
            String[] cmd = DDMSFacade.createSwitchToUSBConnectionModeCommand(host, port);
            status = DDMSFacade.executeRemoteDevicesCommand(cmd, null, timeout, NLS.bind((String)AndroidNLS.DDMSFacade_MsgTimeoutReachedSwitchingFromTCPToUSB, (Object)device.getDeviceName()), new IStopCondition(){

                @Override
                public boolean canStop() {
                    String serialNumber = device.getSerialNumber();
                    if (serialNumber != null) {
                        return DDMSFacade.isDeviceOnline(serialNumber);
                    }
                    return false;
                }
            }, (IProgressMonitor)subMonitor.newChild(1000));
        }
        subMonitor.worked(1000);
        if (status.isOK()) {
            AndmoreLogger.collectUsageData((String)"switched_to_usb", (String)"remote_device", (String)"operation_executed", (String)"org.eclipse.andmore.android", (String)AndroidPlugin.getDefault().getBundle().getVersion().toString());
        }
        return status;
    }

    public static String getWirelessIPfromHandset(String serialNumber, IProgressMonitor monitor) {
        String handset_wireless_ip = null;
        IDevice device = null;
        device = connectedDevices.get(serialNumber);
        if (device != null) {
            Pattern pattern;
            Matcher matcher;
            String[] result_splited;
            String result;
            Collection<String> answers;
            String wifiProperty = device.getProperty(WIFI_INTERFACE_DEVICE_PROPERTY);
            if (wifiProperty == null) {
                wifiProperty = DEFAULT_WIRELESS_DEVICE_PROPERTY;
            }
            if ((answers = DDMSFacade.executeShellCmd(serialNumber, "ifconfig " + wifiProperty, monitor)) != null && (result = answers.toString()) != null && (result_splited = result.split(" ")).length >= 3 && (matcher = (pattern = Pattern.compile(IP_PATTERN)).matcher(result)).find()) {
                handset_wireless_ip = result_splited[2];
            }
        }
        return handset_wireless_ip;
    }

    public static IStatus switchUSBtoTcpIp(String deviceName, final String serialNumber, String port, int timeout, IProgressMonitor monitor) throws IOException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
        subMonitor.beginTask(AndroidNLS.DDMSFacade_MsgSwitchingFromUSBConnection, 10);
        IStatus status = Status.OK_STATUS;
        if (DDMSFacade.isDeviceOnline(serialNumber)) {
            String[] cmd = DDMSFacade.createSwitchToTcpIpCommand(serialNumber, port);
            status = DDMSFacade.executeRemoteDevicesCommand(cmd, null, timeout, NLS.bind((String)AndroidNLS.ERR_WirelessRemoteDevice_TimeoutWhileConnecting, (Object)deviceName), new IStopCondition(){

                @Override
                public boolean canStop() {
                    if (serialNumber != null) {
                        return DDMSFacade.isDeviceOffline(serialNumber);
                    }
                    return false;
                }
            }, (IProgressMonitor)subMonitor.newChild(1000));
        }
        monitor.worked(1000);
        return status;
    }

    public static IStatus disconnectTcpIp(final ISerialNumbered device, String host, String port, int timeout, IProgressMonitor monitor) throws IOException {
        IStatus status = Status.OK_STATUS;
        String serialNumber = device.getSerialNumber();
        if (DDMSFacade.isDeviceOnline(serialNumber)) {
            String[] cmd = DDMSFacade.createDisconnectTcpIpCommand(host, port);
            status = DDMSFacade.executeRemoteDevicesCommand(cmd, null, timeout, NLS.bind((String)AndroidNLS.ERR_RemoteDevice_TimeoutWhileDisconnecting, (Object)device.getDeviceName()), new IStopCondition(){

                @Override
                public boolean canStop() {
                    String serialNumber = device.getSerialNumber();
                    return !DDMSFacade.isDeviceOnline(serialNumber);
                }
            }, monitor);
        }
        return status;
    }

    private static String[] createConnectTcpIpCommand(String host, String port) {
        String hostPort = String.valueOf(host) + ":" + port;
        String sdkPath = SdkUtils.getSdkPath();
        String[] cmd = new String[]{String.valueOf(sdkPath) + PLATFORM_TOOLS_FOLDER + File.separator + ADB_COMMAND, CONNECT_TCPIP_CMD, hostPort};
        return cmd;
    }

    private static String[] createSwitchToUSBConnectionModeCommand(String host, String port) {
        String hostPort = String.valueOf(host) + ":" + port;
        String sdkPath = SdkUtils.getSdkPath();
        String[] cmd = new String[]{String.valueOf(sdkPath) + PLATFORM_TOOLS_FOLDER + File.separator + ADB_COMMAND, "-s", hostPort, USB_SWITCH_BACK_COMMAND};
        return cmd;
    }

    private static String[] createSwitchToTcpIpCommand(String serialNumber, String port) {
        String sdkPath = SdkUtils.getSdkPath();
        String[] cmd = new String[]{String.valueOf(sdkPath) + PLATFORM_TOOLS_FOLDER + File.separator + ADB_COMMAND, "-s", serialNumber, TCPIP_CMD, port};
        return cmd;
    }

    private static String[] createDeleteFileFromDeviceCommand(String serialNumber, String file, String folder) {
        String sdkPath = SdkUtils.getSdkPath();
        File f = new File(String.valueOf(sdkPath) + PLATFORM_TOOLS_FOLDER + File.separator);
        if (!f.exists()) {
            AndmoreLogger.error((String)("Run: Could not find tools folder on " + sdkPath + PLATFORM_TOOLS_FOLDER + File.separator));
        } else if (!f.isDirectory()) {
            AndmoreLogger.error((String)("Run: Invalid tools folder " + sdkPath + PLATFORM_TOOLS_FOLDER + File.separator));
        }
        String[] cmd = new String[]{String.valueOf(sdkPath) + PLATFORM_TOOLS_FOLDER + File.separator + ADB_COMMAND, "-s", serialNumber, SHELL_CMD, "rm /" + folder + "/" + file};
        return cmd;
    }

    private static boolean deleteFileFromDevice(String serialNumber, String fileName, String folder) throws IOException {
        String[] command = DDMSFacade.createDeleteFileFromDeviceCommand(serialNumber, fileName, folder);
        IStatus status = DDMSFacade.executeRemoteDevicesCommand(command, null, 1000, "", new IStopCondition(){

            @Override
            public boolean canStop() {
                return true;
            }
        }, null);
        return status.isOK();
    }

    public static boolean hasSDCard(String serialNumber) throws IOException {
        boolean hasSdCard = false;
        File tempSdCardFile = File.createTempFile("SDcheck", ".tmp");
        boolean tempCopiedOnSdCardFile = DDMSFacade.pushFileToDevice(serialNumber, SDCARD_FOLDER, tempSdCardFile);
        if (tempCopiedOnSdCardFile) {
            if (!DDMSFacade.deleteFileFromDevice(serialNumber, tempSdCardFile.getName(), SDCARD_FOLDER)) {
                AndmoreLogger.error((String)"DDMSFacade: Could not delete tempfile from /sdcard when checking if card is enabled");
            }
            hasSdCard = true;
            tempSdCardFile.delete();
        } else {
            File tempMntFile = File.createTempFile("SDcheck", ".tmp");
            boolean tempCopiedOnMntFile = DDMSFacade.pushFileToDevice(serialNumber, MNT_SDCARD_FOLDER, tempSdCardFile);
            if (tempCopiedOnMntFile) {
                if (!DDMSFacade.deleteFileFromDevice(serialNumber, tempMntFile.getName(), MNT_SDCARD_FOLDER)) {
                    AndmoreLogger.error((String)"DDMSFacade: Could not delete tempfile from /mnt/sdcard when checking if card is enabled");
                }
                hasSdCard = true;
                tempMntFile.delete();
            }
        }
        return hasSdCard;
    }

    private static boolean pushFileToDevice(String serialNumber, String folder, File file) {
        ArrayList<String> files = new ArrayList<String>();
        files.add(file.getName());
        Path path = new Path(file.getAbsolutePath());
        IStatus status = DDMSFacade.pushFiles(serialNumber, path.removeLastSegments(1).toString(), files, folder, 2000, (IProgressMonitor)new NullProgressMonitor(), null);
        return status.isOK();
    }

    private static String[] createDisconnectTcpIpCommand(String host, String port) {
        String hostPort = String.valueOf(host) + ":" + port;
        String sdkPath = SdkUtils.getSdkPath();
        String[] cmd = new String[]{String.valueOf(sdkPath) + PLATFORM_TOOLS_FOLDER + File.separator + ADB_COMMAND, DISCONNECT_TCPIP_CMD, hostPort};
        return cmd;
    }

    public static void deleteFile(String serialNumber, String path) throws IOException {
        DDMSFacade.execRemoteApp(serialNumber, "rm " + path, (IProgressMonitor)new NullProgressMonitor());
    }

    static interface IStopCondition {
        public boolean canStop();
    }
}

