/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.command;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.PlatformUI;

abstract class NewWizardHandler
extends AbstractHandler {
    private static final int WIZARD_WIDTH = 500;

    NewWizardHandler() {
    }

    protected void openWizard(INewWizard wizard) {
        if (!PlatformUI.getWorkbench().isClosing()) {
            Shell shell = new Shell();
            ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
            Object structuredSelection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : new StructuredSelection();
            wizard.init(PlatformUI.getWorkbench(), structuredSelection);
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            dialog.setPageSize(500, -1);
            shell.pack();
            this.centralizeShell(shell);
            dialog.open();
        }
    }

    private void centralizeShell(Shell shell) {
        int displayWidth = shell.getDisplay().getClientArea().width;
        int displayHeight = shell.getDisplay().getClientArea().height;
        int x = (displayWidth - shell.getSize().x) / 2;
        int y = (displayHeight - shell.getSize().y) / 2;
        shell.setLocation(x, y);
    }
}

