/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.command;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.andmore.android.AndroidPlugin;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.common.utilities.EclipseUtils;
import org.eclipse.andmore.android.i18n.AndroidNLS;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sequoyah.localization.tools.extensions.classes.ILocalizationSchema;
import org.eclipse.sequoyah.localization.tools.managers.LocalizationManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;

public class OpenStringEditor
extends AbstractHandler {
    public static String STRING_EDITOR_ID = "org.eclipse.sequoyah.localization.tools.extensions.implementation.android.localizationEditor";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        final List supportedProjects = LocalizationManager.getInstance().getSupportedProjects();
        if (supportedProjects.size() == 0) {
            EclipseUtils.showErrorDialog((String)AndroidNLS.ERR_Localization_NoProjects_Title, (String)AndroidNLS.ERR_Localization_NoProjects_Description);
        } else {
            Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
            final ListDialog dialog = new ListDialog(shell);
            dialog.setContentProvider(new IStructuredContentProvider(){

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public Object[] getElements(Object inputElement) {
                    return supportedProjects.toArray(new Object[supportedProjects.size()]);
                }
            });
            dialog.setLabelProvider(new ILabelProvider(){

                public void removeListener(ILabelProviderListener listener) {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void dispose() {
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public String getText(Object element) {
                    IProject project = (IProject)element;
                    return project.getName();
                }

                public Image getImage(Object element) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
                }
            });
            dialog.setInput((Object)supportedProjects);
            dialog.setTitle(AndroidNLS.UI_Project_Selection);
            dialog.create();
            dialog.getOkButton().setEnabled(false);
            dialog.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    dialog.getOkButton().setEnabled(!event.getSelection().isEmpty());
                }
            });
            dialog.open();
            Object[] result = dialog.getResult();
            if (result != null && result.length > 0) {
                IProject project = (IProject)result[0];
                try {
                    ILocalizationSchema localizationSchema = LocalizationManager.getInstance().getLocalizationSchema(project);
                    if (localizationSchema != null) {
                        Map files = localizationSchema.getLocalizationFiles(project);
                        if (files.size() > 0) {
                            ArrayList<String> malformedXMLFiles = new ArrayList<String>();
                            for (IFile file : files.values()) {
                                try {
                                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                                    DocumentBuilder builder = factory.newDocumentBuilder();
                                    builder.parse(file.getContents());
                                }
                                catch (Exception exception) {
                                    malformedXMLFiles.add(file.getFullPath().toPortableString());
                                }
                            }
                            if (malformedXMLFiles.isEmpty()) {
                                IFile inputFile = (IFile)new ArrayList(files.values()).get(0);
                                FileEditorInput fileEditor = new FileEditorInput(inputFile);
                                IWorkbenchWindow wbWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                                IWorkbenchPage wbPage = wbWindow.getActivePage();
                                wbPage.openEditor((IEditorInput)fileEditor, STRING_EDITOR_ID);
                                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new ProjectCloseListener(fileEditor, wbWindow, wbPage), 2);
                            } else {
                                AndmoreLogger.error((String)("Cannot open Localization Files Editor - XML(s) Malformed: " + malformedXMLFiles));
                                EclipseUtils.showErrorDialog((String)AndroidNLS.ERR_Localization_XMLMalformed_Title, (String)NLS.bind((String)AndroidNLS.ERR_Localization_XMLMalformed_Description, (Object)((Object)malformedXMLFiles).toString()));
                            }
                        } else {
                            EclipseUtils.showErrorDialog((String)AndroidNLS.ERR_Localization_NoFiles_Title, (String)AndroidNLS.ERR_Localization_NoFiles_Description);
                        }
                    }
                    AndmoreLogger.collectUsageData((String)"Localization Editor openned", (String)"Localization Editor", (String)"operation_executed", (String)"org.eclipse.andmore.android", (String)AndroidPlugin.getDefault().getBundle().getVersion().toString());
                }
                catch (PartInitException partInitException) {
                    AndmoreLogger.error((String)"Cannot open Localization Files Editor");
                }
            }
        }
        return null;
    }

    private class ProjectCloseListener
    implements IResourceChangeListener {
        private FileEditorInput fileEditor;
        private IWorkbenchWindow wbWindow;
        private IWorkbenchPage wbPage;

        public ProjectCloseListener(FileEditorInput fileEditor, IWorkbenchWindow wbWindow, IWorkbenchPage wbPage) {
            this.fileEditor = fileEditor;
            this.wbWindow = wbWindow;
            this.wbPage = wbPage;
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IProject closedProject = (IProject)event.getResource();
            if (this.fileEditor.getFile().getProject().equals((Object)closedProject)) {
                final IEditorPart part = this.wbPage.findEditor((IEditorInput)this.fileEditor);
                if (part != null) {
                    this.wbWindow.getShell().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ProjectCloseListener.this.wbPage.closeEditor(part, true);
                        }
                    });
                }
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            }
        }
    }
}

