/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.devices;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.andmore.android.DDMSFacade;
import org.eclipse.andmore.android.ISerialNumbered;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.sequoyah.device.common.utilities.exception.SequoyahException;
import org.eclipse.sequoyah.device.framework.DeviceUtils;
import org.eclipse.sequoyah.device.framework.factory.DeviceTypeRegistry;
import org.eclipse.sequoyah.device.framework.factory.InstanceRegistry;
import org.eclipse.sequoyah.device.framework.manager.InstanceManager;
import org.eclipse.sequoyah.device.framework.model.IDeviceType;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.sequoyah.device.framework.model.IInstanceBuilder;
import org.eclipse.sequoyah.device.framework.model.IService;
import org.eclipse.sequoyah.device.framework.model.handler.IServiceHandler;

public class DevicesManager {
    private static DevicesManager instance;

    public static DevicesManager getInstance() {
        if (instance == null) {
            instance = new DevicesManager();
        }
        return instance;
    }

    public Collection<ISerialNumbered> getAllDevices() {
        LinkedHashSet<ISerialNumbered> devicesCollection = new LinkedHashSet<ISerialNumbered>();
        List tmlDevices = InstanceRegistry.getInstance().getInstances();
        for (IInstance tmlInstance : tmlDevices) {
            if (!(tmlInstance instanceof ISerialNumbered)) continue;
            devicesCollection.add((ISerialNumbered)tmlInstance);
        }
        return devicesCollection;
    }

    public Collection<ISerialNumbered> getAllDevices(Comparator<ISerialNumbered> comparator) {
        TreeSet<ISerialNumbered> sortedDevices = new TreeSet<ISerialNumbered>(comparator);
        sortedDevices.addAll(this.getAllDevices());
        return sortedDevices;
    }

    public Collection<ISerialNumbered> getAllDevicesSorted() {
        return this.getAllDevices(DevicesManager.getDefaultComparator());
    }

    public ISerialNumbered getDeviceByName(String name) {
        ISerialNumbered instanceToReturn = null;
        for (ISerialNumbered device : this.getAllDevices()) {
            if (!device.getDeviceName().equals(name)) continue;
            instanceToReturn = device;
            break;
        }
        return instanceToReturn;
    }

    public ISerialNumbered getDeviceBySerialNumber(String serial) {
        ISerialNumbered instanceToReturn = null;
        String serialNumber = "";
        for (ISerialNumbered device : this.getAllDevices()) {
            serialNumber = device.getSerialNumber();
            if (serialNumber == null || !serialNumber.equals(serial)) continue;
            instanceToReturn = device;
            break;
        }
        return instanceToReturn;
    }

    public Collection<ISerialNumbered> getInstancesByType(Class type) {
        LinkedHashSet<ISerialNumbered> instancesToReturn = new LinkedHashSet<ISerialNumbered>();
        for (ISerialNumbered device : this.getAllDevices()) {
            if (!device.getClass().equals(type)) continue;
            instancesToReturn.add(device);
        }
        return instancesToReturn;
    }

    public Collection<ISerialNumbered> getOnlineDevicesByType(Class type) {
        HashSet<ISerialNumbered> instancesToReturn = new HashSet<ISerialNumbered>();
        String serialNumber = null;
        for (ISerialNumbered device : this.getInstancesByType(type)) {
            serialNumber = device.getSerialNumber();
            if (serialNumber == null || !DDMSFacade.isDeviceOnline(serialNumber)) continue;
            instancesToReturn.add(device);
        }
        return instancesToReturn;
    }

    public static Comparator<ISerialNumbered> getDefaultComparator() {
        return new Comparator<ISerialNumbered>(){

            @Override
            public int compare(ISerialNumbered serial1, ISerialNumbered serial2) {
                boolean dev2online;
                String name1 = serial1.getDeviceName();
                String name2 = serial2.getDeviceName();
                boolean dev1online = serial1.getSerialNumber() != null;
                boolean bl = dev2online = serial2.getSerialNumber() != null;
                int compareResult = dev1online && dev2online || !dev1online && !dev2online ? name1.compareToIgnoreCase(name2) : (dev1online ? -1 : 1);
                return compareResult;
            }
        };
    }

    public void createInstanceForDevice(String serialNumber, String deviceTypeID, IInstanceBuilder instanceBuilder, String initServiceID) throws SequoyahException {
        ISerialNumbered instance = this.getDeviceBySerialNumber(serialNumber);
        if (instance == null) {
            IDeviceType tmlDeviceType = DeviceTypeRegistry.getInstance().getDeviceTypeById(deviceTypeID);
            InstanceManager.createProject((IDeviceType)tmlDeviceType, (IInstanceBuilder)instanceBuilder, (IProgressMonitor)new NullProgressMonitor());
            IInstance newInstance = (IInstance)this.getDeviceBySerialNumber(serialNumber);
            IService service = DeviceUtils.getServiceById((IDeviceType)tmlDeviceType, (String)initServiceID);
            IServiceHandler handler = service.getHandler();
            handler.run(newInstance);
        }
    }

    public void deleteInstanceOfDevice(String serialNumber) {
        IInstance instanceToDelete = (IInstance)this.getDeviceBySerialNumber(serialNumber);
        if (instanceToDelete != null) {
            InstanceManager.deleteInstance((IInstance)instanceToDelete);
        }
    }
}

