/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.nativeos;

import org.eclipse.andmore.android.SdkUtils;
import org.eclipse.andmore.android.common.log.AndmoreLogger;
import org.eclipse.andmore.android.nativeos.INativeUI;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

public class NativeUIUtils {
    private static INativeUI instance;

    private NativeUIUtils() {
    }

    public static INativeUI getInstance() {
        if (instance == null) {
            instance = (INativeUI)NativeUIUtils.getClass("org.eclipse.andmore.android.nativeos.NativeUI");
        }
        return instance;
    }

    public static Object getClass(String nameClass) {
        try {
            return Class.forName(nameClass).newInstance();
        }
        catch (Exception ex) {
            AndmoreLogger.error(NativeUIUtils.class, (String)"Error resolving OS dependent class for native windows feature", (Throwable)ex);
            return null;
        }
    }

    public static String getDefaultCommandLine() {
        return NativeUIUtils.getInstance().getDefaultCommandLine();
    }

    public static String getDefaultUseVnc() {
        return NativeUIUtils.getInstance().getDefaultUseVnc();
    }

    public static long getWindowHandle(String avdName, int instancePort) {
        String windowName = SdkUtils.getEmulatorWindowName(avdName, instancePort);
        return NativeUIUtils.getInstance().getWindowHandle(windowName);
    }

    public static long getWindowProperties(long windowHandle) {
        return NativeUIUtils.getInstance().getWindowProperties(windowHandle);
    }

    public static Point getWindowSize(long originalParentHandle, long windowHandle) {
        return NativeUIUtils.getInstance().getWindowSize(originalParentHandle, windowHandle);
    }

    public static void hideWindow(long windowHandle) {
        NativeUIUtils.getInstance().hideWindow(windowHandle);
    }

    public static boolean isWindowEnabled(long windowHandle) {
        return NativeUIUtils.getInstance().isWindowEnabled(windowHandle);
    }

    public static void restoreWindow(long windowHandle) {
        NativeUIUtils.getInstance().restoreWindow(windowHandle);
    }

    public static void sendNextLayoutCommand(long originalParent, long windowHandle) {
        NativeUIUtils.getInstance().sendNextLayoutCommand(originalParent, windowHandle);
    }

    public static void setWindowFocus(long windowHandle) {
        NativeUIUtils.getInstance().setWindowFocus(windowHandle);
    }

    public static long embedWindow(long windowHandle, Composite composite) {
        return NativeUIUtils.getInstance().embedWindow(windowHandle, composite);
    }

    public static void unembedWindow(long windowHandle, long originalParent) {
        NativeUIUtils.getInstance().unembedWindow(windowHandle, originalParent);
    }

    public static void setWindowProperties(long windowHandle, long originalProperties) {
        NativeUIUtils.getInstance().setWindowProperties(windowHandle, originalProperties);
    }

    public static void setWindowStyle(long windowHandle) {
        NativeUIUtils.getInstance().setWindowStyle(windowHandle);
    }

    public static void showWindow(long windowHandle) {
        NativeUIUtils.getInstance().showWindow(windowHandle);
    }
}

