/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.wizards.elements;

import com.android.sdklib.IAndroidTarget;
import org.eclipse.andmore.android.AndroidPlugin;
import org.eclipse.andmore.android.SdkUtils;
import org.eclipse.andmore.android.i18n.AndroidNLS;
import org.eclipse.andmore.android.model.AndroidProject;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class SdkTargetSelector
extends Composite {
    private Table table;
    private Label mDescription;
    private final AndroidProject project;
    private IAndroidTarget selection = null;
    private final SelectionListener listener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
            if (e.item instanceof TableItem) {
                TableItem i;
                i.setChecked(!(i = (TableItem)e.item).getChecked());
                this.enforceSingleSelection(i);
                SdkTargetSelector.this.updateDescription(i);
                IAndroidTarget newSelection = SdkTargetSelector.this.getSelection();
                SdkTargetSelector.this.project.setSdkTarget(newSelection);
                if (newSelection != null) {
                    SdkTargetSelector.this.project.setMinSdkVersion(SdkTargetSelector.this.getSelection().getVersion().getApiString());
                }
                SdkTargetSelector.this.notifyListeners(1546, new Event());
            }
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.item instanceof TableItem) {
                TableItem i = (TableItem)e.item;
                this.enforceSingleSelection(i);
                SdkTargetSelector.this.updateDescription(i);
                IAndroidTarget newSelection = SdkTargetSelector.this.getSelection();
                SdkTargetSelector.this.project.setSdkTarget(newSelection);
                SdkTargetSelector.this.selection = newSelection;
                SdkTargetSelector.this.project.setSample(null);
                SdkTargetSelector.this.notifyListeners(1546, new Event());
            }
        }

        private void enforceSingleSelection(TableItem item) {
            if (item.getChecked()) {
                Table parentTable = item.getParent();
                TableItem[] tableItemArray = parentTable.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem i2 = tableItemArray[n2];
                    if (i2 != item && i2.getChecked()) {
                        i2.setChecked(false);
                    }
                    ++n2;
                }
            }
        }
    };
    private final Listener toolTipListener = new Listener(){

        public void handleEvent(Event event) {
            switch (event.type) {
                case 32: {
                    SdkTargetSelector.this.updateDescription(SdkTargetSelector.this.table.getItem(new Point(event.x, event.y)));
                    break;
                }
                case 13: {
                    if (!(event.item instanceof TableItem)) break;
                    SdkTargetSelector.this.updateDescription((TableItem)event.item);
                    break;
                }
                default: {
                    return;
                }
            }
        }
    };

    public SdkTargetSelector(Composite parent, AndroidProject project) {
        super(parent, 0);
        this.project = project;
        this.createContents(parent);
    }

    private void createContents(Composite parent) {
        this.setLayout((Layout)new GridLayout());
        this.setLayoutData(new GridData(1808));
        this.setFont(parent.getFont());
        this.table = new Table((Composite)this, 67620);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(false);
        this.table.setLayoutData((Object)new GridData(1808));
        this.mDescription = new Label((Composite)this, 64);
        this.mDescription.setLayoutData((Object)new GridData(768));
        this.createColumns(this.table);
        this.table.addSelectionListener(this.listener);
        this.fillTable();
        this.setupTooltip(this.table);
    }

    private void createColumns(final Table table) {
        final TableColumn nameColumn = new TableColumn(table, 0);
        nameColumn.setText(AndroidNLS.UI_SdkTargetSelector_SdkTargetNameColumn);
        final TableColumn vendorColumn = new TableColumn(table, 0);
        vendorColumn.setText(AndroidNLS.UI_SdkTargetSelector_VendorNameColumn);
        final TableColumn apiColumn = new TableColumn(table, 0);
        apiColumn.setText(AndroidNLS.UI_SdkTargetSelector_APILevelColumn);
        final TableColumn sdkColumn = new TableColumn(table, 0);
        sdkColumn.setText(AndroidNLS.UI_SdkTargetSelector_SDKVersionColumn);
        table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = table.getClientArea();
                nameColumn.setWidth(r.width * 25 / 100);
                vendorColumn.setWidth(r.width * 50 / 100);
                apiColumn.setWidth(r.width * 15 / 100);
                sdkColumn.setWidth(r.width * 10 / 100);
            }
        });
    }

    protected IAndroidTarget getSelection() {
        IAndroidTarget selectedItem = null;
        TableItem[] tableItemArray = this.table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            Object data = item.getData();
            if (item.getChecked() && data instanceof IAndroidTarget) {
                selectedItem = (IAndroidTarget)data;
                break;
            }
            ++n2;
        }
        return selectedItem;
    }

    private void fillTable() {
        IAndroidTarget[] targets = null;
        if (SdkUtils.getCurrentSdk() != null) {
            targets = SdkUtils.getAllTargets();
        } else {
            final Runnable listener = new Runnable(){

                @Override
                public void run() {
                    SdkTargetSelector.this.table.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            SdkTargetSelector.this.table.removeAll();
                            SdkTargetSelector.this.fillTable();
                            AndroidPlugin.getDefault().removeSDKLoaderListener(this);
                        }
                    });
                }
            };
            AndroidPlugin.getDefault().addSDKLoaderListener(listener);
            this.table.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    AndroidPlugin.getDefault().removeSDKLoaderListener(listener);
                }
            });
        }
        if (targets != null && targets.length > 0) {
            this.table.setEnabled(true);
            IAndroidTarget[] iAndroidTargetArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                IAndroidTarget target = iAndroidTargetArray[n2];
                TableItem item = new TableItem(this.table, 0);
                item.setData((Object)target);
                item.setText(0, target.getName());
                item.setText(1, target.getVendor());
                item.setText(2, target.getVersion().getApiString());
                item.setText(3, target.getVersionName());
                if (target == this.project.getSdkTarget()) {
                    item.setChecked(true);
                    this.selection = target;
                }
                ++n2;
            }
        } else {
            this.table.setEnabled(false);
            TableItem item = new TableItem(this.table, 0);
            item.setData(null);
            item.setText(0, AndroidNLS.UI_SdkTargetSelector_EmptyValue);
            item.setText(1, AndroidNLS.UI_SdkTargetSelector_NoTargetAvailable);
            item.setText(2, AndroidNLS.UI_SdkTargetSelector_EmptyValue);
            item.setText(3, AndroidNLS.UI_SdkTargetSelector_EmptyValue);
        }
    }

    private void setupTooltip(Table table) {
        table.addListener(12, this.toolTipListener);
        table.addListener(32, this.toolTipListener);
        table.addListener(5, this.toolTipListener);
        table.addListener(1, this.toolTipListener);
    }

    private void updateDescription(TableItem item) {
        if (item != null) {
            Object data = item.getData();
            if (data instanceof IAndroidTarget) {
                String newTooltip = ((IAndroidTarget)data).getDescription();
                this.mDescription.setText(newTooltip == null ? "" : newTooltip);
            }
        } else {
            this.mDescription.setText("");
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.getEnabled() != enabled) {
            this.table.setEnabled(enabled);
            this.mDescription.setEnabled(enabled);
            super.setEnabled(enabled);
        }
    }
}

