/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.wizards.elements;

import org.eclipse.andmore.android.i18n.AndroidNLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public abstract class TableWithLoadingInfo<P, E, V>
extends Composite {
    E elementList;
    private Thread animatedText;
    private String animatedTextLabel = null;
    private final SelectionListener deselectionItem;
    private final Table table;
    private P callingPage;

    public void setCallingPage(P callingPage) {
        this.callingPage = callingPage;
    }

    public P getCallingPage() {
        return this.callingPage;
    }

    public Table getTable() {
        return this.table;
    }

    public E getElementList() {
        return this.elementList;
    }

    public void populateTable(E elementList) {
        this.elementList = elementList;
        if (this.animatedText != null) {
            this.animatedText.interrupt();
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (!TableWithLoadingInfo.this.table.isDisposed()) {
                    TableWithLoadingInfo.this.table.removeAll();
                    TableWithLoadingInfo.this.populateTable();
                }
            }
        });
        this.elementList = elementList;
    }

    public TableWithLoadingInfo(Composite parent, int style, String animatedTextLabel, P callingPage) {
        super(parent, 4);
        GridLayout layout = new GridLayout();
        this.setLayout((Layout)layout);
        this.table = new Table((Composite)this, style);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.animatedTextLabel = animatedTextLabel;
        this.setCallingPage(callingPage);
        this.deselectionItem = new DeselectListener(this.table);
    }

    public void removeAllTableItems() {
        this.table.removeAll();
    }

    public TableColumn addTableColumn(int columnStyle, int tableIndex) {
        return new TableColumn(this.table, columnStyle, tableIndex);
    }

    public TableColumn addTableColumn(int columnStyle) {
        return new TableColumn(this.table, columnStyle);
    }

    public void addTableSelectionListener(SelectionListener selectionListener) {
        this.table.addSelectionListener(selectionListener);
    }

    public int getTableSelectionCont() {
        return this.table.getSelectionCount();
    }

    public int getTableSelectionIndex() {
        return this.table.getSelectionIndex();
    }

    public int[] getSelectionIndices() {
        return this.table.getSelectionIndices();
    }

    public TableItem[] getTableSelection() {
        return this.table.getSelection();
    }

    public TableItem[] getTableItems() {
        return this.table.getItems();
    }

    public TableItem getTableItem(int index) {
        return this.table.getItem(index);
    }

    public void setTableLinesVisible(boolean show) {
        this.table.setLinesVisible(show);
    }

    public void setTableHeaderVisible(boolean show) {
        this.table.setHeaderVisible(show);
    }

    public int getTableSelectionCount() {
        return this.table.getSelectionCount();
    }

    public void deselectAllTableItems() {
        this.table.deselectAll();
    }

    public void setTableSelection(TableItem[] item) {
        this.table.setSelection(item);
    }

    protected abstract E callServiceForRetrievingDataToPopulateTable(V var1);

    protected abstract void addTableData(E var1);

    protected abstract void executeOperationsAfterTableIsPopulated();

    public void populateTableAsynchronously(final V asynchronousServiceParameters) {
        this.elementList = null;
        this.populateTable();
        Thread callServiceThread = new Thread("listPackages"){

            @Override
            public void run() {
                Object elementList = TableWithLoadingInfo.this.callServiceForRetrievingDataToPopulateTable(asynchronousServiceParameters);
                TableWithLoadingInfo.this.populateTable(elementList);
            }
        };
        callServiceThread.start();
    }

    private synchronized void populateTable() {
        if (this.elementList != null) {
            this.table.clearAll();
            if (this.deselectionItem != null) {
                this.table.removeSelectionListener(this.deselectionItem);
            }
            this.addTableData(this.elementList);
        } else {
            this.table.addSelectionListener(this.deselectionItem);
            TableItem item = new TableItem(this.table, 0);
            this.animatedText = new LoadingInfoAnimationThread("TextAnimator", this.table, item);
            this.animatedText.start();
        }
        this.executeOperationsAfterTableIsPopulated();
    }

    private class DeselectListener
    implements SelectionListener {
        Table table;

        public DeselectListener(Table table) {
            this.table = table;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.table.deselectAll();
        }

        public void widgetSelected(SelectionEvent e) {
            this.table.deselectAll();
        }
    }

    private final class LoadingInfoAnimationThread
    extends Thread {
        private TableItem item;
        private final Table table;

        private LoadingInfoAnimationThread(String threadName, Table table, TableItem item) {
            super(threadName);
            this.table = table;
            this.item = item;
        }

        @Override
        public void run() {
            int i = 0;
            while (!this.isInterrupted()) {
                StringBuffer text = new StringBuffer(TableWithLoadingInfo.this.animatedTextLabel != null ? TableWithLoadingInfo.this.animatedTextLabel : AndroidNLS.TableWithLoadingInfo__UI_LoadingData);
                int j = 0;
                while (j < i % 4) {
                    text = text.append(".");
                    ++j;
                }
                final StringBuffer finalText = new StringBuffer(text);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (LoadingInfoAnimationThread.this.item.isDisposed()) {
                            LoadingInfoAnimationThread.this.item = new TableItem(LoadingInfoAnimationThread.this.table, 0);
                        }
                        LoadingInfoAnimationThread.this.item.setText(0, finalText.toString());
                    }
                });
                ++i;
                try {
                    LoadingInfoAnimationThread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
    }
}

