/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.android.wizards.elements.sorting;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.andmore.android.wizards.elements.sorting.TableItemStringComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class TableItemSortStringSetActionListener
implements SelectionListener {
    public void widgetDefaultSelected(SelectionEvent e) {
        this.sortTable(e);
    }

    public void widgetSelected(SelectionEvent e) {
        this.sortTable(e);
    }

    private void sortTable(SelectionEvent e) {
        TableColumn column = (TableColumn)e.widget;
        Table table = column.getParent();
        TableItem[] selectedItems = table.getSelection();
        ArrayList<TableItem> selectedItemsAfterSorting = new ArrayList<TableItem>();
        int sortDirection = table.getSortDirection();
        sortDirection = sortDirection == 128 ? 1024 : 128;
        TableItem[] items = table.getItems();
        if (items != null && items.length > 0) {
            Arrays.sort(items, new TableItemStringComparator(table.indexOf(column), sortDirection == 128 ? TableItemStringComparator.SortDirection.ASCENDING : TableItemStringComparator.SortDirection.DESCENDING));
            TableItem newItem = null;
            TableItem item = null;
            int rowIndex = 0;
            while (rowIndex < items.length) {
                item = items[rowIndex];
                newItem = new TableItem(table, 0, rowIndex);
                newItem.setText(this.getTableItemData(item));
                if (this.isElementInArray(item, selectedItems)) {
                    selectedItemsAfterSorting.add(newItem);
                }
                item.dispose();
                ++rowIndex;
            }
        }
        TableItem[] selectedItemsAfterSortingArray = new TableItem[selectedItemsAfterSorting.size()];
        int rowIndex = 0;
        while (rowIndex < selectedItemsAfterSortingArray.length) {
            selectedItemsAfterSortingArray[rowIndex] = (TableItem)selectedItemsAfterSorting.get(rowIndex);
            ++rowIndex;
        }
        table.setSelection(selectedItemsAfterSortingArray);
        table.setSortDirection(sortDirection);
        table.setSortColumn(column);
        table.setRedraw(true);
    }

    private <E> boolean isElementInArray(E element, E[] array) {
        boolean hasElement = false;
        if (element != null && array != null && array.length > 0) {
            E[] EArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                E arrayItem = EArray[n2];
                if (arrayItem.equals(element)) {
                    hasElement = true;
                    break;
                }
                ++n2;
            }
        }
        return hasElement;
    }

    private String[] getTableItemData(TableItem tableItem) {
        int columnCount;
        String[] itemArray = new String[]{};
        Table table = tableItem.getParent();
        if (table != null && (columnCount = table.getColumnCount()) > 0) {
            itemArray = new String[columnCount];
            int columnIndex = 0;
            while (columnIndex < columnCount) {
                itemArray[columnIndex] = tableItem.getText(columnIndex);
                ++columnIndex;
            }
        }
        return itemArray;
    }
}

