/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.ddms;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.ddmuilib.logcat.ILogCatBufferChangeListener;
import com.android.ddmuilib.logcat.LogCatReceiver;
import com.android.ddmuilib.logcat.LogCatReceiverFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.andmore.ddms.IDebuggerConnector;
import org.eclipse.andmore.ddms.LogCatMonitorDialog;
import org.eclipse.andmore.ddms.views.LogCatView;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class LogCatMonitor {
    public static final String AUTO_MONITOR_PREFKEY = "ddms.logcat.automonitor";
    public static final String AUTO_MONITOR_LOGLEVEL = "ddms.logcat.auotmonitor.level";
    private static final String AUTO_MONITOR_PROMPT_SHOWN = "ddms.logcat.automonitor.userprompt";
    private IPreferenceStore mPrefStore;
    private Map<String, DeviceData> mMonitoredDevices;
    private IDebuggerConnector[] mConnectors;
    private int mMinMessagePriority;
    final AtomicBoolean mMonitorEnabled = new AtomicBoolean(false);

    public LogCatMonitor(IDebuggerConnector[] debuggerConnectors, IPreferenceStore prefStore) {
        this.mConnectors = debuggerConnectors;
        this.mPrefStore = prefStore;
        this.mMinMessagePriority = Log.LogLevel.getByString((String)this.mPrefStore.getString(AUTO_MONITOR_LOGLEVEL)).getPriority();
        this.mMonitoredDevices = new HashMap<String, DeviceData>();
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)new AndroidDebugBridge.IDeviceChangeListener(){

            public void deviceDisconnected(IDevice device) {
                LogCatMonitor.this.unmonitorDevice(device.getSerialNumber());
                LogCatMonitor.this.mMonitoredDevices.remove(device.getSerialNumber());
            }

            public void deviceConnected(IDevice device) {
            }

            public void deviceChanged(IDevice device, int changeMask) {
            }
        });
        this.mPrefStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (LogCatMonitor.AUTO_MONITOR_PREFKEY.equals(event.getProperty()) && event.getNewValue().equals(false)) {
                    LogCatMonitor.this.unmonitorAllDevices();
                } else if (LogCatMonitor.AUTO_MONITOR_LOGLEVEL.equals(event.getProperty())) {
                    LogCatMonitor.this.mMinMessagePriority = Log.LogLevel.getByString((String)((String)event.getNewValue())).getPriority();
                }
            }
        });
    }

    private void unmonitorAllDevices() {
        for (String device : this.mMonitoredDevices.keySet()) {
            this.unmonitorDevice(device);
        }
        this.mMonitoredDevices.clear();
    }

    private void unmonitorDevice(String deviceSerial) {
        DeviceData data = this.mMonitoredDevices.get(deviceSerial);
        if (data == null) {
            return;
        }
        data.receiver.removeMessageReceivedEventListener(data.bufferChangeListener);
    }

    public void monitorDevice(final IDevice device) {
        if (!this.mPrefStore.getBoolean(AUTO_MONITOR_PREFKEY)) {
            return;
        }
        this.mMonitorEnabled.set(true);
        if (this.mMonitoredDevices.keySet().contains(device.getSerialNumber())) {
            return;
        }
        LogCatReceiver r = LogCatReceiverFactory.INSTANCE.newReceiver(device, this.mPrefStore);
        ILogCatBufferChangeListener l = new ILogCatBufferChangeListener(){

            public void bufferChanged(List<LogCatMessage> addedMessages, List<LogCatMessage> deletedMessages) {
                LogCatMonitor.this.checkMessages(addedMessages, device);
            }
        };
        r.addMessageReceivedEventListener(l);
        this.mMonitoredDevices.put(device.getSerialNumber(), new DeviceData(r, l));
    }

    private void checkMessages(List<LogCatMessage> receivedMessages, IDevice device) {
        if (!this.mMonitorEnabled.get()) {
            return;
        }
        for (LogCatMessage m : receivedMessages) {
            if (!this.isImportantMessage(m)) continue;
            this.focusLogCatView(device, m.getAppName());
            this.mMonitorEnabled.set(false);
            break;
        }
    }

    private boolean isImportantMessage(LogCatMessage m) {
        if (m.getLogLevel().getPriority() < this.mMinMessagePriority) {
            return false;
        }
        String app = m.getAppName();
        IDebuggerConnector[] iDebuggerConnectorArray = this.mConnectors;
        int n = this.mConnectors.length;
        int n2 = 0;
        while (n2 < n) {
            IDebuggerConnector c = iDebuggerConnectorArray[n2];
            if (c.isWorkspaceApp(app)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void focusLogCatView(final IDevice device, final String appName) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                boolean showLogCatView;
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window == null) {
                    return;
                }
                IWorkbenchPage page = window.getActivePage();
                if (page == null) {
                    return;
                }
                if (!this.isLogCatViewVisible(page) && !(showLogCatView = this.promptUserOnce(page.getWorkbenchWindow().getShell()))) {
                    return;
                }
                LogCatView v = this.displayLogCatView(page);
                if (v == null) {
                    return;
                }
                v.selectionChanged(device);
                v.selectTransientAppFilter(appName);
            }

            private boolean isLogCatViewVisible(IWorkbenchPage page) {
                IViewPart view = page.findView("org.eclipse.andmore.ddms.views.LogCatView");
                return view != null && page.isPartVisible((IWorkbenchPart)view);
            }

            private LogCatView displayLogCatView(IWorkbenchPage page) {
                IViewPart view = page.findView("org.eclipse.andmore.ddms.views.LogCatView");
                if (view != null) {
                    page.bringToTop((IWorkbenchPart)view);
                    if (view instanceof LogCatView) {
                        return (LogCatView)view;
                    }
                }
                try {
                    return (LogCatView)page.showView("org.eclipse.andmore.ddms.views.LogCatView");
                }
                catch (PartInitException partInitException) {
                    return null;
                }
            }

            private boolean promptUserOnce(Shell shell) {
                boolean promptShown = LogCatMonitor.this.mPrefStore.getBoolean(LogCatMonitor.AUTO_MONITOR_PROMPT_SHOWN);
                if (promptShown) {
                    return LogCatMonitor.this.mPrefStore.getBoolean(LogCatMonitor.AUTO_MONITOR_PREFKEY);
                }
                LogCatMonitorDialog dlg = new LogCatMonitorDialog(shell);
                int r = dlg.open();
                LogCatMonitor.this.mPrefStore.setValue(LogCatMonitor.AUTO_MONITOR_PROMPT_SHOWN, true);
                LogCatMonitor.this.mPrefStore.setValue(LogCatMonitor.AUTO_MONITOR_PREFKEY, dlg.shouldMonitor());
                LogCatMonitor.this.mPrefStore.setValue(LogCatMonitor.AUTO_MONITOR_LOGLEVEL, dlg.getMinimumPriority());
                return r == 0 && dlg.shouldMonitor();
            }
        });
    }

    private static class DeviceData {
        public final LogCatReceiver receiver;
        public final ILogCatBufferChangeListener bufferChangeListener;

        public DeviceData(LogCatReceiver r, ILogCatBufferChangeListener l) {
            this.receiver = r;
            this.bufferChangeListener = l;
        }
    }
}

