/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.ddms.views;

import com.android.ddmuilib.ITableFocusListener;
import com.android.ddmuilib.TablePanel;
import org.eclipse.andmore.ddms.i18n.Messages;
import org.eclipse.andmore.ddms.views.SelectionDependentViewPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;

public abstract class TableView
extends SelectionDependentViewPart {
    ITableFocusListener.IFocusedTableActivator mActivator = null;
    private Clipboard mClipboard;
    private Action mCopyAction;
    private Action mSelectAllAction;

    void setupTableFocusListener(TablePanel panel, Composite parent) {
        panel.setTableFocusListener(new ITableFocusListener(){

            public void focusGained(ITableFocusListener.IFocusedTableActivator activator) {
                TableView.this.mActivator = activator;
                TableView.this.mCopyAction.setEnabled(true);
                TableView.this.mSelectAllAction.setEnabled(true);
            }

            public void focusLost(ITableFocusListener.IFocusedTableActivator activator) {
                if (activator == TableView.this.mActivator) {
                    TableView.this.mActivator = null;
                    TableView.this.mCopyAction.setEnabled(false);
                    TableView.this.mSelectAllAction.setEnabled(false);
                }
            }
        });
        this.mClipboard = new Clipboard(parent.getDisplay());
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.mCopyAction = new Action(Messages.TableView_Copy){

            public void run() {
                if (TableView.this.mActivator != null) {
                    TableView.this.mActivator.copy(TableView.this.mClipboard);
                }
            }
        };
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.mCopyAction);
        this.mSelectAllAction = new Action(Messages.TableView_Select_All){

            public void run() {
                if (TableView.this.mActivator != null) {
                    TableView.this.mActivator.selectAll();
                }
            }
        };
        actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.mSelectAllAction);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mClipboard.dispose();
    }
}

