/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.eclipse.andmore.gltrace.state;

public class GLStringProperty extends GLAbstractAtomicProperty {
	private final String mDefaultValue;
	private String mCurrentValue;

	public GLStringProperty(GLStateType type, String defaultValue) {
		super(type);

		mDefaultValue = mCurrentValue = defaultValue;
	}

	@Override
	public boolean isDefault() {
		return mDefaultValue.equalsIgnoreCase(mCurrentValue);
	}

	@Override
	public void setValue(Object value) {
		if (value instanceof String) {
			mCurrentValue = (String) value;
		} else {
			throw new IllegalArgumentException("Attempt to set non-string value for " //$NON-NLS-1$
					+ getType());
		}
	}

	public void setValue(String value) {
		mCurrentValue = value;
	}

	@Override
	public Object getValue() {
		return mCurrentValue;
	}

	@Override
	public String getStringValue() {
		return mCurrentValue;
	}

	@Override
	public String toString() {
		return getType() + "=" + getStringValue(); //$NON-NLS-1$
	};
}
